﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Services.Component;
using Microsoft.AspNetCore.Mvc;
using System;

namespace Bailun.DC.Web.Areas.Component.Controllers
{
    [Area("Component")]
    public class MenuController : Base.BaseController
    {
        [HttpGet]

        public JsonResult Get(int? id = null)
        {
            ResultDTO result = new ResultDTO();
            try
            {
                result.Data = new MenuService().Get(id);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Save([FromBody] MenuDTO dto)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new MenuService().Save(dto);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Enable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new MenuService().Save(id, false);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);

        }

        [HttpPost]
        public JsonResult Disable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new MenuService().Save(id, true);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

    }
}
