﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Services.Component;
using Dapper;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;
using Newtonsoft.Json.Linq;

namespace Bailun.DC.Web.Areas.Component.Controllers
{
    [Area("Component")]
    public class DictionaryController : Base.BaseController
    {
        public JsonResult GetList()
        {
            ResultDTO result = new ResultDTO();
            try
            {
                DynamicParameters sqlparam = new DynamicParameters();
                switch (Request.Method)
                {
                    case "GET":
                        Request.Query.Keys.ForEach(l => sqlparam.Add(l, (Request.Query[l].Count > 0 ? (object)Request.Query[l].ToArray() : Request.Query[l])));
                        break;
                    case "POST":
                        if (Request.ContentType.Contains("multipart/form-data"))
                        {
                            Request.Form.Keys.ForEach(l => sqlparam.Add(l, Request.Form[l]));
                        }
                        else if (Request.ContentType.Contains("application/json"))
                        {
                            using (Stream stream = Request.Body)
                            {
                                byte[] buffer = new byte[Request.ContentLength.Value];
                                stream.Read(buffer, 0, buffer.Length);
                                string content = Encoding.UTF8.GetString(buffer);
                                IDictionary<string, object> dic = JsonConvert.DeserializeObject<IDictionary<string, object>>(content);
                                dic.ForEach(l => sqlparam.Add(l.Key, dic[l.Key] is JArray ? string.Join(",", (JArray)dic[l.Key]) : dic[l.Key]));
                            }
                        }
                        break;
                }
                result.Data = new DictionaryService().GetList(sqlparam);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result);
        }

        [HttpGet]

        public JsonResult Get(int? id = null, string code = null)
        {
            ResultDTO result = new ResultDTO();
            try
            {
                result.Data = new DictionaryService().Get(id, code);
                result.Result = true;
            }
            catch (Exception ex)
            {
                result.Message = ex.Message;
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Save([FromBody] DictionaryDTO dto)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new DictionaryService().Save(dto);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

        [HttpPost]
        public JsonResult Enable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new DictionaryService().Save(id, false);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);

        }

        [HttpPost]
        public JsonResult Disable(int[] id)
        {
            ResultDTO result = default(ResultDTO);
            try
            {
                result = new DictionaryService().Save(id, true);
            }
            catch (Exception ex)
            {
                result = new ResultDTO() { Message = ex.Message };
            }

            return Json(result);
        }

    }
}
