﻿using Bailun.DC.SyncShopifyFee.Models;
using Dapper;
using Microsoft.Extensions.Hosting;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.SyncShopifyFee
{

    public class Services : BackgroundService
    {
        string url = "http://scrm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"; //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100

        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            //每60分钟执行一次任务
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(60));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                Init();
                Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }


        public Services()
        {
            Dapper.SimpleCRUD.SetDialect(SimpleCRUD.Dialect.MySQL);
        }

        public void Init(DateTime? btime = null, DateTime? etime = null)
        {
            var page = 1;
            var pagesize = 1000;
            var count = 0;

            if (!btime.HasValue)
            {
                btime = DateTime.Now.AddHours(-2);
            }
            if (!etime.HasValue)
            {
                etime = DateTime.Today.AddDays(1);
            }

            while (page == 1 || (page > 1 && count > 0))
            {
                try
                {
                    var result = Common.HttpHelper.NetHelper.Request($"{url}?btime={btime.Value.ToString("yyyy-MM-dd HH:00:00")}&etime={etime.Value.ToString("yyyy-MM-dd")}&page={page}&rows={pagesize}");
                    if (!string.IsNullOrEmpty(result))
                    {
                        var json = JsonConvert.DeserializeObject<response_result>(result);
                        count = json.data.Count;
                        if (json.success && count > 0)
                        {
                            //保存数据
                            Save(json.data);
                        }
                        page++;
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    Thread.Sleep(60 * 1000);
                }
            }
        }

        public void Save(IList<response_shopify_fee> list)
        {
            using (var db = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }

                foreach (var item in list)
                {
                    var m = JsonConvert.DeserializeObject<dc_base_finance_shopify_fee>(JsonConvert.SerializeObject(item));
                    m.gmt_modified = DateTime.Now;
                    int count = db.Execute("update dc_base_finance_shopify_fee set ad_id = @ad_id, ts = @ts, bdate = @bdate, edate = @edate, fee = @fee, account_currency = @account_currency, cny_exchange_rate = @cny_exchange_rate,gmt_modified = @gmt_modified where data_id=@data_id", m);
                    if (count == 0)
                    {
                        m.gmt_create = DateTime.Now;
                        db.Insert(m);
                    }
                }
            }
        }
    }
}
