﻿using Newtonsoft.Json;
using System;
using System.ComponentModel;

namespace Bailun.DC.SyncAmazonAdFee.Models
{
    public class response_amazon_ad_fee
    {
        /// <summary>
        /// 数据ID
        /// </summary>
        [JsonProperty("id")]
        public long? data_id { get; set; }

        /// <summary>
        /// 广告系列名称
        /// </summary>
        [JsonProperty("campaignName")]
        public string campaign_name { get; set; }

        /// <summary>
        /// 广告系列唯一ID
        /// </summary>
        [JsonProperty("campaignId")]
        public string campaign_id { get; set; }

        /// <summary>
        /// 广告组名称
        /// </summary>
        [JsonProperty("adGroupName")]
        public string ad_group_name { get; set; }

        /// <summary>
        /// 广告组唯一ID
        /// </summary>
        [JsonProperty("adGroupId")]
        public string ad_group_id { get; set; }

        /// <summary>
        /// 广告总展示次数
        /// </summary>
        public int? impressions { get; set; }

        /// <summary>
        /// 广告总点击次数
        /// </summary>
        public int? clicks { get; set; }

        /// <summary>
        /// 所有点击总费用
        /// </summary>
        public decimal? cost { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// ASIN
        /// </summary>
        public string asin { get; set; }

        /// <summary>
        /// 平台SKU
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 7天内归因转化事件数
        /// </summary>
        [JsonProperty("AttributedConversions7d")]
        public int? attributed_conversions_sevenday { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        [JsonProperty("AttributedConversions7dSameSKU")]
        public string attributed_conversions_sevenday_same_sku { get; set; }

        /// <summary>
        /// 7天内订购归属单位数量
        /// </summary>
        [JsonProperty("AttributedUnitsOrdered7d")]
        public int? attributed_units_ordered_sevenday { get; set; }

        /// <summary>
        /// 7天内归因销售数量
        /// </summary>
        [JsonProperty("AttributedSales7d")]
        public int? attributed_sales_sevenday { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty("AttributedSales7dSameSKU")]
        public string attributed_sales_sevenday_same_sku { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty("AttributedUnitsOrdered7dSameSKU")]
        public string attributed_units_ordered_sevenday_same_sku { get; set; }

        /// <summary>
        /// 报告时间
        /// </summary>
        [JsonProperty("belongDate")]
        public DateTime? report_date { get; set; }

        /// <summary>
        /// 4K数据更新时间
        /// </summary>
        [JsonProperty("updateTime")]
        public DateTime? operation_time { get; set; }

        /// <summary>
        /// 广告类型 0:sp广告，1：sd广告 ,2:sb广告,3:sbv广告
        /// </summary>
        public int? type { get; set; }
    }
}
