﻿using Bailun.DC.Common;
using Bailun.DC.DB.Base;
using Bailun.DC.Models;
using Bailun.DC.Models.Common;
using Bailun.DC.Models.Common.Page;
using Bailun.DC.Models.Dtos.Finance;
using Bailun.DC.Models.Dtos.Stock;
using Bailun.DC.Models.Stock;
using Bailun.DC.Models.WebApiModels;
using Dapper;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Bailun.DC.Services.WebApiService
{
    public partial class FinanceService
    {
        public CommonApiResponseDto<FinanceDto> GetCashFlowStatement(GetCashFlowStatementInput input)
        {
            try
            {
                var dtos = new FinanceDto();
                var data = GetFinanceFeeList(input);
                if (data.Count > 0)
                {
                    var url = ConfigHelper.AppSetting("cwUrl");
                    url += $"?BeginRepayTime={input.PaymentTimeStart.ToString("yyyy-MM-dd")}&EndRepayTime={input.PaymentTimeEnd.ToString("yyyy-MM-dd")}";
                    var listInterest = new FinanceReportServices().ListInterestExpense(url);//手续费
                    var listHandleFee = new FinanceReportServices().ListFinanceHandleFee(input.PaymentTimeStart, input.PaymentTimeEnd, null, "");//利息支出

                    var Col = data.GroupBy(a => a.company_name).Select(p => p.Key).OrderBy(a => a).ToList();
                    var listValue = new List<Tuple<string, List<decimal>>>();
                    for (var i = 0; i < Col.Count; i++)
                    {
                        //主体下所有费用单
                        var feedata = data.Where(x => x.company_name == Col[i]).ToList();
                        foreach (var item in feedata)
                        {
                            var obj = listValue.Where(a => a.Item1 == item.type_name).FirstOrDefault();

                            if (obj == null)
                            {
                                var listItems = new List<decimal>();
                                while (listItems.Count < Col.Count)//所有主体都添加上
                                {
                                    listItems.Add(0.00M);
                                }
                                listItems[i] = item.amount_rmb ?? 0;//当前主体赋值
                                listValue.Add(new Tuple<string, List<decimal>>(item.type_name, listItems));
                            }
                            else
                            {
                                obj.Item2[i] += item.amount_rmb ?? 0;
                            }
                        }
                    }
                    var jsonStr = GenerateStr(Col, listValue);
                    //dtos.Col.Add(new columnsObj
                    //{
                    //    key = "key",
                    //    title = "费用类型"
                    //});
                    //for (int j = 0; j < Col.Count; j++)
                    //{
                    //    var keyInfo = new columnsObj
                    //    {
                    //        key = "key" + j,
                    //        title = Col[j]
                    //    };
                    //    dtos.Col.Add(keyInfo);
                    //}
                    //var jsonStr = "[";
                    //for (int i = 0; i < listValue.Count; i++)
                    //{
                    //    jsonStr += "{";
                    //    jsonStr += "\"key\":\"" + listValue[i].Item1 + "\",";//第一条费用类型
                    //    for (int j = 0; j < listValue[i].Item2.Count; j++)//第一条类型里所有数据
                    //    {
                    //        jsonStr += "\"" + dtos.Col[j + 1].key + "\":\"" + listValue[i].Item2[j] + "\",";
                    //    }
                    //    jsonStr = jsonStr.Trim(',');
                    //    jsonStr += "},";
                    //}
                    //jsonStr = jsonStr.Trim(',');
                    //jsonStr += "]";
                    //if (listInterest.Count > 0)
                    //{

                    //}
                    //if (listHandleFee.Count > 0)
                    //{

                    //}
                    dtos.Col = jsonStr.Item1;
                    dtos.Data = jsonStr.Item2;
                }
                return new CommonApiResponseDto<FinanceDto>
                {
                    Data = dtos
                };
            }
            catch (Exception e)
            {
                return new CommonApiResponseDto<FinanceDto> { IsSuccess = false, Message = e.Message };
            }
        }
        private List<Models.Api.mInterestExpense> GetMInterestExpense(string url)
        {
            using (var http = new HttpClient())
            {
                var result = http.GetStringAsync(url).GetAwaiter().GetResult();
                var obj = Newtonsoft.Json.JsonConvert.DeserializeObject<List<Models.Api.mInterestExpense>>(result);
                return obj;
            };
        }


        #region 付现流水明细
        /// <summary>
        /// 分页查询付现流水明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public CommonApiResponseDto<FinanceFeeDetailsPageOutputDto> GetFinanceFeeDetailsPage(FinanceFeeDetailsPageInputDto input)
        {
            var result = new CommonApiResponseDto<FinanceFeeDetailsPageOutputDto> { Data = new FinanceFeeDetailsPageOutputDto() };
            var sqlWhere = BuildAllotOperationLogPageQuerySqlWhere(input, out DynamicParameters parameters);
            if (!input.IsPages)
            {
                result.Data.Items = SimpleCRUD.Query<FinanceFeeDetailsListItem>(sqlWhere, parameters, GlobalConfig.ConnectionString).ToList();
                return result;
            }
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                int total = 0;
                result.Data.Items = cn.Page<FinanceFeeDetailsListItem>(input.PageIndex, input.PageNumber, sqlWhere, ref total, parameters).AsList();
                result.Data.Pages.CurrentPage = input.PageIndex;
                result.Data.Pages.PageSize = input.PageNumber;
                result.Data.Pages.Total = total;
            }
            return result;
        }

        public string BuildAllotOperationLogPageQuerySqlWhere(FinanceFeeDetailsPageInputDto input, out DynamicParameters parameters)
        {
            parameters = new DynamicParameters();
            StringBuilder sqlText = new StringBuilder();
            sqlText.Append(@"SELECT 
                                     t1.cost_no
                                    ,t1.company_name
                                    ,t1.type_name
                                    ,t1.amount
                                    ,t1.amount_rmb
                                    ,IFNULL(t1.cost_reason,t1.cost_remark) as cost_reason
                                    ,t1.kind_name
                                    ,t1.bank_card_user
                                    ,t1.bank_company
                                    ,t1.accounting_subject_name
                                    ,t1.audit_time
                                    ,t1.pay_time
                                    ,t1.last_modify_date
                                    ,t1.department_name
                                    ,t1.create_username
                                    ,t1.create_time
                             FROM dc_base_finance_fee AS t1
                             INNER JOIN dc_base_finance_company AS t2 ON t2.company_name = t1.company_name
                             WHERE t1.cost_status = 4 
                             AND (t1.is_lend IS NULL OR t1.is_lend = 1
                             	OR (t1.is_lend = 2 AND t1.lend_balance > 0)
                             	OR (t1.is_lend = 2 AND t1.cost_form = 1)
                             )");
            if (!string.IsNullOrWhiteSpace(input.CostNo))
            {
                sqlText.Append(" AND t1.cost_no = @CostNo ");
                parameters.Add("CostNo", input.CostNo);
            }
            if (!string.IsNullOrWhiteSpace(input.CompanyName))
            {
                sqlText.Append(" AND t1.company_name = @CompanyName ");
                parameters.Add("CompanyName", input.CompanyName);
            }
            if (!string.IsNullOrWhiteSpace(input.CostTypeName))
            {
                sqlText.Append(" AND t1.type_name = @CostTypeName ");
                parameters.Add("CostTypeName", input.CostTypeName);
            }
            if (input.CreateTime != null && input.CreateTime.Length == 2 && !string.IsNullOrWhiteSpace(input.CreateTime[0]) && !string.IsNullOrWhiteSpace(input.CreateTime[1]))
            {
                sqlText.Append(" AND t1.create_time >= @StartCreateTime  AND t1.create_time < @EndCreateTime ");
                parameters.Add("StartCreateTime", Convert.ToDateTime(input.CreateTime[0]));
                parameters.Add("EndCreateTime", Convert.ToDateTime(input.CreateTime[1]).AddDays(1));
            }
            if (input.LastModifyDate != null && input.LastModifyDate.Length == 2 && !string.IsNullOrWhiteSpace(input.LastModifyDate[0]) && !string.IsNullOrWhiteSpace(input.LastModifyDate[1]))
            {
                sqlText.Append(" AND t1.last_modify_date >= @StartLastModifyDate AND t1.last_modify_date < @EndLastModifyDate ");
                parameters.Add("StartLastModifyDate", Convert.ToDateTime(input.LastModifyDate[0]));
                parameters.Add("EndLastModifyDate", Convert.ToDateTime(input.LastModifyDate[1]).AddDays(1));
            }
            if (input.PayTime != null && input.PayTime.Length == 2 && !string.IsNullOrWhiteSpace(input.PayTime[0]) && !string.IsNullOrWhiteSpace(input.PayTime[1]))
            {
                sqlText.Append(" AND t1.pay_time >= @StartPayTime AND t1.pay_time < @EndPayTime ");
                parameters.Add("StartPayTime", Convert.ToDateTime(input.PayTime[0]));
                parameters.Add("EndPayTime", Convert.ToDateTime(input.PayTime[1]).AddDays(1));
            }
            sqlText.Append(" ORDER BY t1.create_time DESC ");
            return sqlText.ToString();
        }
        #endregion
        private List<ManagementCost> GetFinanceFeeList(GetCashFlowStatementInput input)
        {
            var sql = $@"select * from dc_base_finance_fee s1
left JOIN dc_base_finance_company s2
ON s1.company_name = s2.company_name
where s1.cost_status = 4
and (s1.is_lend is null or s1.is_lend = 1
or (s1.is_lend = 2 and s1.lend_balance > 0) or (s1.is_lend = 2 and s1.cost_form = 1))
and s1.pay_time >= @PaymentTimeStart and s1.pay_time < @PaymentTimeEnd
and s2.company_type = @CorporateEntity ";
            var para = new DynamicParameters();
            para.Add("PaymentTimeStart", Convert.ToDateTime(input.PaymentTime[0]).Date);
            para.Add("PaymentTimeEnd", Convert.ToDateTime(input.PaymentTime[1]).AddDays(1).Date);
            para.Add("CorporateEntity", input.CorporateEntity);
            if (!string.IsNullOrWhiteSpace(input.CompanyName)
                && !string.IsNullOrWhiteSpace(input.FeeType))
            {
                sql += " and s1.type_name=@type and s1.company_name = @companyname";
                para.Add("type", input.FeeType);
                para.Add("companyname", input.CompanyName);
                if (input.IsPage)
                {
                    sql += "limit @limit offset @offset";
                    para.Add("limit", input.PageNumber);
                    para.Add("offset", (input.PageIndex - 1) * input.PageNumber);
                }
            }
            sql += " order by s1.pay_time";
            var data = SimpleCRUD.Query<ManagementCost>(sql, para, GlobalConfig.ConnectionString).ToList();
            foreach (var item in data)
            {
                if (item.cost_form == 2)
                {
                    item.amount = -(item.amount);
                    item.amount_rmb = -(item.amount_rmb);
                }

                //借支单待还余额
                if (item.cost_form == 3)
                {
                    if (item.is_lend.HasValue && item.is_lend.Value == 2 && ((item.lend_balance ?? 0) > 0))  //归还金额
                    {
                        item.amount = -(item.amount);
                        item.amount_rmb = -(item.amount_rmb);
                    }
                }
            }
            return data;
        }
        public CommonApiResponseDto<List<FinanceDetailsDto>> GetFinanceDetails(GetCashFlowStatementInput input)
        {
            try
            {
                //input.IsPage = true;
                var data = new List<ManagementCost>();
                if (input.Flag == 1)
                {
                    data = GetManagementCostList(input);
                }
                else
                {
                    data = GetFinanceFeeList(input);
                }
                var dto = data.Select(x => new FinanceDetailsDto
                {
                    Amount = Convert.ToDecimal(x.amount),
                    AmountRmb = Convert.ToDecimal(x.amount_rmb),
                    CompanyName = x.company_name,
                    Currency = x.dic,
                    DepartmentName = x.department_name,
                    FeeSuperType = x.type_name,
                    FeeId = x.cost_no,
                    Accounting = x.accounting_subject_name,
                    Reason = string.IsNullOrEmpty(x.cost_reason) ? x.cost_remark : x.cost_reason,
                    PayTime = x.pay_time.HasValue ?
                    x.pay_time.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                    ReceiveUnit = x.bank_company
                }).ToList();
                dto.Add(new FinanceDetailsDto
                {
                    FeeId = "合计",
                    AmountRmb = dto.Sum(x => x.AmountRmb),
                    Amount = dto.Sum(x => x.Amount)
                });
                return new CommonApiResponseDto<List<FinanceDetailsDto>> { Data = dto };
            }
            catch (Exception e)
            {
                return new CommonApiResponseDto<List<FinanceDetailsDto>> { IsSuccess = false, Message = e.Message };
            }
        }

        public CommonApiResponseDto<FinanceDto> GetManagementCost(GetCashFlowStatementInput input)
        {
            var data = GetManagementCostList(input);
            var dtos = new FinanceDto();
            //var typeNameList = data.Select(x => x.TypeName).Distinct().ToList();//费用标题
            var costNameList = data.Select(x => x.management_cost_name).Distinct().ToList();//费用类型（借支/借还、付款、收款）
            var listValue = new List<Tuple<string, List<decimal>>>();
            for (var i = 0; i < costNameList.Count; i++)//根据费用类型取数
            {
                //从源数据里拿到所有数据
                var feedata = data.Where(x => x.management_cost_name == costNameList[i]).ToList();
                //赋值所有费用标题 没有的默认赋值0
                foreach (var item in feedata)
                {
                    //var fee = feedata.Where(x => x.TypeName == item).ToList();
                    var obj = listValue.Where(a => a.Item1 == item.type_name).FirstOrDefault();

                    if (obj == null)
                    {
                        var listItems = new List<decimal>();
                        while (listItems.Count < costNameList.Count)//所有主体都添加上
                        {
                            listItems.Add(0.00M);
                        }
                        listItems[i] = item.amount_rmb ?? 0;//当前主体赋值
                        listValue.Add(new Tuple<string, List<decimal>>(item.type_name, listItems));
                    }
                    else
                    {
                        obj.Item2[i] += item.amount_rmb ?? 0;
                    }
                }
            }
            var jsonStr = GenerateStr(costNameList, listValue);
            dtos.Col = jsonStr.Item1;
            dtos.Data = jsonStr.Item2;
            return new CommonApiResponseDto<FinanceDto>
            {
                Data = dtos,
            };
        }

        private List<ManagementCost> GetManagementCostList(GetCashFlowStatementInput input)
        {
            //            var sql = $@"select *
            //from dc_base_finance_management_cost s1
            //LEFT JOIN dc_base_finance_fee s2
            //ON s1.management_cost_type = s2.cost_form
            //and s1.management_cost_category = s2.accounting_subject_name
            //and s1.management_cost_title = s2.type_name
            //LEFT JOIN dc_base_finance_company s3 
            //ON s3.company_name = s2.company_name
            //where s2.cost_status = 4
            //and (s2.is_lend is null or s2.is_lend = 1
            //or (s2.is_lend = 2 and s2.lend_balance > 0) or (s2.is_lend = 2 and s2.cost_form = 1))
            //and s2.pay_time >= @paytimeStrat 
            //and s2.pay_time < @paytimeEnd
            //and s3.company_type = @companyType ";
            var sql = @"SELECT 
s2.amount,s2.cost_form,s2.amount_rmb,
s2.is_lend,s2.lend_balance,
s2.company_name,s2.dic,s2.department_name,
s2.type_name,s2.cost_no,s2.accounting_subject_name,
s2.cost_reason,s2.cost_remark,s2.pay_time,s2.bank_company,
s1.management_cost_name
FROM dc_base_finance_fee AS s2
INNER JOIN dc_base_finance_management_cost AS s1 ON s1.management_cost_type = s2.cost_form
and s1.management_cost_category = s2.accounting_subject_name
and s1.management_cost_title = s2.type_name
WHERE  s2.cost_status = 4
and (s2.is_lend is null or s2.is_lend = 1
or (s2.is_lend = 2 and s2.lend_balance > 0) or (s2.is_lend = 2 and s2.cost_form = 1))
 AND s2.company_name IN(
SELECT company_name FROM dc_base_finance_company WHERE company_type = @companyType
) and s2.pay_time >=  @paytimeStrat 
and s2.pay_time < @paytimeEnd ";
            var para = new DynamicParameters();
            para.Add("paytimeStrat", Convert.ToDateTime(input.PaymentTime[0]).Date);
            para.Add("paytimeEnd", Convert.ToDateTime(input.PaymentTime[1]).AddDays(1).Date);
            para.Add("companyType", input.CorporateEntity);
            if (input.IsStatistics.HasValue)
            {
                sql += " and s1.is_statistics = @status";
                para.Add("status", input.IsStatistics.Value);
            }
            if (!string.IsNullOrEmpty(input.CompanyName) &&
                !string.IsNullOrEmpty(input.FeeType))
            {
                sql += @" and s2.type_name = @typename 
and s1.management_cost_name = @managementcostname";
                para.Add("typename", input.FeeType);
                para.Add("managementcostname", input.CompanyName);
            }
            sql += " order by s2.pay_time";
            var data = SimpleCRUD.Query<ManagementCost>(sql, para, GlobalConfig.ConnectionString).ToList();
            data.ForEach((item) =>
            {
                if (item.cost_form == 2)
                {
                    item.amount = -(item.amount);
                    item.amount_rmb = -(item.amount_rmb);
                }
                //借支单待还余额
                if (item.cost_form == 3)
                {
                    if (item.is_lend.HasValue && item.is_lend.Value == 2 && ((item.lend_balance ?? 0) > 0))  //归还金额
                    {
                        item.amount = -(item.amount);
                        item.amount_rmb = -(item.amount_rmb);
                    }
                }
            });
            return data;
        }
        /// <summary>
        /// 生成前端需要的表头和内容
        /// </summary>
        /// <param name="Col"></param>
        /// <param name="listValue"></param>
        /// <returns></returns>
        private (List<columnsObj>, string) GenerateStr(List<string> Col, List<Tuple<string, List<decimal>>> listValue)
        {
            var colList = new List<columnsObj>();
            colList.Add(new columnsObj
            {
                key = "key",
                title = "费用类型"
            });
            for (int j = 0; j < Col.Count; j++)
            {
                var keyInfo = new columnsObj
                {
                    key = "key" + j,
                    title = Col[j]
                };
                colList.Add(keyInfo);
            }
            var jsonStr = "[";
            for (int i = 0; i < listValue.Count; i++)
            {
                jsonStr += "{";
                jsonStr += "\"key\":\"" + listValue[i].Item1 + "\",";//第一条费用类型
                for (int j = 0; j < listValue[i].Item2.Count; j++)//第一条类型里所有数据
                {
                    jsonStr += "\"" + colList[j + 1].key + "\":\"" + listValue[i].Item2[j] + "\",";
                }
                jsonStr = jsonStr.Trim(',');
                jsonStr += "},";
            }
            jsonStr = jsonStr.Trim(',');
            jsonStr += "]";
            return (colList, jsonStr);
        }

        /// <summary>
        /// 月度利润报表
        /// </summary>
        /// <param name="start">开始月份</param>
        /// <param name="end">结束月份</param>
        /// <returns></returns>
        public List<MonthSalesProfitDto> ListMonthSaleProfitNew(string start, string end)
        {
            var sql = $"select * from dc_month_sales_profit_v2 where month>='{start}' ";

            if (!string.IsNullOrEmpty(end))
            {
                sql += (" and month<='" + end + "'");
            }
            var data = SimpleCRUD.Query<MonthSalesProfitDto>(sql, null, GlobalConfig.ConnectionString).ToList();
            return data;
        }


        #region 月利润销售表
        /// <summary>
        /// 查询月销售平台统计数据
        /// </summary>
        /// <param name="month"></param>
        /// <param name="financecategory"></param>
        /// <param name="isCost">统计成本</param>
        /// <param name="falg"></param>
        /// <returns></returns>
        public List<PlatformTypeMonthlyStatisticsDto> GetPlatformTypeMonthlyStatistics(string month, string financecategory, bool isCost = false, bool falg = false)
        {
            StringBuilder sql = new StringBuilder();
            if (isCost)
            {
                sql.Append(@"SELECT t1.platform_type, SUM(t1.cost_product * t1.quantity_shipped) AS original_amount,
SUM(t1.cost_product * t1.quantity_shipped) AS total_amount_sales,COUNT(0) total_order FROM dc_month_sales_profit_orderdetail AS t1 ");
            }
            else
            {
                sql.Append(@"SELECT t1.platform_type, SUM(t1.amount_sales * t1.quantity_shipped) AS original_amount, 
SUM(t1.amount_sales * (IFNULL(t3.exchange_rate,t1.seller_order_exchange_rate)) * t1.quantity_shipped) AS total_amount_sales,COUNT(0)AS total_order FROM dc_month_sales_profit_orderdetail AS t1 ");
            }
            sql.Append("LEFT JOIN dc_base_oms_sku AS t2 ON t1.orderskuid = t2.id ");
            sql.Append("LEFT JOIN dc_exchange_rate_finance t3 ON t1.order_currency = t3.`code` and t1.`month` = t3.`month` ");
            sql.Append($"WHERE t1.`month` ='{month}' ");
            if (!string.IsNullOrEmpty(financecategory) && financecategory != "其他")
            {
                if (falg)
                {
                    sql.Append($"AND t1.financecategoryname LIKE '{financecategory}%'");
                }
                else
                {
                    sql.Append($"AND t1.financecategoryname LIKE '{financecategory.Replace("产品", "")}%'");
                }
            }
            else if (financecategory == "其他")
            {
                sql.Append($" AND t1.financecategoryname ='' ");
            }
            sql.Append(" GROUP BY t1.platform_type;");
            var data = SimpleCRUD.Query<PlatformTypeMonthlyStatisticsDto>(sql.ToString(), null, GlobalConfig.ConnectionString).ToList();
            return data;
        }




        /// <summary>
        /// 分页查询月销售明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public CommonApiResponseDto<MonthProfitOrderDetailPageOutputDto> GetMonthProfitOrderDetailPage(MonthProfitOrderDetailPageInputDto input)
        {
            var result = new CommonApiResponseDto<MonthProfitOrderDetailPageOutputDto> { Data = new MonthProfitOrderDetailPageOutputDto() };
            var sqlWhere = BuildMonthSalesProfitOrderdetailPageQuerySqlWhere(input, out DynamicParameters parameters);
            if (!input.IsPages)
            {
                result.Data.Items = SimpleCRUD.Query<dc_month_sales_profit_orderdetail>(sqlWhere, parameters, GlobalConfig.ConnectionString).ToList();
                return result;
            }
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                int total = 0;
                result.Data.Items = cn.Page<dc_month_sales_profit_orderdetail>(input.PageIndex, input.PageNumber, sqlWhere, ref total, parameters).AsList();
                result.Data.Pages.CurrentPage = input.PageIndex;
                result.Data.Pages.PageSize = input.PageNumber;
                result.Data.Pages.Total = total;
            }
            return result;
        }


        private string BuildMonthSalesProfitOrderdetailPageQuerySqlWhere(MonthProfitOrderDetailPageInputDto input, out DynamicParameters parameters)
        {
            parameters = new DynamicParameters();
            StringBuilder sqlText = new StringBuilder();
            sqlText.Append($@"SELECT t1.*, t2.origin_order_id, t2.bailun_order_id, t3.exchange_rate as finance_order_exchange_rate
                                FROM dc_month_sales_profit_orderdetail t1
                                LEFT JOIN dc_base_oms_sku t2 ON t1.orderskuid = t2.id
                                LEFT JOIN dc_exchange_rate_finance t3 ON t1.order_currency = t3.`code` and t1.`month` = t3.`month`
                                WHERE
                                	t1. MONTH = @Month ");
            parameters.Add("Month", input.Month);
            if (input.PlatformType != null)
            {
                sqlText.Append(" AND t1.platform_type = @PlatformType ");
                parameters.Add("PlatformType", input.PlatformType);
            }
            if (!string.IsNullOrWhiteSpace(input.FinanceCategory) && (input.FinanceCategory != "其他" && input.FinanceCategory != "其它"))
            {
                sqlText.Append($" AND t1.financecategoryname like '{input.FinanceCategory.Replace("产品", "")}%' ");
            }
            else if (input.FinanceCategory == "其他" || input.FinanceCategory == "其它")
            {
                sqlText.Append(" and t1.financecategoryname = '' ");
            }
            if (input.ShippingTimes != null && input.ShippingTimes.Length == 2 && !string.IsNullOrWhiteSpace(input.ShippingTimes[0]) && !string.IsNullOrWhiteSpace(input.ShippingTimes[1]))
            {
                sqlText.Append(" AND t1.shipping_time >= @StartLastModifyDate AND t1.shipping_time < @EndLastModifyDate ");
                parameters.Add("StartLastModifyDate", Convert.ToDateTime(input.ShippingTimes[0]));
                parameters.Add("EndLastModifyDate", Convert.ToDateTime(input.ShippingTimes[1]));
            }
            sqlText.Append(" ORDER BY t1.createtime DESC ");
            return sqlText.ToString();
        }


        public bool UpdateMonthSalseProfit(UpdateMonthSalseProfitInput input, int userId, string userName)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                input.Month = input.Month.Replace("月份", "");
                var sql = $"select * from dc_month_sales_profit_v2 where isedit = 1 and month = '{input.Month}'";
                var obj = SimpleCRUD.Query<dc_month_sales_profit_v2>(sql, null, GlobalConfig.ConnectionString).FirstOrDefault();
                if (obj == null)
                {
                    obj = new dc_month_sales_profit_v2
                    {
                        month = input.Month,
                        amount_sales = 0,
                        amount_sales_dianzi = 0,
                        amount_sales_fuzhuang = 0,
                        amount_sales_jiaju = 0,
                        amount_sales_jingyou = 0,
                        amount_sales_meirongmj = 0,
                        actual_profit = 0,
                        amount_withdraw = 0,
                        fee_platform_and_refund = 0,
                        fee_fba = 0,
                        fee_finance = 0,
                        fee_logistics_direct = 0,
                        fee_logistics_first = 0,
                        fee_logistics_tail = 0,
                        fee_logistics_storage = 0,
                        fee_paycash_sales = 0,
                        fee_platform = 0,
                        fee_refund = 0,
                        fee_sales_count = 0,
                        fee_storage = 0,
                        fee_storage_incidentals = 0,
                        fee_ad = 0,
                        cost_fuzhuang = 0,
                        cost = 0,
                        cost_dianzi = 0,
                        cost_jiaju = 0,
                        cost_jingyou = 0,
                        cost_meirongmj = 0,
                        createtime = DateTime.Now,
                        managercost_chengpincang = 0,
                        managercost_count = 0,
                        managecost_bl_gz = 0,
                        managecost_bl_xg = 0,
                        managecost_meijia = 0,
                        managercost_yangshan = 0,
                        managercost_dizhi = 0,
                        managercost_meijiashengchan = 0,
                        dividend = 0,
                        incoming_non_operating = 0,
                        incoming_other = 0,
                        incoming_refundtax = 0,
                        isedit = 1,
                        profit_sales = 0,
                        pay_non_operating = 0,
                        rate_profit_sales = 0,
                        profit = 0,
                        profit_balance = 0,
                        rate_profit = 0,
                        rate_profit_actual = 0,
                        amount_sales_other = 0,
                        cost_other = 0,
                        managercost_xinhuilan = 0,
                        impairment_assets = 0,

                        fee_nofba = 0,
                        fee_ebay = 0,
                        fee_ohtre = 0,
                        fee_nologistics_first = 0,
                        fee_nologistics_tail = 0,
                        fee_nologistics_direct = 0,
                        fee_nostorage = 0,
                        fee_sales_taxes = 0,
                        managercost_gzdz = 0,
                        managercost_ys = 0,
                        managercost_gzlk = 0,
                        managercost_gzcy = 0,
                        among_other_income = 0,
                    };
                }
                var type = obj.GetType();
                object change = Convert.ChangeType(input.Value, type.GetProperty(input.Key).PropertyType);
                type.GetProperty(input.Key).SetValue(obj, change, null);

                //销售额=家居用品类+服装类+电子产品类+精油类+美容美甲类+其他
                obj.amount_sales = obj.amount_sales_dianzi + obj.amount_sales_fuzhuang + obj.amount_sales_jiaju + obj.amount_sales_jingyou + obj.amount_sales_meirongmj + obj.amount_sales_other;
                //产品成本=家居用品类+服装类+电子产品类+精油类+美容美甲类+其他类型成本
                obj.cost = obj.cost_dianzi + obj.cost_fuzhuang + obj.cost_jiaju + obj.cost_jingyou + obj.cost_meirongmj + obj.cost_other;

                //平台扣费及退款
                obj.fee_platform_and_refund = obj.fee_platform + obj.fee_fba + obj.fee_refund + obj.fee_ad;

                //物流仓储费用 = 头程运输+直邮物流费+尾程物流费+海外仓仓储+海外仓杂费
                obj.fee_logistics_storage = obj.fee_logistics_first + obj.fee_logistics_direct + obj.fee_logistics_tail + obj.fee_storage + obj.fee_storage_incidentals;

                //销售费用合计=平台扣费及退款+物流仓储费用+付现销售费用
                obj.fee_sales_count = obj.fee_platform_and_refund + obj.fee_logistics_storage + obj.fee_paycash_sales;

                //销售利润=销售额-产品成本-销售费用合计
                obj.profit_sales = obj.amount_sales - obj.cost - obj.fee_sales_count;

                //销售毛利率=销售利润/销售额
                obj.rate_profit_sales = obj.amount_sales > 0 ? obj.profit_sales / obj.amount_sales : 0;

                //管理成本=香港百伦+广州百伦+美容美甲店+杨杉+信荟蓝+成品仓+迪致+广州美甲生产仓
                obj.managercost_count = obj.managecost_bl_gz + obj.managecost_bl_xg + obj.managecost_meijia + obj.managercost_chengpincang + obj.managercost_xinhuilan + obj.managercost_yangshan + obj.managercost_dizhi + obj.managercost_meijiashengchan;

                //营业利润=销售利润-管理成本合计-财务费用
                obj.profit = obj.profit_sales - obj.managercost_count - obj.fee_finance;

                //营业毛利率=营业利润/销售额
                obj.rate_profit = obj.amount_sales > 0 ? obj.profit / obj.amount_sales : 0;

                //实际利润=营业利润+其他收入+营业外收入-营业外支出-资产减值
                obj.actual_profit = obj.profit + obj.incoming_other + obj.incoming_non_operating - obj.pay_non_operating - (obj.impairment_assets ?? 0);

                //利润结余=实际利润-分红
                obj.profit_balance = obj.actual_profit - obj.dividend;

                //净利率 = 利润结余/销售额
                obj.rate_profit_actual = obj.amount_sales > 0 ? obj.profit_balance / obj.amount_sales : 0;

                obj.lastupdatetime = DateTime.Now;
                obj.lastupdateuserid = userId;
                obj.lastupdateusername = userName;

                if (obj.id > 0)
                {
                    var result = cn.Update(obj);
                    return result > 0 ? true : false;
                }
                else
                {
                    var result = cn.Insert(obj);
                    return (result ?? 0) > 0 ? true : false;
                }
            }
        }


        /// <summary>
        /// 月销售利润管理成本明细
        /// </summary>
        /// <param name="month"></param>
        /// <param name="feeName"></param>
        /// <returns></returns>
        public CommonApiResponseDto<List<FinanceDetailsDto>> GetMonthProfitFeeManagementCostDetail(string month, string feeName)
        {
            month = month.Replace("月份", "");
            var start = Convert.ToDateTime(month).Date;
            var end = start.AddMonths(1).Date;
            var sql = BuildMonthProfitFeeManagementCostDetailSql(start, end, feeName, out DynamicParameters parameters);

            var data = SimpleCRUD.Query<FinanceDetailsDto>(sql, parameters, GlobalConfig.ConnectionString).ToList();
            foreach (var item in data)
            {
                if (item.cost_form == 2)
                {
                    item.Amount = -(item.Amount);
                    item.AmountRmb = -(item.AmountRmb);
                }
                //借支单待还余额
                if (item.cost_form == 3)
                {
                    if (item.is_lend.HasValue && item.is_lend.Value == 2 && ((item.lend_balance ?? 0) > 0))  //归还金额
                    {
                        item.Amount = -(item.Amount);
                        item.AmountRmb = -(item.AmountRmb);
                    }
                }
            }
            data.Select(x =>
            {
                x.Reason = string.IsNullOrEmpty(x.CostReason) ? x.CostRemark : x.CostReason;
                x.PayTime = x.pay_time.HasValue ? x.pay_time.Value.ToString("yyyy-MM-dd HH:mm:ss") : "";
                return x;
            }).ToList();
            data.Add(new FinanceDetailsDto
            {
                FeeId = "合计",
                AmountRmb = data.Sum(x => x.AmountRmb),
                Amount = data.Sum(x => x.Amount)
            });
            return new CommonApiResponseDto<List<FinanceDetailsDto>> { Data = data };
        }
        public string BuildMonthProfitFeeManagementCostDetailSql(DateTime start, DateTime end, string feeName, out DynamicParameters parameters)
        {
            parameters = new DynamicParameters();
            StringBuilder sql = new StringBuilder();
            sql.Append(@"select amount as Amount,amount_rmb as AmountRmb,company_name as CompanyName,
dic as Currency,department_name as DepartmentName,type_name as TypeName,
cost_no as FeeId,accounting_subject_name as Accounting,bank_company as ReceiveUnit,
cost_reason as CostReason,cost_remark as CostRemark,pay_time,is_lend,lend_balance,cost_form
from dc_base_finance_fee where cost_status=4 and (is_lend is null or is_lend=1 or (is_lend=2 and lend_balance>0) 
or (is_lend=2 and cost_form=1)) and pay_time>= @start and pay_time< @end ");
            parameters.Add("start", start);
            parameters.Add("end", end);

            if (feeName.Contains("其中：其他收入"))
            {
                sql.Append(" and type_name in ('其他收入','销售商品收入','利息收入') and company_name <> '广州象迹实业有限公司' ");
            }
            else if (feeName.Contains("其中：歌戈儿收入"))
            {
                sql.Append(" and company_name like '%歌戈儿%' and type_name in ('销售收入','收款') ");
            }
            else
            {
                sql.Append(@" and type_name not in ('押金','还款','其他应付款-Amazon','其他收入','销售商品收入','借款','还款-货款','投资款','利息收入','出口退税款','销售收入','政府补助','收款','信息技术服务收入','个税返还','其他应付款-AMZ','代运营产品收入','广告托管收入','Creative收入') ");
                if (feeName.Contains("广州歌戈儿生活科技有限公司"))
                {
                    sql.Append(" and company_name like '%歌戈儿%' ");
                }
                else if (feeName.Contains("广州百伦供应链科技有限公司"))
                {
                    sql.Append(" and company_name like '广州百伦供应链科技有限公司%' ");
                }
                else if (feeName.Contains("香港百伦科技有限公司"))
                {
                    sql.Append(" and company_name = @feeName and type_name not in ('物流费','推广费','销售费用/物流费/直发费用','运营费用') ");
                }
                else
                {
                    sql.Append(" and company_name = @feeName ");
                }
            }
            parameters.Add("feeName", feeName);
            return sql.ToString();
        }
        /// <summary>
        /// 查询平台数据
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public CommonApiResponseDto<PageResult<List<MonthPlatformProfitDto>>> GetMonthProfitFeePlatformFeeDetail(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeePlatformFeeDetailSql(input, out DynamicParameters param);
            var result = new PageResult<List<MonthPlatformProfitDto>>();
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }
                int total = 0;
                var obj = cn.Page<MonthPlatformProfitDto>(input.PageIndex, input.PageNumber, sql, ref total, param);
                var data = obj.ToList();
                data = data.Select(x =>
                {
                    if (x.PlatForm.Contains("万邑通"))
                    {
                        x.AmountVal = Math.Abs(x.AmountVal.Value);
                        x.AmountValRmb = Math.Abs(x.AmountValRmb.Value);
                    }
                    return x;
                }).ToList();
                //if (data.Count > 0)
                //{
                //    var sumSql = BuildMonthProfitFeePlatformFeeDetailSql(input, out DynamicParameters paramSum, false, true);
                //    var count = cn.Query<(decimal, decimal)>(sumSql, paramSum).FirstOrDefault();
                //    data.Add(new MonthPlatformProfitDto
                //    {
                //        Currency = "合计",
                //        AmountVal = Math.Round(count.Item1, 2).ToString(),
                //        AmountValRmb = Math.Round(count.Item2, 2),
                //    });
                //}
                result = result.ToPageResult(input.PageIndex, total, data);
            }
            //var data = SimpleCRUD.Query<MonthPlatformProfitDto>(sql, null, GlobalConfig.ConnectionString_DW).ToList();

            return new CommonApiResponseDto<PageResult<List<MonthPlatformProfitDto>>> { Data = result };
        }
        public List<PlatformTypeMonthlyStatisticsDto> GetGetMonthProfitFeePlatformFeeSummary(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeePlatformFeeDetailSql(input, out DynamicParameters param, false, true);
            var data = SimpleCRUD.Query<PlatformTypeMonthlyStatisticsDto>(sql, param, GlobalConfig.ConnectionString_DW).ToList();
            List<ReversalDto> listReversal = SimpleCRUD.Query<ReversalDto>("SELECT DISTINCT platform, website FROM order_fee_config WHERE is_reversal = 1;", null, GlobalConfig.ConnectionString_DW).ToList();
            if (input.FeeName.Contains("仓储费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.platform_type.ToLower() == "wish")
                    {
                        x.original_amount = Math.Abs(x.original_amount) * -1;
                        x.total_amount_sales = Math.Abs(x.total_amount_sales) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("广告及宣传费"))
            {
                data = data.Select(x =>
                {
                    if (x.platform_type.ToLower() == "dhgate" || x.platform_type.ToLower() == "etsy" || x.platform_type.ToLower() == "shopify")
                    {
                        x.original_amount = Math.Abs(x.original_amount) * -1;
                        x.total_amount_sales = Math.Abs(x.total_amount_sales) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("尾程物流费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.platform_type.ToLower() == "lazada")
                    {
                        x.original_amount = Math.Abs(x.original_amount) * -1;
                        x.total_amount_sales = Math.Abs(x.total_amount_sales) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("加：营业外收入"))
            {
                data.Remove(data.Where(x => x.platform_type == "亚马逊" && x.website.ToLower() == "mx" && x.original_amount < 0).FirstOrDefault());
            }
            if (listReversal?.Count > 0 && data?.Count > 0)
            {
                listReversal.ForEach(l =>
                {
                    data.ForEach(x => { if (l.platform == x.platform_type && l.website == x.website) { x.original_amount = 0 - x.original_amount; x.total_amount_sales = 0 - x.total_amount_sales; } });
                });
            }

            return data;
        }
        /// <summary>
        /// 生成平台SQL
        /// </summary>
        /// <param name="input"></param>
        /// <param name="parameters"></param>
        /// <param name="isPage"></param>
        /// <param name="isSum"></param>
        /// <returns></returns>
        public string BuildMonthProfitFeePlatformFeeDetailSql(GetMonthProfitPlatformDetailInput input, out DynamicParameters parameters, bool isPage = false, bool isSum = false)
        {
            parameters = new DynamicParameters();
            input.Month = input.Month.Replace("月份", "");
            StringBuilder sql = new StringBuilder();
            if (isSum)
            {
                //                sql.Append($@"SELECT sum(s1.amountval) as amountval, sum(s1.amountval_rmb) amountval_rmb 
                //from order_fee_value_amazon s1 
                //JOIN order_fee_config s2
                //ON s2.id = s1.order_fee_config_id WHERE s1.amountval != 0 AND s1.month = @month ");
                sql.Append($@"
SELECT s1.platform AS platform_type,s1.website AS website ,SUM(s1.amountval) as original_amount,SUM(s1.amountval_rmb) as total_amount_sales,count(*) AS total_order
from order_fee_value_amazon s1 
JOIN order_fee_config s2 
ON s2.id = s1.order_fee_config_id 
WHERE s1.month = @month ");
            }
            else
            {
                sql.Append(@"SELECT s1.platform AS PlatForm,s1.website AS WebSite,s1.orderno AS Orderno,
s1.datatime AS DataTime,s1.amountval AS AmountVal,
s2.feetype AS FeeType,s2.subjectcode AS Subjectcode,s2.projectcode AS ProjectCode,
s2.financecategory AS FinanceCategory,s2.datacenter_col AS DatacenterCol,s2.currency AS Currency,s1.currency AS EbayCurrency,
s1.exchange_rate AS ExchangeRate,s1.amountval_rmb AS AmountValRmb,s1.month AS Month
from order_fee_value_amazon s1 
JOIN order_fee_config s2
ON s2.id = s1.order_fee_config_id WHERE s1.month = @month ");
            }
            parameters.Add("month", input.Month);
            if (input.FeeName.Contains("加：营业外收入"))
            {
                sql.Append("AND s2.datacenter_col LIKE '%营业外收入'");
            }
            else if (input.FeeName.Contains("减：营业外支出"))
            {
                //2021-09-23陈文静提出需求 营业外收入的mx站点数值小于0的话，就放入营业外支出
                sql.Append("AND (s2.datacenter_col LIKE '%营业外支出' or (s2.datacenter_col LIKE '%营业外收入' and s1.platform = '亚马逊' and LOWER(s1.website) = 'mx' and amountval_rmb < 0))");
            }
            else
            {
                sql.Append($"AND s2.datacenter_col LIKE '%{input.FeeName}'");
            }
            if (!string.IsNullOrWhiteSpace(input.WebSite))
            {
                sql.Append(" AND s1.website = @site ");
                parameters.Add("site", input.WebSite);
            }
            if (!string.IsNullOrWhiteSpace(input.PlatformType))
            {
                sql.Append(" AND s1.platform = @platform ");
                parameters.Add("platform", input.PlatformType);
            }
            if (isPage)
            {
                //sql.Append($" LIMIT {input.PageNumber} OFFSET {(input.PageIndex - 1) * input.PageNumber}");
                sql.Append($" LIMIT @linits OFFSET @offsets");
                parameters.Add("linits", input.PageNumber);
                parameters.Add("offsets", (input.PageIndex - 1) * input.PageNumber);
            }
            if (isSum)
            {
                sql.Append(" GROUP BY s1.platform,s1.website");
            }
            return sql.ToString();
        }
        /// <summary>
        /// 导出平台费用信息
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public List<MonthPlatformProfitDto> ExportMonthProfitFeePlatformFeeDetail(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeePlatformFeeDetailSql(input, out DynamicParameters parameters, false, false);
            var data = SimpleCRUD.Query<MonthPlatformProfitDto>(sql, parameters, GlobalConfig.ConnectionString_DW).ToList();
            List<ReversalDto> listReversal = SimpleCRUD.Query<ReversalDto>("SELECT DISTINCT platform, website FROM order_fee_config WHERE is_reversal = 1;", null, GlobalConfig.ConnectionString_DW).ToList();
            if (input.FeeName.Contains("仓储费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.PlatForm.ToLower() == "wish")
                    {
                        x.AmountVal = Math.Abs(x.AmountVal.Value) * -1;
                        x.AmountValRmb = Math.Abs(x.AmountValRmb.Value) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("广告及宣传费"))
            {
                data = data.Select(x =>
                {
                    if (x.PlatForm.ToLower() == "dhgate" || x.PlatForm.ToLower() == "etsy" || x.PlatForm.ToLower() == "shopify")
                    {
                        x.AmountVal = Math.Abs(x.AmountVal.Value) * -1;
                        x.AmountValRmb = Math.Abs(x.AmountValRmb.Value) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("尾程物流费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.PlatForm.ToLower() == "lazada")
                    {
                        x.AmountVal = Math.Abs(x.AmountVal.Value) * -1;
                        x.AmountValRmb = Math.Abs(x.AmountValRmb.Value) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("加：营业外收入"))
            {
                data.Remove(data.Where(x => x.PlatForm == "亚马逊" && x.WebSite.ToLower() == "mx" && x.AmountVal < 0).FirstOrDefault());
            }
            if (listReversal?.Count > 0 && data?.Count > 0)
            {
                listReversal.ForEach(l =>
                {
                    data.ForEach(x => { if (l.platform == x.PlatForm && l.website == x.WebSite) { x.AmountVal = 0 - x.AmountVal; x.AmountValRmb = 0 - x.AmountValRmb; } });
                });
            }
            return data;
        }
        public decimal SyncMonthProfitFeePlatformFeeSummary(GetMonthProfitPlatformDetailInput input)
        {
            var parameters = new DynamicParameters();
            var sql = $@"SELECT s2.platform as platform,s1.website as site,SUM(s1.amountval_rmb) as total
from order_fee_value_amazon s1 
JOIN order_fee_config s2
ON s2.id = s1.order_fee_config_id 
WHERE s1.amountval != 0 AND s1.month = @month 
AND s2.datacenter_col like '%{input.FeeName}' group by s2.platform,s1.website ";
            parameters.Add("month", input.Month);
            var data = SimpleCRUD.Query<(string platform, string site, decimal total)>(sql, parameters, GlobalConfig.ConnectionString_DW).ToList();
            List<ReversalDto> listReversal = SimpleCRUD.Query<ReversalDto>("SELECT DISTINCT platform, website FROM order_fee_config WHERE is_reversal = 1;", null, GlobalConfig.ConnectionString_DW).ToList();
            //2021-09-22张滢萍提出需求：仓储费-平台的wish改负数、广告及宣传费的Dhgate，Etsy，shopify改负数、尾程物流费-平台的lazada改负数
            if (input.FeeName.Contains("仓储费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.platform.ToLower() == "wish")
                    {
                        x.total = Math.Abs(x.total) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("广告及宣传费"))
            {
                data = data.Select(x =>
                {
                    if (x.platform.ToLower() == "dhgate" || x.platform.ToLower() == "etsy" || x.platform.ToLower() == "shopify")
                    {
                        x.total = Math.Abs(x.total) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (input.FeeName.Contains("尾程物流费-平台"))
            {
                data = data.Select(x =>
                {
                    if (x.platform.ToLower() == "lazada")
                    {
                        x.total = Math.Abs(x.total) * -1;
                    }
                    return x;
                }).ToList();
            }
            if (listReversal?.Count > 0 && data?.Count > 0)
            {
                listReversal.ForEach(l =>
                {
                    data = data.Select(x =>
                    {
                        if (l.platform == x.platform && l.website == x.site)
                        {
                            x.total = 0 - x.total;
                        }
                        return x;
                    }).ToList();
                });
            }
            return data.Sum(x => x.total);
        }

        /// <summary>
        /// 退款分页明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public CommonApiResponseDto<PageResult<List<MonthReFundDto>>> GetMonthProfitFeeReFundDetail(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeeReFundDetailSql(input, out DynamicParameters param, false, false);
            //Console.WriteLine($"查询退款分页信息的SQL：{sql}");
            var result = new PageResult<List<MonthReFundDto>>();
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }
                int total = 0;
                var obj = cn.Page<MonthReFundDto>(input.PageIndex, input.PageNumber, sql, ref total, param);
                var data = obj.ToList();
                if (data.Count > 0)
                {
                    var sumSql = BuildMonthProfitFeeReFundDetailSql(input, out DynamicParameters paramSum, false, true);
                    //Console.WriteLine($"查询退款金额汇总信息的SQL：{sql}");
                    var count = cn.Query<(decimal, decimal)>(sumSql, param).FirstOrDefault();
                    data.Add(new MonthReFundDto
                    {
                        BailunAccount = "合计",
                        RefundRmb = Math.Round(count.Item1, 2).ToString(),
                        RefundUsd = Math.Round(count.Item2, 2).ToString(),
                    });
                }
                result = result.ToPageResult(input.PageIndex, total, data);
            }
            return new CommonApiResponseDto<PageResult<List<MonthReFundDto>>> { Data = result };
        }
        public List<MonthReFundDto> ExportMonthProfitFeeReFundDetail(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeeReFundDetailSql(input, out DynamicParameters param, false, false);
            return SimpleCRUD.Query<MonthReFundDto>(sql, param, GlobalConfig.ConnectionString).ToList();
        }
        /// <summary>
        /// 根据平台汇总
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public CommonApiResponseDto<List<MonthReFundSummary>> GetMonthProfitPlatformPlatformSummary(GetMonthProfitPlatformDetailInput input)
        {
            var sql = BuildMonthProfitFeeReFundDetailSql(input, out DynamicParameters param, false, false, true);
            Console.WriteLine($"查询根据平台汇总退款金额信息的SQL：{sql}");
            var data = SimpleCRUD.Query<MonthReFundSummary>(sql, param, GlobalConfig.ConnectionString).ToList();
            return new CommonApiResponseDto<List<MonthReFundSummary>>
            {
                Data = data.Select(x => new MonthReFundSummary
                {
                    Platform = x.Platform,
                    RefundRmb = Math.Round((decimal)x.RefundRmb, 2),
                    RefundUsd = Math.Round((decimal)x.RefundUsd, 2),
                    Totals = x.Totals,
                }).ToList()
            };
        }

        public string BuildMonthProfitFeeReFundDetailSql(GetMonthProfitPlatformDetailInput input, out DynamicParameters parameters, bool isPage = false, bool isSum = false, bool isSummary = false)
        {
            parameters = new DynamicParameters();
            StringBuilder sql = new StringBuilder();
            input.Month = input.Month.Replace("月份", "");
            var start = Convert.ToDateTime(input.Month).Date;
            var end = start.AddMonths(1).Date;
            if (isSummary)//根据平台分组明细汇总
            {
                sql.Append(@"SELECT 
                                    t1.platform_type AS Platform
                                   ,SUM( IFNULL(ROUND( (t1.amount_refund * t2.exchange_rate),3 ),t1.amount_refund_rmb) ) AS RefundRmb
	                               ,SUM( t1.amount_refund_usd ) AS RefundUsd
	                               ,Count(*) AS Totals
                             FROM dc_base_crm_refund t1
                             LEFT JOIN dc_exchange_rate_finance t2 
                                ON t1.order_currency = t2.`code`
                                AND DATE_FORMAT( t1.refund_time, '%Y-%m' ) = t2.`month`
                                -- 2021年10月之后除Aliexpress平台之外都使用财务汇率
                                AND t2.`month` >= '2021-10' 
                                AND t1.platform_type <> 'Aliexpress'
                             WHERE 1 = 1 
	                            AND t1.refund_time >= @start
	                            AND t1.refund_time < @end
	                            AND t1.shipping_status IN ( 'TotalShipping', 'PartShipping' ) 
	                            AND t1.is_deleted = 0 
	                            AND t1.is_freeze = 0 
	                            AND t1.company_id = 1 
	                            -- 平台利润从2021年12月23号后过虑 美美哒和达馨账号数据平台利润从2021年12月23号后过虑 美美哒和达馨账号数据
	                            AND t1.id NOT IN (
			                            SELECT t2.id FROM dc_base_crm_refund t2
		                              INNER JOIN dc_base_oms_order t3 
			                            ON t2.origin_order_id = t3.origin_order_id
			                            AND t3.seller_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
			                            AND t3.purchase_create_time >= '2021-12-23'
		                            WHERE 1 = 1
		                            AND t2.platform_type = 'FBA'
		                            AND t2.bailun_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
		                            AND t2.refund_time >= '2021-12-23'
	                            )
                             GROUP BY
	                             t1.platform_type ");
                parameters.Add("start", start);
                parameters.Add("end", end);
                return sql.ToString();
            }
            if (isSum)
            {
                sql.Append($@"SELECT 
                                    SUM( IFNULL(ROUND( (t1.amount_refund * t2.exchange_rate),3),t1.amount_refund_rmb) ) AS RefundRmb
                                   ,SUM( t1.amount_refund_usd ) AS RefundUsd
                              FROM dc_base_crm_refund t1
                              LEFT JOIN dc_exchange_rate_finance t2 
                                 ON t1.order_currency = t2.`code`
                                 AND DATE_FORMAT( t1.refund_time, '%Y-%m' ) = t2.`month`
                                 -- 2021年10月之后除Aliexpress平台之外都使用财务汇率
                                 AND t2.`month` >= '2021-10' 
                                 AND t1.platform_type <> 'Aliexpress'
                              WHERE 1 = 1 
	                             AND t1.refund_time >= @start
	                             AND t1.refund_time < @end
	                             AND t1.shipping_status IN ( 'TotalShipping', 'PartShipping' ) 
	                             AND t1.is_deleted = 0 
	                             AND t1.is_freeze = 0 
	                             AND t1.company_id = 1 
                                 -- 平台利润从2021年12月23号后过虑 美美哒和达馨账号数据平台利润从2021年12月23号后过虑 美美哒和达馨账号数据
	                             AND t1.id NOT IN (
			                             SELECT t2.id FROM dc_base_crm_refund t2
		                               INNER JOIN dc_base_oms_order t3 
			                             ON t2.origin_order_id = t3.origin_order_id
			                             AND t3.seller_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
			                             AND t3.purchase_create_time >= '2021-12-23'
		                             WHERE 1 = 1
		                             AND t2.platform_type = 'FBA'
		                             AND t2.bailun_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
		                             AND t2.refund_time >= '2021-12-23'
	                             )");
            }
            else
            {
                sql.Append($@"SELECT 
	                                 t1.platform_type AS PlatformType
	                                ,t1.bailun_account AS BailunAccount
	                                ,t1.website AS WebSite
	                                ,t1.origin_order_id AS OriginOrderId
	                                ,IFNULL(ROUND( (t1.amount_refund * t2.exchange_rate),3),t1.amount_refund_rmb) AS RefundRmb
                                    ,t1.amount_refund_usd AS RefundUsd
	                                ,t1.refund_time AS RefundTime
                              FROM dc_base_crm_refund t1
                              LEFT JOIN dc_exchange_rate_finance t2 
                                 ON t1.order_currency = t2.`code`
                                 AND DATE_FORMAT( t1.refund_time, '%Y-%m' ) = t2.`month`
                                 -- 2021年10月之后除Aliexpress平台之外都使用财务汇率
                                 AND t2.`month` >= '2021-10' 
                                 AND t1.platform_type <> 'Aliexpress'
                              WHERE 1 = 1 
	                             AND t1.refund_time >= @start
	                             AND t1.refund_time < @end
	                             AND t1.shipping_status IN ( 'TotalShipping', 'PartShipping' ) 
	                             AND t1.is_deleted = 0 
	                             AND t1.is_freeze = 0 
	                             AND t1.company_id = 1 
	                             -- 平台利润从2021年12月23号后过虑 美美哒和达馨账号数据平台利润从2021年12月23号后过虑 美美哒和达馨账号数据
	                             AND t1.id NOT IN (
			                             SELECT t2.id FROM dc_base_crm_refund t2
		                               INNER JOIN dc_base_oms_order t3 
			                             ON t2.origin_order_id = t3.origin_order_id
			                             AND t3.seller_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
			                             AND t3.purchase_create_time >= '2021-12-23'
		                             WHERE 1 = 1
		                             AND t2.platform_type = 'FBA'
		                             AND t2.bailun_account IN ('Lagunamoon_Beauty', 'Lagunamoon Nail Varnish', 'dawarmthEU','dawarmth') 
		                             AND t2.refund_time >= '2021-12-23'
	                             )");
            }
            parameters.Add("start", start);
            parameters.Add("end", end);
            if (!string.IsNullOrWhiteSpace(input.PlatformType))
            {
                sql.Append($" AND t1.platform_type = @PlatformType ");
                parameters.Add("PlatformType", input.PlatformType);
            }
            if (isPage)
            {
                sql.Append($" LIMIT @linits OFFSET @offsets");
                parameters.Add("linits", input.PageNumber);
                parameters.Add("offsets", (input.PageIndex - 1) * input.PageNumber);
            }
            return sql.ToString();
        }


        public CommonApiResponseDto<PageResult<List<dc_month_sales_profit_orderdetail>>> GetMonthSalesProfitDetail(MonthProfitOrderDetailPageInputDto input, bool isPage = true)
        {
            var data = new List<dc_month_sales_profit_orderdetail>();
            var result = new PageResult<List<dc_month_sales_profit_orderdetail>>();
            int total = 0;
            var sql = $@"SELECT t1.*, t2.origin_order_id, t2.bailun_order_id
FROM dc_month_sales_profit_orderdetail t1
JOIN dc_base_oms_sku t2 ON t1.orderskuid = t2.id
WHERE t1. MONTH = @month 
ORDER BY t1.createtime DESC ";
            var parameters = new DynamicParameters();
            parameters.Add("month", input.Month);
            //LIMIT {input.PageNumber}
            //OFFSET { (input.PageIndex - 1) * input.PageNumber} ";
            if (isPage)
            {
                using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
                {
                    data = cn.Page<dc_month_sales_profit_orderdetail>(input.PageIndex, input.PageNumber, sql, ref total, parameters).ToList();
                }
            }
            else
            {
                data = SimpleCRUD.Query<dc_month_sales_profit_orderdetail>(sql, parameters, GlobalConfig.ConnectionString).ToList();
            }
            data = data.Select(a =>
            {
                a.amount_sales = a.amount_sales * a.quantity_shipped * a.seller_order_exchange_rate;
                a.cost_fba_fee = a.cost_fba_fee * a.quantity_shipped * a.seller_order_exchange_rate;
                a.cost_first = a.cost_first * a.quantity_shipped;
                a.cost_handle_platform = a.cost_handle_platform * a.quantity_shipped;
                a.cost_logistics = a.cost_logistics * a.quantity_shipped;
                a.cost_paypal_fee = a.cost_paypal_fee * a.quantity_shipped * a.seller_order_exchange_rate;
                a.cost_platform_fee = a.cost_platform_fee * (a.platform_type.ToLower() == "ebay" ? a.seller_other_exchange_rate : a.seller_order_exchange_rate) * a.quantity_shipped;
                a.cost_product = a.cost_product * a.quantity_shipped;
                a.total_fee = (a.total_fee - a.shipping) * a.wms_to_cny_exchange_rate * a.quantity_shipped;  //仓储费
                a.sale_profit = a.amount_sales - a.cost_fba_fee - a.cost_first
                - a.cost_handle_platform - a.cost_logistics - a.cost_paypal_fee
                - a.cost_platform_fee - a.cost_product - a.total_fee;
                return a;
            }).ToList();
            result = result.ToPageResult(input.PageIndex, total, data);
            return new CommonApiResponseDto<PageResult<List<dc_month_sales_profit_orderdetail>>> { Data = result };
        }

        public List<PlatformTypeMonthlyStatisticsDto> GetMonthSalesProfiOrderSummary(string month, string financecategory, string isCost = "")
        {
            var param = new DynamicParameters();
            var sql = $@"SELECT * FROM dc_month_sales_profit_order_summary WHERE month = @month
AND summary_type = @cost 
AND financecategoryname LIKE '{financecategory.Replace("其它", "其他").Replace("产品", "")}%' ";
            param.Add("month", month);
            if (isCost.Contains("成本"))
            {
                param.Add("cost", 1);
            }
            else
            {
                param.Add("cost", 0);
            }
            var data = SimpleCRUD.Query<PlatformTypeMonthlyStatisticsDto>(sql.ToString(), param, GlobalConfig.ConnectionString).ToList();
            return data;
        }
        #endregion

        #region 会计科目
        public CommonApiResponseDto<PageResult<List<MonthPlatformProfitDto>>> GetAccountingSubjectFlowPage(AccountingSubjectInput query)
        {
            var tasks = new List<Task>();
            var result = new PageResult<List<MonthPlatformProfitDto>>();
            var pageData = new List<MonthPlatformProfitDto>();
            var sumData = new MonthPlatformProfitDto();
            tasks.Add(Task.Run(() =>
            {
                var sql = BuildAccountingSubjectFlowSql(query, out DynamicParameters param);
                pageData = SimpleCRUD.Query<MonthPlatformProfitDto>(sql, param, GlobalConfig.ConnectionString_DW).ToList();
            }));
            tasks.Add(Task.Run(() =>
            {
                var sqlSum = BuildAccountingSubjectFlowSql(query, out DynamicParameters paramSum, true);
                sumData = SimpleCRUD.Query<MonthPlatformProfitDto>(sqlSum, paramSum, GlobalConfig.ConnectionString_DW).FirstOrDefault();
            }));
            Task.WaitAll(tasks.ToArray());
            if (pageData.Count > 0)
            {
                sumData.Currency = "合计";
                pageData.Add(sumData);
            }
            result = result.ToPageResult(query.PageIndex, sumData.Total, pageData);
            return new CommonApiResponseDto<PageResult<List<MonthPlatformProfitDto>>> { Data = result };
        }
        public string BuildAccountingSubjectFlowSql(AccountingSubjectInput query, out DynamicParameters sqlparam, bool isSum = false, bool isPage = true)
        {
            StringBuilder sql = new StringBuilder();
            if (!isSum)
            {
                sql.Append(@"select t1.platform AS PlatForm,t1.website AS WebSite,t1.orderno AS Orderno,
t1.datatime AS DataTime,t1.amountval AS AmountVal,
t2.feetype AS FeeType,t2.subjectcode AS Subjectcode,t2.projectcode AS ProjectCode,
t2.financecategory AS FinanceCategory,t2.datacenter_col AS DatacenterCol,t2.currency AS Currency,t1.currency AS EbayCurrency,
t1.exchange_rate AS ExchangeRate,t1.amountval_rmb AS AmountValRmb,t1.month AS Month from order_fee_value_amazon t1
                         join order_fee_config t2 on t1.order_fee_config_id=t2.id ");
            }
            else
            {
                sql.Append(@"select sum(amountval) as AmountVal,sum(amountval_rmb) as AmountValRmb,count(*) as Total from order_fee_value_amazon t1
                        join order_fee_config t2 on t1.order_fee_config_id = t2.id ");
            }
            sqlparam = new DynamicParameters();
            //if (!string.IsNullOrEmpty(query.DataCenterCol))
            //{
            //    sql += $" and t2.datacenter_col=@datacenter_col";
            //    sqlparam.Add("datacenter_col", query.DataCenterCol);
            //}

            sql.Append(" where t1.amountval!=0 ");
            if (query.DataType.HasValue)
            {
                sql.Append(" and t1.datatype = @datatype ");
                sqlparam.Add("datatype", query.DataType.Value);
            }
            if (!string.IsNullOrWhiteSpace(query.BillMonth))
            {
                sql.Append(" and t1.month= @month ");
                sqlparam.Add("month", query.BillMonth);
            }
            if (!string.IsNullOrWhiteSpace(query.DataCol))
            {
                sql.Append(" and t2.datacenter_col= @datacenter_col ");
                sqlparam.Add("datacenter_col", query.DataCol);
            }

            if (!string.IsNullOrEmpty(query.PlatForm))
            {
                sql.Append(" and t1.platform = @platform ");
                sqlparam.Add("platform", query.PlatForm);
            }

            if (!string.IsNullOrEmpty(query.Site))
            {
                sql.Append(" and t1.website = @website ");
                sqlparam.Add("website", query.Site);
            }
            //if (!string.IsNullOrEmpty(orderno))
            //{
            //    sql += " and t1.orderno=@orderno";
            //    sqlparam.Add("orderno", orderno);
            //}
            if (query.BillTime != null && query.BillTime.Length == 2 && !string.IsNullOrWhiteSpace(query.BillTime[0]))
            {
                sql.Append(" and t1.datatime >= @start  and t1.datatime < @end ");
                sqlparam.Add("start", Convert.ToDateTime(query.BillTime[0]));
                sqlparam.Add("end", Convert.ToDateTime(query.BillTime[1]).AddDays(1));
            }
            if (isPage && !isSum)
            {
                sql.Append(" order by t1.datatime limit @limit offset @offset");
                sqlparam.Add("offset", (query.PageIndex - 1) * query.PageNumber);
                sqlparam.Add("limit", query.PageNumber);
            }
            return sql.ToString();
        }
        public CommonApiResponseDto<AccountingSubjectOptionsData> GetOptionsData()
        {
            var sql = "select platform,website,datatype from order_fee_col";
            var platformList = SimpleCRUD.Query<PlatformWithSite>(sql, null, GlobalConfig.ConnectionString_DW).ToList();

            var sqlcol = "select datacenter_col from order_fee_config group by datacenter_col";
            var colList = SimpleCRUD.Query<string>(sqlcol, null, GlobalConfig.ConnectionString_DW).ToList();
            return new CommonApiResponseDto<AccountingSubjectOptionsData> { Data = new AccountingSubjectOptionsData { DataCol = colList, PlatformWithSite = platformList } };
        }
        public CommonApiResponseDto ExprotAccountSubject(AccountingSubjectInput query)
        {
            var sql = BuildAccountingSubjectFlowSql(query, out DynamicParameters param, false, false);
            var data = SimpleCRUD.Query<MonthPlatformProfitDto>(sql, param, GlobalConfig.ConnectionString_DW).ToList();
            var table = new DataTable();
            table.Columns.Add("平台");
            table.Columns.Add("站点");
            table.Columns.Add("账单时间");
            table.Columns.Add("单号");
            table.Columns.Add("费用字段说明");
            table.Columns.Add("财务分类归集说明");
            table.Columns.Add("数据中心费用类型");
            table.Columns.Add("会计科目编码");
            table.Columns.Add("项目编码");
            table.Columns.Add("币种");
            table.Columns.Add("原币金额");
            table.Columns.Add("汇率");
            table.Columns.Add("RMB金额");
            table.Columns.Add("月份");
            foreach (var item in data)
            {
                table.Rows.Add(item.PlatForm,
                    item.WebSite,
                    item.DataTime,
                    item.Orderno,
                    item.FeeType,
                    item.FinanceCategory,
                    item.DatacenterCol,
                    item.Subjectcode,
                    item.ProjectCode,
                    item.Currency,
                    item.AmountVal,
                    item.ExchangeRate,
                    item.AmountValRmb,
                    item.Month);
            }
            var filename = $"会计流水账单" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xlsx";
            var result = UploadFile(table, filename);
            if (result.Code == 200)
            {
                return new CommonApiResponseDto { Message = $"http://dcfile.blsct.com/{filename}" };
            }
            return new CommonApiResponseDto { IsSuccess = false, Message = result.RefText + "_" + result.Text };
        }
        #endregion

        #region 同步数据
        /// <summary>
        /// 拉取旧的dc_month_sales_profit表数据到新表，生成新的汇总数据
        /// </summary>
        public bool SyncMonthSalesProfit(string date)
        {
            try
            {
                //拉取旧表数据
                var time = string.Empty;
                if (!string.IsNullOrWhiteSpace(date))
                {
                    time = Convert.ToDateTime(date).ToString("yyyy-MM");
                }
                else
                {
                    time = DateTime.Now.AddMonths(-1).ToString("yyyy-MM");
                }
                var falg = false;
                Console.WriteLine($"{DateTime.Now}开始生成利润报表汇总数据");
                var sql = $"select * from dc_month_sales_profit_v2 where isedit != 1 and month = '{time}'";
                var oldData = SimpleCRUD.Query<dc_month_sales_profit_v2>(sql, null, GlobalConfig.ConnectionString).FirstOrDefault();
                if (oldData == null)
                {
                    falg = true;
                    sql = $"select * from dc_month_sales_profit where isedit != 1 and month = '{time}'";
                    oldData = SimpleCRUD.Query<dc_month_sales_profit_v2>(sql, null, GlobalConfig.ConnectionString).FirstOrDefault();
                }
                if (oldData != null)
                {
                    //对旧表数据进行赋值新数据
                    //var field = new MonthSalesProfitDto();
                    //var name = field.amount_sales_jingyou.GetType().GetCustomAttribute<System.ComponentModel.DisplayNameAttribute>().DisplayName;
                    //销售额
                    oldData.amount_sales_jingyou = Math.Round(GetMonthSalesProfiOrderSummary(time, "精油产品").Sum(x => x.total_amount_sales), 2);
                    oldData.amount_sales_dianzi = Math.Round(GetMonthSalesProfiOrderSummary(time, "电子产品").Sum(x => x.total_amount_sales), 2);
                    oldData.amount_sales_jiaju = Math.Round(GetMonthSalesProfiOrderSummary(time, "家居产品").Sum(x => x.total_amount_sales), 2);
                    oldData.amount_sales_meirongmj = Math.Round(GetMonthSalesProfiOrderSummary(time, "美容美甲产品").Sum(x => x.total_amount_sales), 2);
                    oldData.amount_sales_fuzhuang = Math.Round(GetMonthSalesProfiOrderSummary(time, "服装").Sum(x => x.total_amount_sales), 2);
                    oldData.amount_sales_other = Math.Round(GetMonthSalesProfiOrderSummary(time, "其他").Sum(x => x.total_amount_sales), 2);
                    oldData.fee_refund = Math.Abs(Math.Round(GetMonthProfitPlatformPlatformSummary(new GetMonthProfitPlatformDetailInput { Month = time }).Data.Sum(x => x.RefundRmb.Value), 2)) * (-1);
                    //总销售额
                    oldData.amount_sales = Math.Round(oldData.amount_sales_dianzi + oldData.amount_sales_fuzhuang + oldData.amount_sales_jiaju
                        + oldData.amount_sales_jingyou + oldData.amount_sales_meirongmj + oldData.amount_sales_other + oldData.fee_refund, 2);
                    //成本                                                                                                                                                                  
                    oldData.cost_jingyou = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "精油产品", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    oldData.cost_dianzi = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "电子产品", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    oldData.cost_jiaju = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "家居产品", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    oldData.cost_meirongmj = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "美容美甲产品", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    oldData.cost_fuzhuang = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "服装", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    oldData.cost_other = Math.Abs(Math.Round(GetMonthSalesProfiOrderSummary(time, "其他", "成本").Sum(x => x.total_amount_sales), 2)) * (-1);
                    //总成本
                    oldData.cost = Math.Round(oldData.cost_jingyou + oldData.cost_dianzi + oldData.cost_jiaju
                       + oldData.cost_meirongmj + oldData.cost_fuzhuang + oldData.cost_other, 2);
                    //平台费用

                    oldData.fee_ad = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "广告及宣传费" }), 2)) * (-1);
                    Console.WriteLine("开始统计平台费用");
                    oldData.fee_fba = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "佣金及平台费-亚马逊FBA" }), 2)) * (-1);
                    oldData.fee_nofba = (Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "佣金及平台费-亚马逊非FBA" }), 2));
                    oldData.fee_ebay = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "佣金及平台费-Ebay" }), 2)) * (-1);
                    oldData.fee_ohtre = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "佣金及平台费-其他平台" }), 2)) * (-1);

                    //总平台费
                    oldData.fee_platform = Math.Round(oldData.fee_ad + oldData.fee_fba + oldData.fee_nofba + oldData.fee_ebay + oldData.fee_ohtre, 2);
                    //物流仓储费用
                    Console.WriteLine("开始统计物流仓储费用");
                    oldData.fee_logistics_first = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "头程运输-平台" }), 2)) * (-1);
                    oldData.fee_nologistics_first = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "头程运输-非平台" }), 2)) * (-1);
                    oldData.fee_logistics_tail = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "尾程物流费-平台" }), 2)) * (-1);
                    oldData.fee_nologistics_tail = (Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "尾程物流费-非平台" }), 2)) * (-1);
                    oldData.fee_logistics_direct = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "直邮物流费-平台" }), 2)) * (-1);
                    oldData.fee_nologistics_direct = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "直邮物流费-非平台" }), 2)) * (-1);
                    oldData.fee_storage = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "仓储费-平台" }), 2)) * (-1);
                    oldData.fee_nostorage = Math.Abs(Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "仓储费-非平台" }), 2)) * (-1);
                    //总物流仓储费
                    oldData.fee_logistics_storage = Math.Round(oldData.fee_logistics_first + oldData.fee_nologistics_first + oldData.fee_logistics_tail + oldData.fee_nologistics_tail
                        + oldData.fee_logistics_direct + oldData.fee_nologistics_direct + oldData.fee_storage + oldData.fee_nostorage, 2);

                    Console.WriteLine("开始统计加：营业外收入");

                    //2021-09-23陈文静提出需求 营业外收入的mx站点数值小于0的话，就放入营业外支出
                    //加：营业外收入
                    var nonOperatingList = ExportMonthProfitFeePlatformFeeDetail(new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "营业外收入" });
                    var group = nonOperatingList.GroupBy(x => new { x.PlatForm, x.WebSite }, (m, y) => new
                    {
                        platform = m.PlatForm,
                        site = m.WebSite,
                        sumRmb = y.Sum(s => s.AmountValRmb),
                    }).ToList();
                    var sum = group.Sum(x => x.sumRmb);
                    var groupMx = group.Where(x => x.platform == "亚马逊" && x.site.ToLower() == "mx" && x.sumRmb < 0).Select(x => x.sumRmb).FirstOrDefault() ?? 0;

                    oldData.incoming_non_operating = Math.Round(sum.Value - groupMx, 2);

                    //oldData.incoming_non_operating = Math.Round(SyncMonthProfitFeePlatformFeeSummary(
                    //    new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "营业外收入" }), 2);

                    //减：营业外支出
                    oldData.pay_non_operating = Math.Abs(Math.Round((SyncMonthProfitFeePlatformFeeSummary(
                        new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "营业外支出" }) + Math.Abs(groupMx)), 2)) * (-1);


                    //销售费用-税金
                    //oldData.fee_sales_taxes = Math.Abs(Math.Round(ExportMonthProfitFeePlatformFeeDetail(
                    //    new GetMonthProfitPlatformDetailInput { Month = time, FeeName = "税金" })
                    //    .Where(m => m.AmountValRmb.HasValue).Sum(x => x.AmountValRmb.Value), 2)) * (-1);
                    //其中：歌戈儿收入
                    var operating = GetMonthProfitFeeManagementCostDetail(time, "其中：歌戈儿收入").Data;
                    oldData.incoming_gogirl = Math.Abs(Math.Round(operating.Count == 0 ? 0 : operating.Last().AmountRmb.Value, 2));
                    //其中：其他收入

                    var among_other = GetMonthProfitFeeManagementCostDetail(time, "其中：其他收入").Data;
                    oldData.among_other_income = Math.Abs(Math.Round(among_other.Count == 0 ? 0 : among_other.Last().AmountRmb.Value, 2));

                    //其他收入=出口退税+歌戈尔收入+其中：其他收入
                    oldData.incoming_other = oldData.incoming_refundtax + oldData.incoming_gogirl + oldData.among_other_income;
                    //管理成本
                    Console.WriteLine("开始统计管理成本");
                    var bl_xg = GetMonthProfitFeeManagementCostDetail(time, "香港百伦科技有限公司").Data;
                    var bl_gz = GetMonthProfitFeeManagementCostDetail(time, "广州百伦供应链科技有限公司").Data;
                    var meijia = GetMonthProfitFeeManagementCostDetail(time, "广州歌戈儿生活科技有限公司").Data;
                    var yangshan = GetMonthProfitFeeManagementCostDetail(time, "深圳前海扬杉创新科技有限公司").Data;
                    var xinhuilan = GetMonthProfitFeeManagementCostDetail(time, "广州信荟蓝科技有限公司").Data;
                    var gzdz = GetMonthProfitFeeManagementCostDetail(time, "广州电子服装仓").Data;
                    var ys = GetMonthProfitFeeManagementCostDetail(time, "阳山仓").Data;
                    var dizhi = GetMonthProfitFeeManagementCostDetail(time, "广州迪致美容科技有限公司").Data;
                    var gzlk = GetMonthProfitFeeManagementCostDetail(time, "广州灵酷跨境科技有限公司").Data;
                    var gzcy = GetMonthProfitFeeManagementCostDetail(time, "广州崇瑜信息技术咨询有限公司").Data;

                    oldData.managecost_bl_xg = Math.Abs(Math.Round(bl_xg.Count == 0 ? 0 : bl_xg.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managecost_bl_gz = Math.Abs(Math.Round(bl_gz.Count == 0 ? 0 : bl_gz.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managecost_meijia = Math.Abs(Math.Round(meijia.Count == 0 ? 0 : meijia.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_yangshan = Math.Abs(Math.Round(yangshan.Count == 0 ? 0 : yangshan.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_xinhuilan = Math.Abs(Math.Round(xinhuilan.Count == 0 ? 0 : xinhuilan.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_gzdz = Math.Abs(Math.Round(gzdz.Count == 0 ? 0 : gzdz.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_ys = Math.Abs(Math.Round(ys.Count == 0 ? 0 : ys.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_dizhi = Math.Abs(Math.Round(dizhi.Count == 0 ? 0 : dizhi.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_gzlk = Math.Abs(Math.Round(gzlk.Count == 0 ? 0 : gzlk.Last().AmountRmb.Value, 2)) * (-1);
                    oldData.managercost_gzcy = Math.Abs(Math.Round(gzcy.Count == 0 ? 0 : gzcy.Last().AmountRmb.Value, 2)) * (-1);
                    //总管理成本
                    oldData.managercost_count = Math.Round(oldData.managecost_bl_xg + oldData.managecost_bl_gz + oldData.managecost_meijia + oldData.managercost_yangshan
                        + oldData.managercost_xinhuilan + oldData.managercost_gzdz + oldData.managercost_ys + oldData.managercost_dizhi + oldData.managercost_gzlk
                        + oldData.managercost_gzcy, 2);

                    //oldData.profit_sales = Math.Round(GetMonthSalesProfitDetail(new MonthProfitOrderDetailPageInputDto { Month = time }, false)
                    //.Data.Data.Sum(x => x.sale_profit), 2);

                    Console.WriteLine("开始统计销售费用数据");
                    //销售费用合计》平台费用+物流仓储费+税金
                    oldData.fee_sales_count = Math.Abs(Math.Round(Math.Abs(oldData.fee_platform) + Math.Abs(oldData.fee_logistics_storage) + Math.Abs(oldData.fee_sales_taxes), 2)) * (-1);
                    //销售利润》总销售额-总成本-销售费用合计
                    oldData.profit_sales = Math.Round(Math.Abs(oldData.amount_sales) - Math.Abs(oldData.cost) - Math.Abs(oldData.fee_sales_count), 2);
                    //销售毛利润》销售利润/总销售额
                    oldData.rate_profit_sales = Math.Round(Math.Abs(oldData.profit_sales) / Math.Abs(oldData.amount_sales), 2);
                    //营业利润》销售利润-总管理成本-财务费用
                    oldData.profit = Math.Round(Math.Abs(oldData.profit_sales) - Math.Abs(oldData.managercost_count) - Math.Abs(oldData.fee_finance), 2);
                    //营业毛利率》营业利润/总销售额
                    oldData.rate_profit = Math.Round(oldData.profit / Math.Abs(oldData.amount_sales), 2);
                    //实际利润》营业利润+加：其他收入+加：营业外收入+减：营业外支出
                    oldData.actual_profit = Math.Round(oldData.profit + Math.Abs(oldData.incoming_other) + Math.Abs(oldData.incoming_non_operating) + Math.Abs(oldData.pay_non_operating), 2);
                    //净利润》实际利润/总销售额
                    oldData.rate_profit_actual = Math.Round(oldData.actual_profit / Math.Abs(oldData.amount_sales), 2);
                    //财务费用
                    oldData.fee_finance = Math.Abs(oldData.fee_finance) * (-1);
                    //保存
                    Console.WriteLine("统计完成");
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
                    {
                        if (cn.State == ConnectionState.Closed)
                        {
                            cn.Open();
                        }
                        if (falg)
                        {
                            oldData.createtime = DateTime.Now;
                            oldData.lastupdatetime = DateTime.Now;
                            cn.Insert(oldData);
                            Console.WriteLine($"{DateTime.Now}触发了新增操作");
                        }
                        else
                        {
                            if (oldData.id > 0)
                            {
                                oldData.lastupdatetime = DateTime.Now;
                                cn.Update(oldData);
                                Console.WriteLine($"{DateTime.Now}触发了更新操作");
                            }
                            else
                            {
                                oldData.createtime = DateTime.Now;
                                oldData.lastupdatetime = DateTime.Now;
                                cn.Insert(oldData);
                                Console.WriteLine($"{DateTime.Now}触发了新增操作");
                            }
                        }
                    }
                    Console.WriteLine($"{DateTime.Now}利润报表汇总数据完成");
                }
                return true;
            }
            catch (Exception e)
            {
                Console.WriteLine($"错误信息：{ e.Message}");
                return false;
            }
        }
        /// <summary>
        /// 同步生成销售额和成本的汇总数据
        /// </summary>
        public bool SyncMonthSalesProfiOrderDetail(string date)
        {
            try
            {
                var time = string.Empty;
                if (!string.IsNullOrWhiteSpace(date))
                {
                    time = Convert.ToDateTime(date).ToString("yyyy-MM");
                }
                else
                {
                    time = DateTime.Now.AddMonths(-1).ToString("yyyy-MM");
                }
                var list = new List<dc_month_sales_profit_order_summary>();
                var sql = "select financecategoryname from dc_month_sales_profit_orderdetail group by financecategoryname";
                var categoryName = SimpleCRUD.Query<string>(sql, null, GlobalConfig.ConnectionString_read).ToList();

                foreach (var item in categoryName)
                {
                    var name = item;
                    if (string.IsNullOrWhiteSpace(name))
                    {
                        name = "其他";
                    }
                    list.AddRange(GetPlatformTypeMonthlyStatistics(time, name, false, true).Select(x => new dc_month_sales_profit_order_summary
                    {
                        month = time,
                        total_amount_sales = Math.Round(x.total_amount_sales, 2),
                        original_amount = Math.Round(x.original_amount, 2),
                        platform_type = x.platform_type,
                        total_order = x.total_order,
                        createdate = DateTime.Now,
                        financecategoryname = name,
                        summary_type = 0
                    }));
                    var arry = Enumerable.Range(1, 100).ToArray();
                    //成本
                    list.AddRange(GetPlatformTypeMonthlyStatistics(time, name, true, true).Select(x => new dc_month_sales_profit_order_summary
                    {
                        month = time,
                        total_amount_sales = Math.Round(x.total_amount_sales, 2),
                        original_amount = Math.Round(x.original_amount, 2),
                        platform_type = x.platform_type,
                        total_order = x.total_order,
                        createdate = DateTime.Now,
                        financecategoryname = name,
                        summary_type = 1
                    }));
                }
                if (list.Count > 0)
                {
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
                    {
                        if (cn.State == ConnectionState.Closed)
                        {
                            cn.Open();
                        }
                        foreach (var item in list)
                        {
                            var querySql = $@"SELECT id FROM dc_month_sales_profit_order_summary WHERE month = '{item.month}' 
AND platform_type = '{item.platform_type}' AND financecategoryname = '{item.financecategoryname}' AND summary_type = {item.summary_type} ";
                            var exist = cn.Query<int>(querySql).FirstOrDefault();
                            if (exist > 0)
                            {
                                item.id = exist;
                                cn.Update(item);
                                Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}触发了更新操作");
                            }
                            else
                            {
                                cn.Insert(item);
                                Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}触发了新增操作");
                            }
                        }
                    }
                }
                return true;
            }
            catch (Exception e)
            {
                Console.WriteLine($"错误信息：{ e.Message}");
                return false;
            }
        }
        #endregion
        public dc_month_sales_profit_order_summary GetTest()
        {
            Console.WriteLine("进入测试方法");
            var sql = "SELECT * FROM dc_month_sales_profit_order_summary limit 1";
            var data = SimpleCRUD.Query<dc_month_sales_profit_order_summary>(sql, null, GlobalConfig.ConnectionString).First();
            return data;
        }
        #region 导出
        public bool AddExprotTask(AddExprotTaskInput input)
        {
            try
            {
                //TODO：添加一条为未执行的任务到数据库
                var model = new dc_export_task();
                model.create_user = input.CreateName;
                model.task_json = input.TaskJson;
                model.task_title = input.TaskTitle;
                model.task_type = input.TaskType;
                model.task_status = TaskTypeEnum.NotStarted;
                model.create_date = DateTime.Now;
                using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
                {
                    if (cn.State == ConnectionState.Closed)
                    {
                        cn.Open();
                    }
                    cn.Insert(model);
                }
                return true;
            }
            catch (Exception e)
            {
                Console.WriteLine($"添加导出任务失败：{e.Message}");
                return false;
            }
        }
        public void SyncExprotTask()
        {
            try
            {
                //TODO：获取需要导出的任务
                var sql = "SELECT * FROM dc_export_task WHERE task_status = 1 order by create_date desc limit 1 ";
                var exprotTask = SimpleCRUD.Query<dc_export_task>(sql, null, GlobalConfig.ConnectionString).FirstOrDefault();
                if (exprotTask != null)
                {
                    Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}开始执行：【{exprotTask.task_type}】");
                    UpateExprotTask(exprotTask.id, 2, "", DateTime.Now);
                    //TODO：根据任务进行区分生成文件到服务器
                    var result = new CommonApiResponseDto();
                    //task_type和前端约定好的

                    //TODO：上传文件到七牛云
                    if (exprotTask.task_type == "会计流水")
                    {
                        var json = JsonConvert.DeserializeObject<AccountingSubjectInput>(exprotTask.task_json);
                        result = ExprotAccountSubject(json);
                    }
                    else if (exprotTask.task_type.Contains("平台费用"))
                    {
                        var json = JsonConvert.DeserializeObject<GetMonthProfitPlatformDetailInput>(exprotTask.task_json);
                        result = SyncExportMonthProfitFeePlatformFeeDetail(json, exprotTask.task_title);
                    }
                    else if (exprotTask.task_type.Contains("物流仓储费用"))
                    {
                        var json = JsonConvert.DeserializeObject<GetMonthProfitPlatformDetailInput>(exprotTask.task_json);
                        result = SyncExportMonthProfitFeePlatformFeeDetail(json, exprotTask.task_title);
                    }
                    else if (exprotTask.task_type.Contains("销售额"))
                    {
                        var json = JsonConvert.DeserializeObject<MonthProfitOrderDetailPageInputDto>(exprotTask.task_json);
                        result = SyncExportMonthProfitOrderDetail(json, exprotTask.task_title, false);
                    }
                    else if (exprotTask.task_type.Contains("成本"))
                    {
                        var json = JsonConvert.DeserializeObject<MonthProfitOrderDetailPageInputDto>(exprotTask.task_json);
                        result = SyncExportMonthProfitOrderDetail(json, exprotTask.task_title, true);
                    }
                    else if (exprotTask.task_type.Contains("退款"))
                    {
                        var json = JsonConvert.DeserializeObject<GetMonthProfitPlatformDetailInput>(exprotTask.task_json);
                        result = SyncExportMonthProfitFeeReFundDetail(json, exprotTask.task_title);
                    }
                    //TODO：保存七牛云返回的链接到导出任务并更新任务为执行完成状态
                    if (result.Code == 200)
                    {
                        UpateExprotTask(exprotTask.id, 3, result.Message, null, DateTime.Now);
                    }
                    else
                    {
                        UpateExprotTask(exprotTask.id, 0, result.Message, null, DateTime.Now);
                    }
                    Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}【{exprotTask.task_type}】执行完成");
                }
                else
                {
                    Console.WriteLine(Common.NewConfigHelper.GetByName("QiNiu:AccessKey"));
                    Console.WriteLine(Common.NewConfigHelper.GetByName("QiNiu:SecretKey"));
                    Console.WriteLine($"{DateTime.Now.ToString("yyyy - MM - dd HH: mm:ss")}不存在需要导出的任务！");
                }
            }
            catch (Exception e)
            {
                throw e;
            }
        }
        /// <summary>
        /// 更新任务状态
        /// </summary>
        /// <param name="id"></param>
        /// <param name="status"></param>
        /// <param name="result"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        public void UpateExprotTask(int id, int status, string result, DateTime? start = null, DateTime? end = null)
        {
            var sql = new StringBuilder();
            var param = new DynamicParameters();
            sql.Append($"Update dc_export_task set task_status = @status ");
            param.Add("status", status);
            if (!string.IsNullOrWhiteSpace(result))
            {
                sql.Append($", task_result = @result ");
                param.Add("result", result);
            }
            if (start.HasValue)
            {
                sql.Append($", start_date = @time ");
                param.Add("time", start);
            }
            if (end.HasValue)
            {
                sql.Append($", end_date = @time ");
                param.Add("time", end);
            }
            sql.Append($" Where id = {id}");
            SimpleCRUD.ExecuteSql(sql.ToString(), GlobalConfig.ConnectionString, param);
        }
        /// <summary>
        /// 导出任务分页
        /// </summary>
        /// <returns></returns>
        public CommonApiResponseDto<List<dc_export_task>> GetExportTaskPage()
        {
            var sql = "SELECT * FROM dc_export_task order by create_date desc ";
            var data = SimpleCRUD.Query<dc_export_task>(sql, null, GlobalConfig.ConnectionString).ToList();
            return new CommonApiResponseDto<List<dc_export_task>> { Data = data };
        }
        /// <summary>
        /// 导出平台费用和物流仓储费用
        /// </summary>
        /// <param name="input"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        private CommonApiResponseDto SyncExportMonthProfitFeePlatformFeeDetail(GetMonthProfitPlatformDetailInput input, string name)
        {
            var data = ExportMonthProfitFeePlatformFeeDetail(input);
            var table = new DataTable();
            table.Columns.Add("平台");
            table.Columns.Add("站点");
            table.Columns.Add("账单时间");
            table.Columns.Add("单号");
            table.Columns.Add("币种");
            table.Columns.Add("原币金额");
            table.Columns.Add("汇率");
            table.Columns.Add("RMB金额");
            table.Columns.Add("费用字段说明");
            table.Columns.Add("财务分类归集说明");
            table.Columns.Add("数据中心费用类型");
            table.Columns.Add("会计科目编码");
            table.Columns.Add("项目编码");
            foreach (var item in data)
            {
                table.Rows.Add(item.PlatForm,
                     item.WebSite,
                     item.DataTime,
                     item.Orderno,
                     item.Currency,
                     item.AmountVal,
                     item.ExchangeRate,
                     item.AmountValRmb,
                     item.FeeType,
                     item.FinanceCategory,
                     item.DatacenterCol,
                     item.Subjectcode,
                     item.ProjectCode);
            }
            var filename = $"{name}" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xlsx";
            var result = UploadFile(table, filename);
            if (result.Code == 200)
            {
                return new CommonApiResponseDto { Message = $"http://dcfile.blsct.com/{filename}" };
            }
            return new CommonApiResponseDto { IsSuccess = false, Message = result.RefText + "_" + result.Text };
        }
        /// <summary>
        /// 导出销售额和成本
        /// </summary>
        /// <param name="input"></param>
        /// <param name="name"></param>
        /// <param name="IsCost"></param>
        /// <returns></returns>
        private CommonApiResponseDto SyncExportMonthProfitOrderDetail(MonthProfitOrderDetailPageInputDto input, string name, bool IsCost)
        {
            input.IsPages = false;
            var data = GetMonthProfitOrderDetailPage(input).Data.Items;
            var table = new DataTable();
            table.Columns.Add("财务分类");
            table.Columns.Add("平台类型");
            table.Columns.Add("订单号");
            table.Columns.Add("SKU");
            if (IsCost)
            {

                table.Columns.Add("成本");
                table.Columns.Add("总成本");
            }
            else
            {
                table.Columns.Add("销售额（原币）");
                table.Columns.Add("销售额RMB");
            }
            table.Columns.Add("汇率");
            table.Columns.Add("发货量");
            table.Columns.Add("发货时间");
            table.Columns.Add("创建时间");
            foreach (var item in data)
            {
                table.Rows.Add(item.financecategoryname,
                    item.platform_type,
                    item.origin_order_id,
                    item.bailun_sku,
                    IsCost ? item.cost_product : item.amount_sales,
                    IsCost ? item.cost_product_total : item.amount_sales_rmb,
                    item.seller_order_exchange_rate,
                    item.quantity_shipped,
                    item.shipping_time.ToString("yyyy-MM-dd HH:mm:ss"),
                    item.createtime.ToString("yyyy-MM-dd HH:mm:ss"));
            }

            var filename = $"{name}" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xlsx";
            var result = UploadFile(table, filename);
            if (result.Code == 200)
            {
                return new CommonApiResponseDto { Message = $"http://dcfile.blsct.com/{filename}" };
            }
            return new CommonApiResponseDto { IsSuccess = false, Message = result.RefText + "_" + result.Text };
        }
        /// <summary>
        /// 导出退款
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        private CommonApiResponseDto SyncExportMonthProfitFeeReFundDetail(GetMonthProfitPlatformDetailInput input, string name)
        {
            var data = ExportMonthProfitFeeReFundDetail(input);
            var table = new DataTable();
            table.Columns.Add("平台");
            table.Columns.Add("订单号");
            table.Columns.Add("站点");
            table.Columns.Add("卖家账号");
            table.Columns.Add("退款金额");
            table.Columns.Add("退款USD");
            table.Columns.Add("退款时间");
            foreach (var item in data)
            {
                table.Rows.Add(
                    item.PlatformType,
                    item.OriginOrderId,
                    item.WebSite,
                    item.BailunAccount,
                    item.RefundRmb,
                    item.RefundUsd,
                    item.RefundTime);
            }
            var filename = $"{name}" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xlsx";
            var result = UploadFile(table, filename);
            if (result.Code == 200)
            {
                return new CommonApiResponseDto { Message = $"http://dcfile.blsct.com/{filename}" };
            }
            return new CommonApiResponseDto { IsSuccess = false, Message = result.RefText + "_" + result.Text };
        }
        #endregion
        #region Upload
        private Qiniu.Http.HttpResult UploadFile(DataTable table, string filename)
        {
            var filepath = Directory.GetCurrentDirectory() + "\\Files\\Report\\" + DateTime.Now.ToString("yyyyMMdd") + "\\";
            ExcelHelper.DataTableToExcel(table, filepath + filename, true);
            var content = File.ReadAllBytes(filepath + filename);
            var accesskey = Common.NewConfigHelper.GetByName("QiNiu:AccessKey");
            var secretkey = Common.NewConfigHelper.GetByName("QiNiu:SecretKey");
            Console.WriteLine($"accesskey：【{accesskey}】");
            Console.WriteLine($"secretkey：【{secretkey}】");
            var qiuniu = new QiNiuHelper(accesskey, secretkey);
            return qiuniu.UploadStream(content, filename);
        }
        #endregion

        #region 存货加权计价
        /// <summary>
        /// 查询存货计价
        /// </summary>
        /// <param name="bailunSku"></param>
        /// <param name="month"></param>
        /// <returns></returns>
        public CommonApiResponseDto<GetMonthStockWeightingOutputDto> GetMonthStockWeightingList(string bailunSku, string month, int page, int limit)
        {
            var result = new CommonApiResponseDto<GetMonthStockWeightingOutputDto> { Data = new GetMonthStockWeightingOutputDto { ExportDataTitle = new List<string>(), ExportCNTitle = new List<string>() } };
            if (string.IsNullOrWhiteSpace(month)) return result;
            var dateTime = Convert.ToDateTime(month + "-01");
            var dateNow = DateTime.Now.Date;
            dateNow = dateNow.AddDays(1 - dateNow.Day);
            if (dateTime > dateNow) return result;
            var sql = new StringBuilder();
            var vueColumn = new StringBuilder();
            var param = new DynamicParameters();
            vueColumn.Append("[{\"title\":\"Sku\",\"key\":\"bailun_sku\"},"); ;
            sql.Append("SELECT bailun_sku,");
            result.Data.ExportCNTitle.Add("Sku");
            result.Data.ExportDataTitle.Add("bailun_sku");
            while (dateTime <= dateNow)
            {
                var column = dateTime.ToString("yyyy-MM");
                sql.Append($"MAX(CASE weighted_month WHEN '{column}' THEN weighted_average_price ELSE 0 END ) '{column}',");
                vueColumn.Append("{\"title\":\"" + dateTime.ToString("yyyy年MM月") + "\",\"key\":\"" + column + "\"},");
                dateTime = dateTime.AddMonths(1);
                result.Data.ExportCNTitle.Add(dateTime.ToString("yyyy年MM月"));
                result.Data.ExportDataTitle.Add(column);
            }
            var vueColumnText = vueColumn.ToString().TrimEnd(',');
            vueColumn.Clear();
            vueColumn.Append(vueColumnText);
            vueColumn.Append("]");
            var sqlText = sql.ToString().TrimEnd(',');
            sql.Clear();
            sql.Append(sqlText);
            sql.Append(" FROM dc_month_stock_weighting WHERE 1=1 ");
            if (!string.IsNullOrWhiteSpace(bailunSku))
            {
                sql.Append($" AND bailun_sku like '%{bailunSku}%' ");
            }
            sql.Append(" GROUP BY bailun_sku ");
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                if (limit <= 0)
                {
                    var reader = cn.ExecuteReader(sql.ToString());
                    result.Data.DataTable = new DataTable("dc_month_stock_weighting");
                    result.Data.DataTable.Load(reader);
                }
                else
                {
                    int total = 0;
                    result.Data.Data = cn.Page<dynamic>(page, limit, sql.ToString(), ref total, param).AsList();
                    result.Data.Total = total;
                    result.Data.ColumnText = vueColumn.ToString();
                }

            }
            return result;
        }

        /// <summary>
        /// 同步加权平均价格（首月）
        /// </summary>
        public void SynchMonthStockWeighting()
        {
            var startTime = Convert.ToDateTime("2021-08-01");
            var endTime = Convert.ToDateTime("2021-09-01");
            //var lastMonth = startTime.AddDays(-1);
            var lastMonth = startTime;
            for (int i = 1; i < 100000; i++)
            {
                var skuData = GetMonthStockWeightingSkuList(startTime, endTime, i, 20);
                if (skuData.Count <= 0) break;
                var purchaseData = GetThisMonthStockWeightingSummary(startTime, endTime, skuData);
                if (purchaseData.Count <= 0) continue;
                var lastInventoryData = GetMonthEndInventory(skuData, lastMonth);
                foreach (var subItem in purchaseData)
                {
                    var lastInventoryInfo = lastInventoryData.FirstOrDefault(x => x.bailun_sku == subItem.bailun_sku) ?? new GetMonthStockWeightingSummaryDto();
                    var isSuccess = AddAddMonthStockWeighting(startTime, subItem, lastInventoryInfo);
                    Console.WriteLine($"写入加权价格：{subItem.bailun_sku}---{subItem.total_price}---{i}");
                }
            }
        }
        public void SynchMonthStockWeightingTwo()
        {
            //todo:获取期初库存、上月加权数、本月入库
#if DEBUG
            var startTime = Convert.ToDateTime("2021-08-01");
            var endTime = Convert.ToDateTime("2021-09-01");
            var upprMonth = startTime.AddMonths(-1).Date.ToString("yyyy-MM");
#else
            var endTime = DateTime.Now.Date;
            endTime = new DateTime(endTime.Year, endTime.Month, 01).Date;
            var startTime = endTime.AddMonths(-1).Date;
            var upprMonth = startTime.AddMonths(-1).Date.ToString("yyyy-MM-dd");
#endif

            for (int i = 1; i < 100000; i++)
            {
                var skuData = GetMonthStockWeightingSkuList(startTime, endTime, i, 20);//从采购单里获取基础sku数据
                if (skuData.Count <= 0) break;
                var purchaseData = GetThisMonthStockWeightingSummary(startTime, endTime, skuData);//获取本期入库数量及单价
                if (purchaseData.Count <= 0) continue;
                var uppr = GetWeightedAveragePrice(skuData, upprMonth);//获取上月结存单价（加权平均数）
                var stock = GetMonthEndInventory(skuData, endTime);//获取上期结存数量（期末库存）
                //todo:首月计算方式期初库存*采购报价+每次采购用采购数量*采购金额之和/总数量（期初库存、采购数量）
                //todo:(上期结存数量×上期结存单价+本期入库数量×本期入库单价)÷(上期结存数量+本期入库数量)=加权平均数。
                foreach (var subItem in purchaseData)
                {
                    var stocks = stock.FirstOrDefault(x => x.bailun_sku == subItem.bailun_sku) ?? new GetMonthStockWeightingSummaryDto();
                    var upprs = uppr.FirstOrDefault(x => x.bailun_sku == subItem.bailun_sku);//这里会出现新采购的sku是没有上月库存的
                    var price = ((Convert.ToDecimal(stocks.on_hand_stock) * (upprs != null ? upprs.weighted_average_price : 0)) + subItem.total_price) / (stocks.on_hand_stock + subItem.total_count);
                    var isSuccess = AddAddMonthStockWeighting(startTime, subItem, stocks, price);
                }
            }
        }

        /// <summary>
        /// 写入存货计价
        /// </summary>
        /// <param name="month"></param>
        /// <param name="purchase"></param>
        /// <param name="lastStock"></param>
        /// <returns></returns>
        private bool AddAddMonthStockWeighting(DateTime month, GetMonthStockWeightingSummaryDto purchase, GetMonthStockWeightingSummaryDto lastStock, decimal? price = null)
        {
            string sql = @"
                         INSERT INTO `dc_month_stock_weighting` (`bailun_sku`, `weighted_month`, `weighted_average_price`, 
                          `month_beginning_stock`, `purchase_unit_price`, `computing_formula`, `create_time`) 
                           VALUES (@bailun_sku, @weighted_month, @weighted_average_price,
                           @month_beginning_stock,@purchase_unit_price, @computing_formula, @create_time);
                         ";
            if (purchase.total_price <= 0) return false;
            var model = new dc_month_stock_weighting
            {
                bailun_sku = purchase.bailun_sku,
                weighted_average_price = price.HasValue ? Math.Round(price.Value, 2) : Math.Round((purchase.total_price + lastStock.total_price) / (purchase.total_count + lastStock.on_hand_stock), 2),
                create_time = DateTime.Now,
                month_beginning_stock = lastStock.on_hand_stock,
                weighted_month = month.ToString("yyyy-MM")
            };
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                var count = cn.Execute(sql, model);
                return count > 0;
            }
        }

        private List<string> GetMonthStockWeightingSkuList(DateTime startTime, DateTime endTime, int page, int limit)
        {
            string sql = $@"
                        SELECT t1.bailun_sku FROM dc_base_purchase_inbound AS t1
                        WHERE DATE(t1.create_time)>='{startTime.ToString("yyyy-MM-dd")}' AND DATE(t1.create_time)<'{endTime.ToString("yyyy-MM-dd")}' AND t1.`status` = 1 
                        GROUP BY t1.bailun_sku ORDER BY t1.bailun_sku ASC  LIMIT {limit} OFFSET {(page - 1) * limit} 
                        ";
            var param = new DynamicParameters();
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                var data = cn.Query<string>(sql).AsList();
                return data;
            }
        }

        /// <summary>
        /// 统计本月采购存货价值
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="skus"></param>
        /// <returns></returns>
        private List<GetMonthStockWeightingSummaryDto> GetThisMonthStockWeightingSummary(DateTime startTime, DateTime endTime, List<string> skus)
        {
            string sqlSku = "('" + string.Join("','", skus) + "')";
            string sql = $@"
                         SELECT temp.bailun_sku,SUM(temp.total_count*temp.price)AS total_price,SUM(temp.total_count) AS total_count FROM(
                         SELECT t1.bailun_sku,t2.price,SUM(t1.count) AS total_count FROM dc_base_purchase_inbound AS t1
                         INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
                         WHERE t1.bailun_sku IN {sqlSku} AND DATE(t1.create_time)>='{startTime.ToString("yyyy-MM-dd")}' AND DATE(t1.create_time)<'{endTime.ToString("yyyy-MM-dd")}'
                          AND t1.`status` = 1 GROUP BY t1.bailun_sku,t2.price)AS temp GROUP BY temp.bailun_sku;
                         ";
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                var data = cn.Query<GetMonthStockWeightingSummaryDto>(sql).AsList();
                return data;
            }
        }

        /// <summary>
        /// 获取上月末库存数及采购价值
        /// </summary>
        /// <param name="skus"></param>
        /// <param name="lastmonth"></param>
        /// <returns></returns>
        private List<GetMonthStockWeightingSummaryDto> GetMonthEndInventory(List<string> skus, DateTime lastMonth)
        {
            string sqlSku = "('" + string.Join("','", skus) + "')";
            //string sql = $@"
            //              SELECT temp.bailun_sku,
            //              CASE WHEN stock_flow.on_hand_stock*temp.price>0 THEN stock_flow.on_hand_stock*temp.price ELSE 0 END AS total_price,
            //              CASE WHEN stock_flow.on_hand_stock>0 THEN stock_flow.on_hand_stock ELSE 0 END AS on_hand_stock  
            //              FROM(SELECT t1.bailun_sku,t1.count,t2.price FROM dc_base_purchase_inbound AS t1
            //              INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
            //              WHERE DATE(t1.create_time)='{lastMonth.ToString("yyyy-MM-dd")}' AND t1.`status` = 1 AND t1.bailun_sku IN {sqlSku}) AS temp
            //              LEFT JOIN (
            //              SELECT bailun_sku,SUM(on_hand_stock)on_hand_stock  FROM(
            //                  SELECT bailun_sku,on_hand_stock
            //                  FROM dc_base_wms_stock_flow WHERE 1=1 AND DATE(order_creation_time) ='{lastMonth.ToString("yyyy-MM-dd")}' AND warehouse_code IN('GZBLZZG','GZBLWH')
            //                  ORDER BY order_creation_time DESC)AS temp GROUP BY bailun_sku
            //              )AS stock_flow ON stock_flow.bailun_sku = temp.bailun_sku;
            //             ";
            DateTime start = lastMonth.AddMonths(-1);
            var sql = $@"SELECT temp.bailun_sku,temp.create_time,
                          CASE WHEN stock_flow.on_hand_stock*temp.price>0 THEN stock_flow.on_hand_stock*temp.price ELSE 0 END AS total_price,
                          CASE WHEN stock_flow.on_hand_stock>0 THEN stock_flow.on_hand_stock ELSE 0 END AS on_hand_stock
                          FROM(
                              SELECT t1.bailun_sku,t1.count,t2.price,MAX(t1.create_time) create_time
                          FROM dc_base_purchase_inbound AS t1
                            INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
                          WHERE t1.create_time >= '{start}' AND t1.create_time < '{lastMonth}'
                            AND t1.`status` = 1 AND t1.bailun_sku IN {sqlSku} group by t1.bailun_sku) AS temp
                            LEFT JOIN (
                          SELECT bailun_sku,SUM(on_hand_stock)on_hand_stock
                          FROM(
                              SELECT bailun_sku,on_hand_stock,MAX(order_creation_time)
                          FROM dc_base_wms_stock_flow WHERE 1=1 AND order_creation_time >= '{start}'
                                                            AND order_creation_time < '{lastMonth}'
                                                            AND warehouse_code IN('GZBLZZG','GZBLWH')
                              GROUP BY bailun_sku )AS temp group by bailun_sku
                          )AS stock_flow ON stock_flow.bailun_sku = temp.bailun_sku;";
            using (var cn = new MySqlConnection(GlobalConfig.ConnectionString))
            {
                if (cn.State == ConnectionState.Closed)
                {
                    cn.Open();
                }
                var data = cn.Query<GetMonthStockWeightingSummaryDto>(sql).AsList();
                return data;
            }
        }
        /// <summary>
        /// 采购单和时点库存明细
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="month"></param>
        /// <returns></returns>
        public object GetMonthStockWeightingDetail(string sku, string month)
        {
            var sqlStock = BuildMonthStockSql(sku, month, out DynamicParameters sqlStockParam);

            var purchase = GetMonthPurchaseDetail(sku, month);
            var stock = SimpleCRUD.Query<GetMonthStockWeightingSummaryDto>(sqlStock, sqlStockParam, GlobalConfig.ConnectionString).ToList();
            return (purchase, stock.Count > 0 ? new List<GetMonthStockWeightingSummaryDto> { stock.FirstOrDefault() } : new List<GetMonthStockWeightingSummaryDto>());
        }
        /// <summary>
        /// 月采购单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="month"></param>
        /// <returns></returns>
        public object GetMonthPurchaseDetail(string sku, string month)
        {
            var sqlPurchase = @"SELECT t1.purchase_id,t1.sku_name,t1.bailun_sku, t1.count,t2.price,t1.create_time,(t1.count*t2.price) total_price FROM dc_base_purchase_inbound AS t1
                         INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
                         WHERE t1.bailun_sku = @sku AND t1.create_time >= @start AND t1.create_time < @end
                          AND t1.`status` = 1";
            var sqlPurchaseParam = new DynamicParameters();
            sqlPurchaseParam.Add("sku", sku);
            var time = Convert.ToDateTime(month);
            var timeEnd = time.AddMonths(1);
            sqlPurchaseParam.Add("start", time);
            sqlPurchaseParam.Add("end", timeEnd);
            var purchase = SimpleCRUD.Query<dynamic>(sqlPurchase, sqlPurchaseParam, GlobalConfig.ConnectionString).ToList();
            return purchase;
        }
        public object GetMonthStockWeightingSummary(string sku, string month)
        {
            var purchaseSql = @"SELECT temp.bailun_sku,SUM(temp.total_count*temp.price)AS total_price,SUM(temp.total_count) AS total_count,avg(temp.price) avg_price FROM(
                         SELECT t1.bailun_sku,t2.price,SUM(t1.count) AS total_count FROM dc_base_purchase_inbound AS t1
                         INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
                         WHERE t1.bailun_sku = @sku AND t1.create_time >= @start AND t1.create_time < @end
                          AND t1.`status` = 1 GROUP BY t1.bailun_sku,t2.price) AS temp GROUP BY temp.bailun_sku;";
            var sqlStock = BuildMonthStockSql(sku, month, out DynamicParameters sqlStockParam);
            var purchaseParam = new DynamicParameters();
            var time = Convert.ToDateTime(month);
            var timeEnd = time.AddMonths(1);
            purchaseParam.Add("start", time);
            purchaseParam.Add("end", timeEnd);
            purchaseParam.Add("sku", sku);
            var purchase = SimpleCRUD.Query<dynamic>(purchaseSql, purchaseParam, GlobalConfig.ConnectionString).ToList();
            var stock = SimpleCRUD.Query<GetMonthStockWeightingSummaryDto>(sqlStock, sqlStockParam, GlobalConfig.ConnectionString).ToList();
            var upperSql = $"select weighted_average_price FROM dc_month_stock_weighting where weighted_month = '{time.AddMonths(-1).ToString("yyyy-MM")}' and bailun_sku = '{sku}' ";
            var upper = SimpleCRUD.Query<decimal>(upperSql, null, GlobalConfig.ConnectionString).FirstOrDefault();
            return (purchase, stock, upper);
        }
        /// <summary>
        /// 月加权平均数
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="month"></param>
        /// <returns></returns>
        public List<AveragePrice> GetWeightedAveragePrice(List<string> sku, string month)
        {
            var skuStr = $"('{string.Join("','", sku)}')";
            var sql = $"select bailun_sku,weighted_average_price FROM dc_month_stock_weighting where weighted_month = '{month}' and bailun_sku in {skuStr} ";
            var data = SimpleCRUD.Query<AveragePrice>(sql, null, GlobalConfig.ConnectionString).ToList();
            return data;
        }
        private string BuildMonthStockSql(string sku, string month, out DynamicParameters param)
        {
            var sqlStock = @"SELECT temp.bailun_sku,temp.price,
       warehouse_code,warehouse_name,availabel_stock,in_bound_stock,order_creation_time,
                          CASE WHEN stock_flow.on_hand_stock*temp.price>0 THEN stock_flow.on_hand_stock*temp.price ELSE 0 END AS total_price,
                          CASE WHEN stock_flow.on_hand_stock>0 THEN stock_flow.on_hand_stock ELSE 0 END AS on_hand_stock  
                          FROM(SELECT t1.bailun_sku,t1.count,t2.price,t1.create_time FROM dc_base_purchase_inbound AS t1
                          INNER JOIN dc_base_purchase AS t2 ON t2.purchase_id = t1.purchase_id AND t2.bailun_sku = t1.bailun_sku
                          WHERE t1.create_time >= @purchasestart AND t1.create_time < @purchaseend and t1.`status` = 1 AND t1.bailun_sku = @sku1 ) AS temp
                          LEFT JOIN(
                              SELECT bailun_sku, on_hand_stock,
       warehouse_code,warehouse_name,availabel_stock,in_bound_stock,order_creation_time
                              FROM dc_base_wms_stock_flow WHERE 1 = 1 AND  order_creation_time >= @stockstart and order_creation_time < @stockend AND warehouse_code IN('GZBLZZG', 'GZBLWH')
                              and bailun_sku = @sku2
                              ORDER BY order_creation_time DESC limit 1
                          )AS stock_flow ON stock_flow.bailun_sku = temp.bailun_sku order by create_time desc limit 1";

            param = new DynamicParameters();
            var time = Convert.ToDateTime(month);
            var timeStart = time.AddMonths(-1);
            param.Add("sku1", sku);
            param.Add("sku2", sku);
            param.Add("purchasestart", timeStart);
            param.Add("purchaseend", time);
            param.Add("stockstart", timeStart);
            param.Add("stockend", time);
            return sqlStock;
        }
        #endregion
    }
}
