﻿using Bailun.DC.Common;
using Bailun.DC.Models.Component.DTO;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using NPOI.XSSF.Streaming;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;

namespace Bailun.DC.Services.Component
{
    /// <summary>
    /// 查询组件基类
    /// </summary>
    public class BaseService
    {
        private MySqlConnection _DB;

        public MySqlConnection DB
        {
            get
            {
                if (_DB == null)
                {
                    _DB = new MySqlConnection(GlobalConfig.ConnectionString);
                }
                if (_DB.State == ConnectionState.Closed)
                {
                    _DB.Open();
                }
                return _DB;
            }
        }

        private MySqlConnection _DW_DB;

        public MySqlConnection DW_DB
        {
            get
            {
                if (_DW_DB == null)
                {
                    _DW_DB = new MySqlConnection(GlobalConfig.ConnectionString_DW);
                }
                if (_DW_DB.State == ConnectionState.Closed)
                {
                    _DW_DB.Open();
                }
                return _DW_DB;
            }
        }

        private MySqlConnection _PRO_DB;

        public MySqlConnection PRO_DB
        {
            get
            {
                if (_PRO_DB == null)
                {
                    _PRO_DB = new MySqlConnection(GlobalConfig.ConnectionString_Pro);
                }
                if (_PRO_DB.State == ConnectionState.Closed)
                {
                    _PRO_DB.Open();
                }
                return _PRO_DB;
            }
        }

        private MySqlConnection _FUND_DB;

        public MySqlConnection FUND_DB
        {
            get
            {
                if (_FUND_DB == null)
                {
                    _FUND_DB = new MySqlConnection(GlobalConfig.ConnectionString_Fund);
                }
                if (_FUND_DB.State == ConnectionState.Closed)
                {
                    _FUND_DB.Open();
                }
                return _FUND_DB;
            }
        }

        public IEnumerable<T> DeserializeCollection<T>(string jsonStr)
        {
            IEnumerable<T> list = default(IEnumerable<T>);
            try
            {
                list = JsonConvert.DeserializeObject<IEnumerable<T>>(jsonStr);
            }
            catch
            {
                if (typeof(T) == typeof(string))
                {
                    list = new List<T>() { JsonConvert.DeserializeObject<T>(jsonStr) };
                }
            }

            return list;
        }

        public static byte[] DataTableToExcel(IDictionary<string, string> listHeader, DataTable table)
        {
            return BaseService.DataTableToExcel(listHeader?.Select(l => new ColumnDTO { Prop = l.Key, Name = l.Value }), table);
        }

        public static byte[] DataTableToExcel(IEnumerable<ColumnDTO> listColumn, DataTable table)
        {
            byte[] b = null;
            int headerCount = listColumn?.Count() ?? 0;
            int tableCount = table?.Rows.Count ?? 0;
            if (headerCount > 0 || tableCount > 0)
            {
                IWorkbook workbook = null;
                MemoryStream ms = null;
                try
                {
                    workbook = new HSSFWorkbook();
                    int excelMaxRowCount = 65535;
                    for (int i = 0; (i == 0 && tableCount == 0) || (i * excelMaxRowCount < tableCount); i++)
                    {
                        ISheet sheet = workbook.CreateSheet($"Sheet{i + 1}");
                        //标题行
                        IRow headerRow = sheet.CreateRow(0);
                        //新建一个字体样式对象
                        IFont fontTitle = workbook.CreateFont();
                        //设置字体加粗样式
                        fontTitle.IsBold = true;
                        //设置字体大小 
                        fontTitle.FontHeightInPoints = 12;
                        //单元格样式
                        ICellStyle styleTitle = workbook.CreateCellStyle();
                        //标题 
                        if (headerCount > 0)
                        {
                            listColumn.ForEach((l, col) =>
                            {
                                ICell cell = headerRow.CreateCell(col);
                                cell.CellStyle = styleTitle;
                                cell.SetCellValue(l.Name);
                            });
                        }
                        else
                        {
                            foreach (DataColumn column in table.Columns)
                            {
                                var cell = headerRow.CreateCell(column.Ordinal);
                                cell.CellStyle = styleTitle;
                                cell.SetCellValue(column.ColumnName);
                            }
                        }
                        //数据
                        for (int row = (i * excelMaxRowCount), j = 0; (row < tableCount && j < excelMaxRowCount); row++, j++)
                        {
                            IRow dataRow = sheet.CreateRow(row + 1);
                            if (headerCount > 0)
                            {
                                listColumn.ForEach((header, col) =>
                                {
                                    string value = table.Rows[row][header.Name]?.ToString();
                                    if (!string.IsNullOrWhiteSpace(value))
                                    {
                                        if (header.Format is bool && header.Format == true)
                                        {
                                            if (value.Equals("true", StringComparison.OrdinalIgnoreCase) || value == "1")
                                            {
                                                value = "是";
                                            }
                                            else if (value.Equals("false", StringComparison.OrdinalIgnoreCase) || value == "0")
                                            {
                                                value = "否";
                                            }
                                        }
                                        else if (header.Format is string)
                                        {
                                            DateTime parseTime = DateTime.Now;
                                            if (DateTime.TryParse(value, out parseTime))
                                            {
                                                value = parseTime.ToString(header.Format.Replace("hh", "HH"));
                                            }
                                        }
                                        dataRow.CreateCell(col).SetCellValue(value);
                                    }
                                });
                            }
                            else
                            {
                                foreach (DataColumn column in table.Columns)
                                {
                                    dataRow.CreateCell(column.Ordinal).SetCellValue(table.Rows[row][column]?.ToString());
                                }
                            }
                        }
                    }
                    //写入workbook
                    workbook.Write(ms = new MemoryStream());
                    b = ms.ToArray();
                }
                catch (Exception ex)
                {
                    throw ex;
                }
                finally
                {
                    if (workbook != null)
                    {
                        workbook.Close();
                        workbook = null;
                    }
                    if (ms != null)
                    {
                        ms.Close();
                        ms.Dispose();
                        ms = null;
                    }
                }
            }

            return b;
        }

        public static byte[] DataReaderToExcel(IDictionary<string, string> listHeader, IDataReader reader, int dataCount)
        {
            return BaseService.DataReaderToExcel(listHeader?.Select(l => new ColumnDTO { Prop = l.Key, Name = l.Value }), reader, dataCount);
        }

        public static byte[] DataReaderToExcel(IEnumerable<ColumnDTO> listColumn, IDataReader reader, int dataCount)
        {
            byte[] data = null;

            if (listColumn?.Count() > 0)
            {
                IWorkbook workbook = null;
                MemoryStream ms = null;
                try
                {
                    workbook = dataCount <= 65535 ? (IWorkbook)new HSSFWorkbook() : new SXSSFWorkbook();
                    int excelMaxRowCount = dataCount <= 65535 ? 65535 : 1048576;
                    for (int i = 0; (i * excelMaxRowCount < dataCount); i++)
                    {
                        ISheet sheet = workbook.CreateSheet($"Sheet{i + 1}");
                        //标题行
                        IRow headerRow = sheet.CreateRow(0);
                        //新建一个字体样式对象
                        IFont fontTitle = workbook.CreateFont();
                        //设置字体加粗样式
                        fontTitle.IsBold = true;
                        //设置字体大小 
                        fontTitle.FontHeightInPoints = 12;
                        //单元格样式
                        ICellStyle styleTitle = workbook.CreateCellStyle();
                        listColumn.ForEach((l, col) =>
                        {
                            var cell = headerRow.CreateCell(col);
                            cell.CellStyle = styleTitle;
                            cell.SetCellValue(l.Name);
                        });
                        for (int row = 0; row < excelMaxRowCount && reader.Read(); row++)
                        {
                            IRow dataRow = sheet.CreateRow(row + 1);
                            listColumn.ForEach((header, col) =>
                            {
                                string value = reader[header.Prop]?.ToString();
                                if (!string.IsNullOrWhiteSpace(value))
                                {
                                    if (header.Format is bool && header.Format == true)
                                    {
                                        if (value.Equals("true", StringComparison.OrdinalIgnoreCase) || value == "1")
                                        {
                                            value = "是";
                                        }
                                        else if (value.Equals("false", StringComparison.OrdinalIgnoreCase) || value == "0")
                                        {
                                            value = "否";
                                        }
                                    }
                                    else if (header.Format is string)
                                    {
                                        DateTime parseTime = DateTime.Now;
                                        if (DateTime.TryParse(value, out parseTime))
                                        {
                                            value = parseTime.ToString(header.Format.Replace("hh", "HH"));
                                        }
                                    }
                                    dataRow.CreateCell(col).SetCellValue(value.ToString());
                                }
                                else if (dataCount > 65535)
                                {
                                    dataRow.CreateCell(col).SetCellValue(string.Empty);
                                }
                            });
                        }
                    }
                    //写入workbook
                    workbook.Write(ms = new MemoryStream());
                    data = ms.ToArray();
                }
                catch (Exception ex)
                {
                    throw ex;
                }
                finally
                {
                    if (workbook != null)
                    {
                        workbook.Close();
                        workbook = null;
                    }
                    if (reader != null)
                    {
                        reader.Dispose();
                        reader = null;
                    }
                    if (ms != null)
                    {
                        ms.Close();
                        ms.Dispose();
                        ms = null;
                        GC.Collect();
                    }
                }
            }

            return data;
        }
    }

    public static class IEnumerableExtension
    {
        public static void ForEach<T>(this IEnumerable<T> enumeration, Action<T> action)
        {
            foreach (var item in enumeration)
            {
                action(item);
            }
        }

        public static void ForEach<T>(this IEnumerable<T> enumeration, Action<T, int> action)
        {
            int index = 0;
            foreach (var item in enumeration)
            {
                action(item, index);
                index++;
            }
        }
    }
}
