﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 预计销售利润表
    /// </summary>
    public class dc_month_sales_profit_v2
    {
        /// <summary>
		/// auto_increment
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 月份
        /// </summary>
        public string month { get; set; }
        /// <summary>
        /// 总销售额
        /// </summary>
        public decimal amount_sales { get; set; }
        /// <summary>
        /// 销售额-精油
        /// </summary>
        public decimal amount_sales_jingyou { get; set; }
        /// <summary>
        /// 销售额-电子
        /// </summary>
        public decimal amount_sales_dianzi { get; set; }
        /// <summary>
        /// 销售额-家居产品
        /// </summary>
        public decimal amount_sales_jiaju { get; set; }
        /// <summary>
        /// 销售额-美容美甲产品
        /// </summary>
        public decimal amount_sales_meirongmj { get; set; }
        /// <summary>
        /// 销售额-服装
        /// </summary>
        public decimal amount_sales_fuzhuang { get; set; }

        /// <summary>
        /// 销售额-其他
        /// </summary>
        public decimal amount_sales_other { get; set; }

        /// <summary>
        /// 总成本
        /// </summary>
        public decimal cost { get; set; }
        /// <summary>
        /// 精油成本
        /// </summary>
        public decimal cost_jingyou { get; set; }
        /// <summary>
        /// 电子成本
        /// </summary>
        public decimal cost_dianzi { get; set; }
        /// <summary>
        /// 家居成本
        /// </summary>
        public decimal cost_jiaju { get; set; }
        /// <summary>
        /// 美容美甲产品成本
        /// </summary>
        public decimal cost_meirongmj { get; set; }
        /// <summary>
        /// 服装成本
        /// </summary>
        public decimal cost_fuzhuang { get; set; }

        /// <summary>
        /// 其他成本
        /// </summary>
        public decimal cost_other { get; set; }


        /// <summary>
        /// 平台扣费及退款
        /// </summary>
        public decimal fee_platform_and_refund { get; set; }
        /// <summary>
        /// 平台费
        /// </summary>
        public decimal fee_platform { get; set; }
        /// <summary>
        /// FBA费
        /// </summary>
        public decimal fee_fba { get; set; }

        /// <summary>
        /// 广告及宣传费用
        /// </summary>
        public decimal fee_ad { get; set; }

        /// <summary>
        /// 平台退款
        /// </summary>
        public decimal fee_refund { get; set; }
        /// <summary>
        /// 平台提现回款
        /// </summary>
        public decimal amount_withdraw { get; set; }
        /// <summary>
        /// 物流仓储费用
        /// </summary>
        public decimal fee_logistics_storage { get; set; }
        /// <summary>
        /// 头程费
        /// </summary>
        public decimal fee_logistics_first { get; set; }

        /// <summary>
        /// 尾程费 国外发货
        /// </summary>
        public decimal fee_logistics_tail { get; set; }


        /// <summary>
        /// 直邮物流费 国内发货
        /// </summary>
        public decimal fee_logistics_direct { get; set; }

        /// <summary>
        /// 海外仓仓储
        /// </summary>
        public decimal fee_storage { get; set; }

        /// <summary>
        /// 海外仓其他杂费
        /// </summary>
        public decimal fee_storage_incidentals { get; set; }

       
        /// <summary>
        /// 付现销售费用
        /// </summary>
        public decimal fee_paycash_sales { get; set; }
        /// <summary>
        /// 销售费用合计
        /// </summary>
        public decimal fee_sales_count { get; set; }
        /// <summary>
        /// 销售利润
        /// </summary>
        public decimal profit_sales { get; set; }
        /// <summary>
        /// 销售毛利率
        /// </summary>
        public decimal rate_profit_sales { get; set; }
        /// <summary>
        /// 管理成本-香港百伦
        /// </summary>
        public decimal managecost_bl_xg { get; set; }
        /// <summary>
        /// 管理成本-广州百伦
        /// </summary>
        public decimal managecost_bl_gz { get; set; }
        /// <summary>
        /// 管理成本-美容美甲店
        /// </summary>
        public decimal managecost_meijia { get; set; }
        /// <summary>
        /// 管理成本-杨杉
        /// </summary>
        public decimal managercost_yangshan { get; set; }
        /// <summary>
        /// 管理成本-成品仓
        /// </summary>
        public decimal managercost_chengpincang { get; set; }

        /// <summary>
        /// 管理成本-信荟蓝
        /// </summary>
        public decimal managercost_xinhuilan { get; set; }

        /// <summary>
        /// 迪致美容
        /// </summary>
        public decimal managercost_dizhi { get; set; }

        /// <summary>
        /// 广州美甲生产仓
        /// </summary>
        public decimal managercost_meijiashengchan { get; set; }

        /// <summary>
        /// 管理成本合计
        /// </summary>
        public decimal managercost_count { get; set; }
        /// <summary>
        /// 财务费用
        /// </summary>
        public decimal fee_finance { get; set; }
        /// <summary>
        /// 营业利润
        /// </summary>
        public decimal profit { get; set; }
        /// <summary>
        /// 营业毛利率
        /// </summary>
        public decimal rate_profit { get; set; }
        /// <summary>
        /// 加：其他收入
        /// </summary>
        public decimal incoming_other { get; set; }

        /// <summary>
        /// 加：出口退税收入
        /// </summary>
        public decimal incoming_refundtax { get; set; }

        /// <summary>
        /// 加：歌戈尔收入
        /// </summary>
        public decimal incoming_gogirl { get; set; }

        /// <summary>
        /// 加：营业外收入
        /// </summary>
        public decimal incoming_non_operating { get; set; }
        /// <summary>
        /// 减：营业外支出
        /// </summary>
        public decimal pay_non_operating { get; set; }
        /// <summary>
        /// 实际利润
        /// </summary>
        public decimal actual_profit { get; set; }
        /// <summary>
        /// 减：分红
        /// </summary>
        public decimal dividend { get; set; }
        /// <summary>
        /// 利润结余
        /// </summary>
        public decimal profit_balance { get; set; }
        /// <summary>
        /// 净利润率
        /// </summary>
        public decimal rate_profit_actual { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public int lastupdateuserid { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public string lastupdateusername { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime lastupdatetime { get; set; }
        /// <summary>
        /// 是否编辑的版本，1：是，0：否
        /// </summary>
        public int isedit { get; set; }

        /// <summary>
        /// 减：资产减值损失
        /// </summary>
        public decimal? impairment_assets { get; set; }


        /// <summary>
        /// 佣金及平台费-亚马逊非FBA
        /// </summary>
        public decimal fee_nofba { get; set; }//new
        /// <summary>
        /// 佣金及平台费-Ebay
        /// </summary>
        public decimal fee_ebay { get; set; }//new
        /// <summary>
        /// 佣金及平台费-其他平台
        /// </summary>
        public decimal fee_ohtre { get; set; }//new
        /// <summary>
        /// 头程运输-非平台
        /// </summary>
        public decimal fee_nologistics_first { get; set; }//new
        /// <summary>
        /// 尾程物流费-非平台
        /// </summary>
        public decimal fee_nologistics_tail { get; set; }//new
        /// <summary>
        /// 直邮物流费-非平台
        /// </summary>
        public decimal fee_nologistics_direct { get; set; }//new
        /// <summary>
        /// 仓储费-非平台
        /// </summary>
        public decimal fee_nostorage { get; set; }//new
        /// <summary>
        /// 销售费用-税金
        /// </summary>
        public decimal fee_sales_taxes { get; set; }//new
        /// <summary>
        /// 广州电子服装仓
        /// </summary>
        public decimal managercost_gzdz { get; set; }//new
        /// <summary>
        /// 阳山仓
        /// </summary>
        public decimal managercost_ys { get; set; }//new
        /// <summary>
        /// 广州灵酷跨境科技有限公司
        /// </summary>
        public decimal managercost_gzlk { get; set; }//new
        /// <summary>
        /// 广州崇瑜信息技术咨询有限公司
        /// </summary>
        public decimal managercost_gzcy { get; set; }//new
        /// <summary>
        /// 其中：其他收入
        /// </summary>
        public decimal among_other_income { get; set; }//new
    }
}
