﻿using Bailun.DC.Models.Stock;
using System;

namespace Bailun.DC.Models.Dtos.Stock
{
    /// <summary>
    /// 获取WMS库存流水返回参数
    /// </summary>
    public class ProductStockFlowApiResponseDto
    {
        /// <summary>
        /// 系统交易流水号
        /// </summary>
        public string SysSerialNumber { get; set; }
        /// <summary>
        /// 产品sku
        /// </summary>
        public string Sku { get; set; }
        /// <summary>
        /// 变更数量
        /// </summary>
        public int ChangeQuantity { get; set; }
        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }
        /// <summary>
        /// 仓库名称
        /// </summary>
        public string WarehouseName { get; set; }

        /// <summary>
        /// 第三方系统交易单号
        /// </summary>
        public string ThirdSysOrderNo { get; set; }

        /// <summary>
        /// 第三方交易单类型
        /// </summary>
        public ThirdSysOrderType ThirdSysOrderType { get; set; }

        /// <summary>
        /// 库存流水数据来源系统
        /// </summary>
        public StockFlowSystemSource SystemSource { get; set; }

        /// <summary>
        /// 收货仓库编码
        /// </summary>
        public string TargetWareNo { get; set; }

        /// <summary>
        /// 收货仓库名称
        /// </summary>
        public string TargetWareName { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public int AvailabelStock { get; set; }
        /// <summary>
        /// 现有库存量
        /// </summary>
        public int OnHandStock { get; set; }
        /// <summary>
        /// 在途库存
        /// </summary>
        public int InboundStock { get; set; }
        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string CreateUserName { get; set; }

        /// <summary>
        /// 第三方单创建时间
        /// </summary>
        public DateTime OrderCreationTime { get; set; }

        /// <summary>
        /// WMS流水创建时间
        /// </summary>
        public  DateTime CreationTime { get; set; }
    }
}
