﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.DataWareHouse
{
    /// <summary>
    /// 解析上传文件流水的异常日志
    /// </summary>
    public class uploadfiles_parsing_error_log
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }


        /// <summary>
        /// uploadfile的关键id
        /// </summary>
        public int uploadfile_id { get; set; }


        /// <summary>
        /// 日志级别，0：记录，1：提醒，2：异常
        /// </summary>
        public int log_level { get; set; }


        /// <summary>
        /// 日志级别名称
        /// </summary>
        public string log_level_name { get; set; }


        /// <summary>
        /// 日志内容
        /// </summary>
        public string log_content { get; set; }


        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }


        /// <summary>
        /// 处理状态，0：未处理，1：无需处理，2：修改配置，3：重新上传文件
        /// </summary>
        public int status { get; set; }


        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime? lastupdatetime { get; set; }


        /// <summary>
        /// 最后更新人id
        /// </summary>
        public int? lastupdateuserid { get; set; }


        /// <summary>
        /// 最后更新人名称
        /// </summary>
        public string lastupdateusername { get; set; }




    }

    /// <summary>
    /// 日志级别，0：记录，1：提醒，2：异常
    /// </summary>
    public enum Enum_LogLevel
    {
        记录 = 0,
        提醒 = 1,
        异常 = 2,
    }
}
