﻿using Dapper;
using System;

namespace Bailun.DC.Models.Component.Entity
{
    /// <summary>
    /// 表单组件
    /// </summary>
    public class dc_component_form
    {
        /// <summary>
        /// ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int? width { get; set; }

        /// <summary>
        /// 标签宽度
        /// </summary>
        public int? label_width { get; set; }

        /// <summary>
        /// 是否显示边框
        /// </summary>
        public bool? is_show_border { get; set; }

        /// <summary>
        /// 是否显示保存按钮 (默认:是)
        /// </summary>
        public bool? is_show_save_button { get; set; }

        /// <summary>
        /// 保存按钮文本 (默认:保存)
        /// </summary>
        public string save_button_text { get; set; }

        /// <summary>
        /// 是否显示取消按钮 (默认:是)
        /// </summary>
        public bool? is_show_cancel_button { get; set; }

        /// <summary>
        /// 取消按钮文本 (默认:保存)
        /// </summary>
        public string cancel_button_text { get; set; }

        /// <summary>
        /// flex布局下的水平排列方式：(默认center)
        /// </summary>
        public string justify { get; set; }

        /// <summary>
        /// 表单项
        /// </summary>
        public string form_item { get; set; }

        /// <summary>
        /// 提交时验证表单：(默认验证)
        /// </summary>
        public bool? is_validate { get; set; }

        /// <summary>
        /// 保存脚本
        /// </summary>
        public string save_script { get; set; }

        /// <summary>
        /// 自定义脚本
        /// </summary>
        public string javascript { get; set; }

        /// <summary>
        /// 引用脚本
        /// </summary>
        public string javascript_src { get; set; }

        /// <summary>
        /// 自定义控件
        /// </summary>
        public string controls { get; set; }

        /// <summary>
        /// 是否可以拉伸：(默认不可以)
        /// </summary>
        public bool? is_drag { get; set; }

        /// <summary>
        /// 是否删除: 1:是; 0:否
        /// </summary>
        [IgnoreUpdate]
        public bool is_delete { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [IgnoreUpdate]
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }
    }
}
