﻿using System;

namespace Bailun.DC.Models.Component.DTO
{
    /// <summary>
    /// 响应结果
    /// </summary>
    [Serializable]
    public class ResultDTO
    {
        /// <summary>
        /// 响应代码)
        /// </summary>
        public int Code { get; set; }

        /// <summary>
        /// 结果
        /// </summary>
        public bool Result { get; set; }

        /// <summary>
        /// 信息
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// 结果集
        /// </summary>
        public object Data { get; set; }
    }

    public class ResultDto<T> : ResultDTO
    {
        /// <summary>
        /// 结果集
        /// </summary>
        public new T Data { get; set; }
    }
}
