﻿namespace Bailun.DC.Models.Common.Page
{
    /// <summary>
    /// 分页请求参数
    /// </summary>
    public class PageRequest
    {
        /// <summary>
        /// 当前页
        /// </summary>
        public int PageIndex { get; set; } = 1;
        /// <summary>
        /// 每页行数
        /// </summary>
        public int PageNumber { get; set; } = 20;
        /// <summary>
        /// 总条数
        /// </summary>
        public long Total { get; set; }
        /// <summary>
        /// 排序字段
        /// </summary>
        public string SortField {get;set;}
        /// <summary>
        /// 排序类型：asc/desc
        /// </summary>    
        public string Sort{get;set;}


    }

    public class PageResponse
    {
        public int Total { get; set; }

        public int CurrentPage { get; set; }

        public int PageSize { get; set; }
    }
}
