﻿using System;
using System.Collections.Generic;

namespace Bailun.DC.SyncPickBillTime.Models
{
    public class ResponseDto
    {
        public bool success { get; set; }

        public bool unAuthorizedRequest { get; set; }

        public string error { get; set; }

        public ResultDto result { get; set; }
    }

    public class ResultDto
    {
        public IList<PickBillDto> result { get; set; }

        public int pageIndex { get; set; }

        public int totalPages { get; set; }

        public int total { get; set; }

        public bool hasPreViousPage { get; set; }

        public bool hasNextPage { get; set; }
    }

    public class PickBillDto
    {
        public int id { get; set; }

        /// <summary>
        /// 配货单号
        /// </summary> 
        public string allocatecargoOrderCode { get; set; }

        /// <summary>
        /// 跟踪号
        /// </summary> 
        public string trackingNo { get; set; }

        /// <summary>
        /// 物流商计费重量
        /// </summary>
        public decimal? merchantOutputWeightKg { get; set; }

        /// <summary>
        /// 物流商金额
        /// </summary>
        public decimal? merchantShipmentCostCNY { get; set; }

        /// <summary>
        /// 物流商币种
        /// </summary>
        public string currencyType { get; set; }

        /// <summary>
        /// 物流商账单日期
        /// </summary>
        public DateTime? merchantReconciliationTime { get; set; }
    }

}
