﻿using Bailun.DC.Models.Stock;

namespace Bailun.DC.SyncMonthStockWeighting.Model
{
    public class WMSRequestDto
    {
        /// <summary>
        /// 
        /// </summary>
        public ProductStockFlowPagesInputDto Data { get; set; }
    }

    public class ProductStockFlowPagesInputDto
    {
        /// <summary>
        /// 交易流水号
        /// </summary>
        public string SysSerialNumber { get; set; }

        /// <summary>
        /// 产品sku
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 第三方单号
        /// </summary>
        public string ThirdSysOrderNo { get; set; }

        /// <summary>
        /// 第三方单号类型
        /// </summary>
        public ThirdSysOrderType? ThirdSysOrderType { get; set; }

        /// <summary>
        /// 第三方单创建时间
        /// </summary>
        public string[] OrderCreationTimes { get; set; }

        /// <summary>
        /// 交易流水记录生成时间
        /// </summary>
        public string[] CreationTimes { get; set; }

        /// <summary>
        /// 分页信息
        /// </summary>
        public Pagination Page { get; set; }
    }

    public class Pagination
    {
        /// <summary>
        /// 
        /// </summary>
        public int Page { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int Rows { get; set; }
    }
}
