﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Bailun.DC.Models;
using Bailun.DC.Models.DataWareHouse;

namespace Bailun.DC.Services.DataWareHouse
{
    public class PlatformOrderServices
    {
        /// <summary>
        /// 获取平台站点信息
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        public List<string> ListPlatformSite(string platform)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = $"select t1.website from flowing_sales t1 where t1.platform='{platform}' group by t1.website";

                return cn.Query<string>(sql).Where(a => !string.IsNullOrEmpty(a)).ToList();
            }
        }

        /// <summary>
        /// 获取平台销售账单流水
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="account">销售帐号</param>
        /// <param name="month">月份</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public List<Models.DataWareHouse.flowing_sales> List(int page, string platform, string website, string account, DateTime? start, DateTime? end, string orderno, string month, ref int total, int pagesize)
        {
            var sql = "select * from flowing_sales t1 where 1=1";
            var sqlparam = new DynamicParameters();

            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            if (!string.IsNullOrEmpty(account))
            {
                sql += " and t1.accountname=@account";
                sqlparam.Add("account", account);
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += " and t1.month=@month";
                sqlparam.Add("month", month);
            }

            if (!string.IsNullOrEmpty(orderno))
            {
                sql += " and t1.orderno=@orderno";
                sqlparam.Add("orderno", orderno);
            }

            if (start.HasValue)
            {
                sql += $" and t1.datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if (end.HasValue)
            {
                sql += $" and t1.datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if (pagesize > 0)
                {
                    var obj = cn.Page<Models.DataWareHouse.flowing_sales>(page, pagesize, sql, ref total, sqlparam);

                    return obj.ToList();
                }
                else
                {
                    var obj = cn.Query<Models.DataWareHouse.flowing_sales>(sql, sqlparam);
                    return obj.ToList();
                }
            }

        }

        /// <summary>
        /// 获取销售平台流水的模版数据
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public Models.DataWareHouse.flowing_sales Get(string platform, string website, DateTime? start, DateTime? end, string month)
        {
            var sql = "select * from flowing_sales where 1=1";
            var sqlParam = new DynamicParameters();

            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and platform=@platform";
                sqlParam.Add("platform", platform);
            }
            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website=@website";
                sqlParam.Add("website", website);
            }

            if (start.HasValue)
            {
                sql += $" and datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }
            if (end.HasValue)
            {
                sql += $" and datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += $" and month=@month";
                sqlParam.Add("month", month);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<Models.DataWareHouse.flowing_sales>(sql, sqlParam);

                return obj;
            }
        }

        /// <summary>
        /// 保存流水信息
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public string InsertOrderBilling(List<Models.DataWareHouse.flowing_sales> list)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    foreach (var item in list)
                    {
                        cn.Insert(item);
                    }
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }


        }

        #region 获取帐号流水解析时间的配置

        /// <summary>
        /// 获取解析流水时间的配置列表
        /// </summary>
        /// <param name="datatype">数据类型</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <returns></returns>
        public List<flowing_sales_config> ListFlowingConfig(int datatype, string platform, string website)
        {
            var sqlparam = new DynamicParameters();
            var sql = "";

            if (datatype == 1)  //销售平台
            {
                sql = "select * from flowing_sales_config where delstatus=0";

                if (!string.IsNullOrEmpty(platform))
                {
                    sql += " and platform=@platform";
                    sqlparam.Add("platform", platform);
                }
                if (!string.IsNullOrEmpty(website))
                {
                    sql += " and website=@website";
                    sqlparam.Add("website", website);
                }
            }
            else if (datatype == 2)
            {
                sql = "select id,t1.platform,t1.website,t1.col_orderno as 'colname_orderno',t1.col_datatime as 'colname_datatime',t1.col_currency as 'colname_currency','' as 'colname_platformsku',t1.delstatus from flowing_logistic_config t1 where t1.delstatus=0";

                if (!string.IsNullOrEmpty(platform))
                {
                    sql += " and platform=@platform";
                    sqlparam.Add("platform", platform);
                }
                if (!string.IsNullOrEmpty(website))
                {
                    sql += " and website=@website";
                    sqlparam.Add("website", website);
                }

            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<flowing_sales_config>(sql, sqlparam).ToList();

            }
        }

        /// <summary>
        /// 保存流水的简单配置
        /// </summary>
        /// <param name="listsaleconfigs">销售流水字段配置</param>
        /// <param name="listlogisticconfigs">物业流水字段配置</param>
        /// <param name="datatype">数据来源，1：销售平台，2：物流</param>
        /// <returns></returns>
        public string SaveFlowingConfig(List<flowing_sales_config> listsaleconfigs, List<flowing_logistic_config> listlogisticconfigs, int datatype)
        {
            try
            {
                if (datatype == 1)
                {
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                    {
                        if (cn.State == System.Data.ConnectionState.Closed)
                        {
                            cn.Open();
                        }

                        foreach (var item in listsaleconfigs)
                        {
                            var obj = cn.QueryFirstOrDefault<flowing_sales_config>($"select * from flowing_sales_config where platform='{item.platform}' and website='{item.website}' and delstatus=0");
                            if (obj != null)
                            {
                                if (obj.colname_currency != item.colname_currency || obj.colname_datatime != item.colname_datatime || obj.colname_orderno != item.colname_orderno || obj.colname_platformsku != item.colname_platformsku)
                                {
                                    obj.delstatus = 1;
                                    cn.Update(obj);
                                }
                                else
                                {
                                    continue;
                                }
                            }

                            cn.Insert(item);
                        }
                    }
                }
                else if (datatype == 2)
                {
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                    {
                        if (cn.State == System.Data.ConnectionState.Closed)
                        {
                            cn.Open();
                        }

                        foreach (var item in listlogisticconfigs)
                        {
                            var obj = cn.QueryFirstOrDefault<flowing_logistic_config>($"select * from flowing_logistic_config where platform='{item.platform}' and website='{item.website}' and delstatus=0");
                            if (obj != null)
                            {
                                if (obj.col_currency != item.col_currency || obj.col_datatime != item.col_datatime || obj.col_orderno != item.col_orderno)
                                {
                                    obj.delstatus = 1;
                                    cn.Update(obj);
                                }
                                else
                                {
                                    continue;
                                }
                            }

                            cn.Insert(item);
                        }

                    }

                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }

        }

        /// <summary>
        /// 删除流水字段解析配置
        /// </summary>
        /// <param name="id"></param>
        /// <param name="datatype"></param>
        /// <returns></returns>
        public string DelFlowingConfig(int id, int datatype)
        {
            try
            {
                if (datatype == 1)
                {
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                    {
                        if (cn.State == System.Data.ConnectionState.Closed)
                        {
                            cn.Open();
                        }

                        var obj = cn.QueryFirstOrDefault<flowing_sales_config>($"select * from flowing_sales_config where id={id} and delstatus=0");
                        if (obj != null)
                        {
                            obj.delstatus = 1;
                            cn.Update(obj);
                        }
                    }
                }
                else if (datatype == 2)
                {
                    using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                    {
                        if (cn.State == System.Data.ConnectionState.Closed)
                        {
                            cn.Open();
                        }

                        var obj = cn.QueryFirstOrDefault<flowing_logistic_config>($"select * from flowing_logistic_config where id={id} and delstatus=0");
                        if (obj != null)
                        {
                            obj.delstatus = 1;
                            cn.Update(obj);
                        }

                    }

                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        #endregion

        #region  上传文件相关

        /// <summary>
        /// 保存文件信息到库
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        public string SaveFileData(Models.DataWareHouse.uploadfiles m)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var id = cn.Insert(m);

                m.id = id ?? 0;

                return "";
            }
        }

        /// <summary>
        /// 更新文件的七牛云标记信息
        /// </summary>
        /// <param name="id"></param>
        /// <param name="hashcode"></param>
        /// <param name="filekey"></param>
        /// <returns></returns>
        public string UpdateFileData(int id, string hashcode, string filekey)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var m = cn.QueryFirstOrDefault<Models.DataWareHouse.uploadfiles>("select * from uploadfiles where id=" + id);
                if (m != null)
                {
                    m.hashcode = hashcode;
                    m.filekey = filekey;

                    cn.Update(m);

                    return "";
                }

                return "找不到该记录";
            }

        }

        /// <summary>
        /// 获取解析成财务会计流水的配置数据
        /// </summary>
        /// <param name="datatype">数据类型，1：销售平台，2：物流数据</param>
        /// <returns></returns>
        public List<Models.DataWareHouse.order_fee_config> ListOrderFeeConfig(int datatype)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select * from order_fee_config where datatype=" + datatype;

                return cn.Query<Models.DataWareHouse.order_fee_config>(sql).ToList();

            }
        }

        /// <summary>
        /// 批量删除财务会计流水数据
        /// </summary>
        /// <param name="datatype">数据类型，1：销售平台，2：物流商</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="month">月份</param>
        /// <param name="uid">用户id</param>
        /// <param name="username">用户名称</param>
        /// <param name="count">受影响数据行数</param>
        /// <returns></returns>
        public string BatchDeleteFinanceAccountFlowing(int datatype, string platform, string website, string month, int uid, string username, ref int count)
        {
            try
            {
                var sql = $"select * from order_fee_value_amazon";
                var sqlwhere = $"  where datatype={datatype} and platform='{platform}' and month='{month}'";

                if (!string.IsNullOrEmpty(website))
                {
                    sqlwhere += $" and website='{website}'";
                }

                //加日志记录标记删除的值

                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    var list = cn.Query<Models.DataWareHouse.order_fee_value_amazon>(sql + sqlwhere).ToList();

                    count = cn.Execute($"update order_fee_value_amazon set isdelete=1,lastupdatetime='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}',lastupdateuserid={uid},lastupdateusername='{username}' where id in ('{string.Join("','", list.Select(a => a.id))}')");

                    return "";

                }
            }
            catch (Exception ex)
            {
                return ex.Message;
            }

        }

        #endregion

        #region 汇率

        /// <summary>
        /// 获取汇率列表
        /// </summary>
        /// <param name="month"></param>
        /// <returns></returns>
        public List<exchange_rate_finance> ListExchangeRate(string month)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.Query<exchange_rate_finance>($"select * from exchange_rate_finance where month='{month}'");

                return obj.ToList();
            }
        }

        /// <summary>
        /// 保存月份汇率
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public string SaveExchangeRate(List<exchange_rate_finance> list)
        {
            for (int i = 1; i <= 2; i++)
            {
                string dc_ = i == 2 ? "dc_" : string.Empty;
                using (var cn = new MySqlConnection(i == 1 ? Common.GlobalConfig.ConnectionString_DW : Common.GlobalConfig.ConnectionString_Data))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    using (MySqlTransaction tran = cn.BeginTransaction())
                    {
                        foreach (var item in list)
                        {
                            var obj = cn.QueryFirstOrDefault<exchange_rate_finance>($"select * from {dc_}exchange_rate_finance where month='{item.month}' and currency='{item.currency}'");
                            if (obj != null)
                            {
                                if (item.exchange_rate != obj.exchange_rate)
                                {
                                    cn.Execute($"update {dc_}exchange_rate_finance set exchange_rate = @exchange_rate where id = @id", new { id = obj.id, exchange_rate = item.exchange_rate });
                                }
                            }
                            else
                            {
                                obj = cn.QueryFirstOrDefault<exchange_rate_finance>($"select * from {dc_}exchange_rate_finance where currency='{item.currency}' order by id desc limit 1");

                                item.code = obj?.code ?? "";
                                item.createtime = DateTime.Now;
                                item.likecondition = obj?.likecondition ?? "";

                                cn.Execute($"insert into {dc_}exchange_rate_finance (`month`,`currency`,`code`,`exchange_rate`,`createtime`,`likecondition`) values (@month,@currency,@code,@exchange_rate,@createtime,@likecondition)", item);
                            }
                        }
                        tran.Commit();
                    }
                }
            }

            return "";
        }

        #endregion
    }
}
