﻿using System;
using System.Collections.Generic;
using System.Text;
using Bailun.DC.Models;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Bailun.DC.Models.DataWareHouse;

namespace Bailun.DC.Services.DataWareHouse
{
    /// <summary>
    /// 解析错误日志服务
    /// </summary>
    public class ParsingErrorLogServices
    {
        public List<flowing_parse_error> ListParsingError(BtTableParameter parameter, string platform, string website, int? datatype,ref int total)
        {
            var sql = "select * from flowing_parse_error where status=0";
            var sqlparam = new DynamicParameters();

            if (datatype.HasValue)
            {
                sql += " and datatype="+datatype.Value;
            }

            if(!string.IsNullOrEmpty(platform))
            {
                sql += " and platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website=@website";
                sqlparam.Add("website", website);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if(parameter.limit==0)
                {
                    return cn.Query<flowing_parse_error>(sql, sqlparam).ToList();
                }
                else
                {
                    return cn.Page<flowing_parse_error>(parameter.pageIndex, parameter.limit, sql, ref total, sqlparam).ToList();
                }
            }

        }

        /// <summary>
        /// 更新异常信息状态
        /// </summary>
        /// <param name="id">异常信息id</param>
        /// <param name="status">状态</param>
        /// <param name="note">更新理由</param>
        /// <returns></returns>
        public string UpdateStatus(int id, int status, string note)
        {



            return "";
        }

    }
}
