﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Bailun.DC.Models.DataWareHouse;
using System.Linq;

namespace Bailun.DC.Services.DataWareHouse
{
    public class LogisticServices
    {
        /// <summary>
        /// 获取销售平台流水的模版数据
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public Models.DataWareHouse.flowing_logistic Get(string platform, string website, DateTime? start, DateTime? end, string month)
        {
            var sql = "select * from flowing_logistic where 1=1";
            var sqlParam = new DynamicParameters();

            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and platformtype=@platform";
                sqlParam.Add("platform", platform);
            }
            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website=@website";
                sqlParam.Add("website", website);
            }

            if (start.HasValue)
            {
                sql += $" and datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }
            if (end.HasValue)
            {
                sql += $" and datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += $" and month=@month";
                sqlParam.Add("month", month);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<Models.DataWareHouse.flowing_logistic>(sql, sqlParam);

                return obj;
            }
        }

        /// <summary>
        /// 获取物流流水的简单配置
        /// </summary>
        /// <returns></returns>
        public List<flowing_logistic_config> ListLogisticConfig()
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }


                return cn.Query<flowing_logistic_config>("select * from flowing_logistic_config").ToList();
            }
        }

        /// <summary>
        /// 获取物流账单流水 json数据
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="platform"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<flowing_logistic> ListFlowingLogistic(int page,int pagesize,string platform, string website,string month, DateTime? start,DateTime? end,string orderno,ref int total)
        {
            var sql = "select * from flowing_logistic where 1=1";
            var sqlparam = new DynamicParameters();

            if(!string.IsNullOrEmpty(platform))
            {
                sql += " and platformtype=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website=@website";
                sqlparam.Add("website", website);
            }

            if (start.HasValue)
            {
                sql += $" and datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if(end.HasValue)
            {
                sql += $" and datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if(!string.IsNullOrEmpty(orderno))
            {
                sql += " and col_orderno=@no";
                sqlparam.Add("no", orderno);
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += " and month=@month";
                sqlparam.Add("month", month);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if (pagesize > 0)
                {
                    var obj = cn.Page<flowing_logistic>(page, pagesize, sql, ref total, sqlparam).ToList();
                    return obj;
                }
                else
                {
                    var obj = cn.Query<flowing_logistic>(sql,sqlparam).ToList();
                    total = obj.Count;

                    return obj;
                }
            }

        }

        /// <summary>
        /// 保存流水信息
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public string InsertOrderBilling(List<Models.DataWareHouse.flowing_logistic> list)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    foreach (var item in list)
                    {
                        SaveOrderBill(cn, item);
                    }
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        public void SaveOrderBill(MySqlConnection cn, flowing_logistic m)
        {
            try
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                cn.Insert(m);
            }
            catch (Exception ex)
            {
                SaveOrderBill(cn, m);
            }
        }

    }
}
