﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 新 月销售利润报表 订单明细
    /// </summary>
    public class dc_month_sales_profit_orderdetail
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }


        /// <summary>
        /// 月份
        /// </summary>
        public string month { get; set; }


        /// <summary>
        /// dc_base_oms_pick的id
        /// </summary>
        public int pickid { get; set; }


        /// <summary>
        /// dc_base_oms_sku的id
        /// </summary>
        public int orderskuid { get; set; }


        /// <summary>
        /// 百伦sku
        /// </summary>
        public string bailun_sku { get; set; }


        /// <summary>
        /// 产品销售额 原币
        /// </summary>
        public decimal amount_sales { get; set; }
        /// <summary>
        /// 产品销售额 人民币
        /// </summary>
        [NotMapped]
        public decimal amount_sales_rmb
        {
            get
            {
                return amount_sales * (finance_order_exchange_rate ?? seller_order_exchange_rate) * quantity_shipped;
            }
        }


        /// <summary>
        /// 产品成本 rmb
        /// </summary>
        public decimal cost_product { get; set; }

        [NotMapped]
        public decimal cost_product_total
        {
            get
            {
                return cost_product * quantity_shipped;
            }
        }

        /// <summary>
        /// 平台费 原币 ，ebay 取other汇率
        /// </summary>
        public decimal cost_platform_fee { get; set; }


        /// <summary>
        /// paypal费 原币
        /// </summary>
        public decimal cost_paypal_fee { get; set; }


        /// <summary>
        /// 头程费 rmb
        /// </summary>
        public decimal cost_first { get; set; }


        /// <summary>
        /// 尾程费 rmb
        /// </summary>
        public decimal cost_logistics { get; set; }


        /// <summary>
        /// 平台操作费 rmb
        /// </summary>
        public decimal cost_handle_platform { get; set; }


        /// <summary>
        /// 物流总费用
        /// </summary>
        public decimal total_fee { get; set; }


        /// <summary>
        /// 物流运输费
        /// </summary>
        public decimal shipping { get; set; }


        private decimal _seller_order_exchange_rate;
        /// <summary>
        /// 订单汇率
        /// </summary>
        public decimal seller_order_exchange_rate { get { return finance_order_exchange_rate ?? _seller_order_exchange_rate; } set { _seller_order_exchange_rate = value; } }


        /// <summary>
        /// 订单其他汇率
        /// </summary>
        public decimal seller_other_exchange_rate { get; set; }


        /// <summary>
        /// 财务汇率
        /// </summary>
        public decimal? finance_order_exchange_rate { get; set; }


        /// <summary>
        /// 物流汇率
        /// </summary>
        public decimal wms_to_cny_exchange_rate { get; set; }


        /// <summary>
        /// 发货数量
        /// </summary>
        public int quantity_shipped { get; set; }


        /// <summary>
        /// 发货时间，FBA的是创建时间
        /// </summary>
        public DateTime shipping_time { get; set; }


        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }


        /// <summary>
        /// fba费 原币
        /// </summary>
        public decimal cost_fba_fee { get; set; }


        /// <summary>
        /// 财务分类
        /// </summary>
        public string financecategoryname { get; set; }


        /// <summary>
        /// 
        /// </summary>
        public DateTime createtime { get; set; }


        public string origin_order_id { get; set; }

        public string bailun_order_id { get; set; }

        public decimal sale_profit { get; set; }

        /// <summary>
        /// 订单币种
        /// </summary>
        public string order_currency { get; set; }
    }
}
