﻿using System;

namespace Bailun.DC.Models.Dtos.Stock
{
    /// <summary>
    /// 存货统计
    /// </summary>
    public class GetMonthStockWeightingSummaryDto
    {
        /// <summary>
        /// sku
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 总金额
        /// </summary>
        public decimal total_price { get; set; }
        public decimal price { get; set; }

        /// <summary>
        /// 总数量
        /// </summary>
        public int total_count { get; set; }

        /// <summary>
        /// 月末库存
        /// </summary>
        public int on_hand_stock { get; set; }

        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public int availabel_stock { get; set; }
        public int in_bound_stock { get; set; }
        public DateTime? order_creation_time { get; set; }
        public string order_creation_timeStr
        {
            get
            {
                if (order_creation_time.HasValue)
                {
                    return order_creation_time.Value.ToString("yyyy-MM-dd");
                }
                return "";
            }
        }
    }
    public class AveragePrice
    {
        public string bailun_sku { get; set; }
        /// <summary>
        /// 加权平均价
        /// </summary>
        public decimal weighted_average_price { get; set; }
    }
    //public class GetMonthStockWeightingSummary
    //{
    //    public dynamic purchase { get; set; }
    //    public GetMonthStockWeightingSummaryDto stock { get; set; }
    //    public decimal upper { get; set; }
    //}
}
