﻿using System.ComponentModel;

namespace Bailun.DC.Models.Component.Enum
{
    /// <summary>
    /// 列名类型：1：SQL(首次)，2：SQL，3：配置，3：API
    /// </summary>
    public enum ColumnTypeEnum
    {
        /// <summary>
        /// SQL(首次)
        /// </summary>
        [Description("SQL(首次)")]
        SqlFirst = 1,
        /// <summary>
        /// SQL
        /// </summary>
        [Description("SQL")]
        Sql = 2,
        /// <summary>
        /// 本地配置
        /// </summary>
        [Description("配置")]
        Config = 3,
        /// <summary>
        /// API
        /// </summary>
        [Description("API")]
        Api = 4,
    }

    /// <summary>
    /// 列名类型：1：Api，2：Sql，3：数据库表或视图，4：动态SQL，5：储存过程，6：储存过程名称
    /// </summary>
    public enum DataTypeEnum
    {
        /// <summary>
        /// API
        /// </summary>
        [Description("Api")]
        Api = 1,

        /// <summary>
        /// SQL
        /// </summary>
        [Description("SQL")]
        Sql = 2,

        /// <summary>
        /// 数据库表或视图
        /// </summary>
        [Description("数据库表或视图")]
        Table = 3,

        /// <summary>
        /// 动态SQL
        /// </summary>
        [Description("动态SQL")]
        DynamicSql = 4,

        /// <summary>
        /// 储存过程
        /// </summary>
        [Description("储存过程")]
        ExecuteSql = 5,

        /// <summary>
        /// 储存过程名称
        /// </summary>
        [Description("储存过程名称")]
        ExecuteName = 6
    }
}
