﻿using Dapper;

namespace Bailun.DC.Models.Component.Entity
{
    /// <summary>
    /// 菜单组件
    /// </summary>
    public class dc_menu
    {
        /// <summary>
        /// ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 父ID
        /// </summary>
        public int parentid { get; set; }

        /// <summary>
        /// 父名称
        /// </summary>
        [NotMapped]
        public string parent_name { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        ///  图标
        /// </summary>
        public string icon { get; set; }

        /// <summary>
        /// 地址
        /// </summary>
        public string path { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int sort { get; set; }

        /// <summary>
        /// 是否删除:(默认否)
        /// </summary>
        [IgnoreUpdate]
        public bool? delstatus { get; set; }

        /// <summary>
        /// 是否管理员可见:(默认否)
        /// </summary>
        public bool is_sys { get; set; }

        /// <summary>
        /// 是否只有开发可见:(默认是)
        /// </summary>
        public bool is_develop { get; set; } 
    }
}
