﻿using Bailun.DC.Models.Component.Enum;
using Dapper;
using System;

namespace Bailun.DC.Models.Component.Entity
{
    /// <summary>
    /// 离线下载组件
    /// </summary>
    public class dc_component_offline_download
    {
        /// <summary>
        /// ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 后缀
        /// </summary>
        public string suffix { get; set; }

        /// <summary>
        /// 过虑条件
        /// </summary>
        public string filter { get; set; }

        /// <summary>
        /// 状态：0：未执行, 1：执行中, 2：完成, 3：失败
        /// </summary>
        public OfflineDownloadStatusEnum? status { get; set; }

        /// <summary>
        /// 消息
        /// </summary>
        public string message { get; set; }

        /// <summary>
        /// 下载地址
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 是否删除: 1:是; 0:否
        /// </summary>
        [IgnoreUpdate]
        public bool is_delete { get; set; }

        /// <summary>
        /// 创建人ID
        /// </summary>
        public int? gmt_create_userid { get; set; }

        /// <summary>
        /// 创建人名称
        /// </summary>
        public string gmt_create_username { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [IgnoreUpdate]
        public DateTime gmt_create_time { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified_time { get; set; }
    }
}
