﻿using Bailun.DC.Models.Component.Enum;
using Newtonsoft.Json;
using System.Collections.Generic;

namespace Bailun.DC.Models.Component.DTO
{
    public class TableDTO
    {
        /// <summary>
        /// ID
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        ///  菜单代码
        /// </summary>
        public string MenuCode { get; set; }

        /// <summary>
        /// Scripts脚本
        /// </summary>
        public string Javascript { get; set; }

        /// <summary>
        /// 是否显示查询按钮:(默认是)
        /// </summary>
        public bool? IsShowSearchButton { get; set; }

        /// <summary>
        /// 是否显示重置按钮:(默认是)
        /// </summary>
        public bool? IsShowResetButton { get; set; }

        /// <summary>
        /// 是否显示导出按钮:(默认否)
        /// </summary>
        public bool? IsShowExportButton { get; set; }

        /// <summary>
        /// 是否显示离线导出按钮:(默认否)
        /// </summary>
        public bool? IsShowOfflineExportButton { get; set; }

        /// <summary>
        /// 是否显示导入按钮:(默认否)
        /// </summary>
        public bool? IsShowImportButton { get; set; }

        /// <summary>
        /// 是否显示顺序列:(默认否)
        /// </summary>
        public bool? IsShowSequenceColumn { get; set; }

        /// <summary>
        /// 导入接口
        /// </summary>
        public string ImportApi { get; set; }

        /// <summary>
        /// 操作控件位置：NULL/1：换行，2：同行
        /// </summary>
        public int? OperateControlsPosition { get; set; }

        /// <summary>
        /// 选择行方式：1: 单选， 2: 多选
        /// </summary>
        public int? SelectRowMethod { get; set; }

        /// <summary>
        /// 列类型: 1: 控制器函数， 2: WebApi， 3:数据源编码， 4:SQL， 5:本地配置
        /// </summary>
        public ColumnTypeEnum? ColumnType { get; set; }

        /// <summary>
        /// 列值
        /// </summary>
        public string ColumnValue { get; set; }

        /// <summary>
        /// 是否显示列查询:(默认否)
        /// </summary>
        public bool? IsShowColumnSearch { get; set; }

        /// <summary>
        /// 操作列名
        /// </summary>
        public string OperateColumnName { get; set; }

        /// <summary>
        /// 操作列宽度
        /// </summary>
        public int? OperateColumnWidth { get; set; }

        /// <summary>
        /// 数据类型：1: 控制器函数， 2: WebApi， 3:数据库表或视图， 4:SQL
        /// </summary>
        public DataTypeEnum? DataType { get; set; }

        /// <summary>
        /// 数据值
        /// </summary>
        public string DataValue { get; set; }

        /// <summary>
        /// 数据库：1: 数据中心， 2: 交易流水
        /// </summary>
        public DBEnum? DataDB { get; set; }

        /// <summary>
        /// 数据默认排序SQL
        /// </summary>
        public string DataSortSql { get; set; }

        /// <summary>
        /// 是否自动查询:(默认是)
        /// </summary>
        public bool? IsAutoSearch { get; set; }

        /// <summary>
        /// 面包屑
        /// </summary>
        public IEnumerable<string> ListCrumb { get; set; }

        /// <summary>
        /// Scripts引用
        /// </summary>
        public IEnumerable<string> ListJavascriptSrc { get; set; }

        /// <summary>
        /// 过虑控件
        /// </summary>
        public IEnumerable<dynamic> ListFilterControl { get; set; }

        /// <summary>
        /// 操作控件
        /// </summary>
        public IEnumerable<dynamic> ListOperateControl { get; set; }

        /// <summary>
        /// 字段
        /// </summary>
        public IEnumerable<dynamic> ListColumn { get; set; }

        /// <summary>
        /// 操作列值
        /// </summary>
        public IEnumerable<dynamic> ListOperateColumnControl { get; set; }

    }
}
