﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Common
{
    /// <summary>
    /// Api返回参数
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class CommonApiResponseDto<T> : BaseCommonApiResponseDto
    {
        /// <summary>
        /// 返回的业务数据
        /// </summary>
        public T Data { get; set; }

    }
    public class CommonApiResponseDto : BaseCommonApiResponseDto
    {
        /// <summary>
        /// 返回的业务数据
        /// </summary>
        public object Data { get; set; }
    }
    public class BaseCommonApiResponseDto
    {
        /// <summary>
        /// 指示是否成功
        /// </summary>
        public bool IsSuccess { get; set; } = true;
        /// <summary>
        /// 消息
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// HTTP状态码
        /// </summary>
        public int Code => IsSuccess ? 200 : 0;
    }
}
