﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Microsoft.Extensions.Hosting;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.DailyBorrowFee
{
    public class Services : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;

                if (now.Hour == 23 && now.Minute == 58)  //凌晨23：58分启动
                {
                    Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    var start = DateTime.Parse(now.ToShortDateString());

                    Init(start);
                    
                    Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }


        public void Init(DateTime day)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                cn.Execute("delete from dc_daily_fee where recoed_time='" + day.ToString("yyyy-MM-dd") + "'");

                var sql = $@"insert dc_daily_fee(cost_plan_no, cost_no, cost_reason, cost_form, company_no, company_name, type_no,
                          type_name, kind_no, kind_name, create_userid, create_usercode, create_username,
                          cost_remark, create_time, cost_status, file_path, mor_file_path, amount, bank_name,
                          bank_card, bank_card_user, bank_company, mor_remark, son_cost_no, sup_cost_no,
                          is_lend, had_pay, lend_status, compensate, counteract, lend_balance, reject_reason,
                          dic, pay_counteract, pay_lend_balance, pay_plan_amount, pay_dic, pay_cur, is_tax,
                          detail_key, pay_user_id, pay_time, amount_rmb, to_rmb_rate, sub_logistics_supplier_id,
                          logistics_supplier_id, subject_code, company_value, audit_time, last_modify_date,
                          bj_create, bj_modified, recoed_time)
                          select cost_plan_no, cost_no, cost_reason, cost_form, company_no, company_name, type_no,
                          type_name, kind_no, kind_name, create_userid, create_usercode, create_username,
                          cost_remark, create_time, cost_status, file_path, mor_file_path, amount, bank_name,
                          bank_card, bank_card_user, bank_company, mor_remark, son_cost_no, sup_cost_no,
                          is_lend, had_pay, lend_status, compensate, counteract, lend_balance, reject_reason,
                          dic, pay_counteract, pay_lend_balance, pay_plan_amount, pay_dic, pay_cur, is_tax,
                          detail_key, pay_user_id, pay_time, amount_rmb, to_rmb_rate, sub_logistics_supplier_id,
                          logistics_supplier_id, subject_code, company_value, audit_time, last_modify_date,
                          bj_create, bj_modified, '{day.ToString("yyyy-MM-dd")}' from dc_base_finance_fee where is_lend = 1 and cost_form = 3 and lend_status in (1, 2)";

                cn.Execute(sql);

                var count = cn.QueryFirstOrDefault<int?>("select count(id) from dc_daily_fee where recoed_time='"+day.ToString("yyyy-MM-dd")+"'");
                Console.WriteLine("借支单待还的订单数量："+(count??0));
                
            }
            
        }

    }
}
