﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Hosting;

namespace Bailun.DC.DailySelfProducePurchaseDeliver
{
    public class Services : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;

                if (now.Hour == 23 && now.Minute == 45)  //23:45分启动
                {
                    Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    Init(now);
                    Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }


        /// <summary>
        /// 保存昨天的自产采购发货在途明细
        /// </summary>
        public void Init(DateTime day)
        {
            try
            {
                var sql = $@"insert into dc_daily_purchase_semi_deliveronway (purchase_id,bailun_sku,count,price,createtime,day) 
	                    select t1.purchase_id,t1.bailun_sku,t1.count-t2.count as count,t5.price,NOW() as createtime,'{day.ToString("yyyy-MM-dd")}' as day from (select t1.purchase_id,t1.bailun_sku,sum(t1.count) as count from dc_base_purchase_delivery t1 join dc_base_purchase t5 on t1.purchase_id=t5.purchase_id and t1.bailun_sku=t5.bailun_sku and t5.buy_status=3 group by t1.purchase_id,t1.bailun_sku) t1
	                    join dc_base_purchase t5 on t1.purchase_id=t5.purchase_id and t1.bailun_sku=t5.bailun_sku and t5.buy_status=3
	                    join dc_base_sku t3 on t1.bailun_sku=t3.bailun_sku and t3.buyer_name in ('张莹霞','张莹霞1')
	                    left join (select t2.purchase_id,t2.bailun_sku,sum(t2.count) as count from dc_base_purchase_inbound t2 join dc_base_purchase t5 on t2.purchase_id=t5.purchase_id and t2.bailun_sku=t5.bailun_sku and t5.buy_status=3 where t2.status=1 group by t2.purchase_id,t2.bailun_sku) t2 on t1.purchase_id=t2.purchase_id and t1.bailun_sku=t2.bailun_sku and t1.count>t2.count
	                    where t1.count>t2.count";

                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    //删除昨天的数据
                    cn.Execute("delete from dc_daily_purchase_semi_deliveronway where day='" + day.ToString("yyyy-MM-dd") + "'");

                    //保存最新数据
                    var result = cn.Execute(sql);

                    Console.WriteLine(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + " 受影响行数" + result);

                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("出现异常，异常信息："+ex.Message);
                Init(day);
            }
            
            
        }

    }
}
