﻿using Bailun.DC.Models;
using Bailun.DC.Models.Common;
using Bailun.DC.Models.Common.Page;
using Bailun.DC.Models.Dtos.Finance;
using Bailun.DC.Services;
using Bailun.DC.Services.WebApiService;
using Bailun.DC.WebApi.Attribute;
using Bailun.ServiceFabric.Authorize;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Bailun.DC.WebApi.Controllers
{
    /// <summary>
    /// 财务报表
    /// </summary>
    [Route("api/Finance")]
    [ApiController]
    public class FinanceController : BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public FinanceController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        /// <summary>
        /// 测试
        /// </summary>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        [BrowseLog("Bailun_data", "访问【百伦数据中心】->【财务报表】->【资产负债表】->【查询】页面", 0)]
        public CommonApiResponseDto<List<dc_base_finance_fee>> Test()
        {
            var list = new Services.FinanceReportServices().ListFinanceFee(DateTime.Now.AddDays(-5), DateTime.Now, "", "", "", null, null);

            return new CommonApiResponseDto<List<dc_base_finance_fee>> { Data = list, IsSuccess = true };
        }
        /// <summary>
        /// 获取付现流水报表
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [HttpPost("getCashFlowStatement")]
        public CommonApiResponseDto<FinanceDto> GetCashFlowStatement(GetCashFlowStatementInput input)
            => new FinanceService().GetCashFlowStatement(input);


        #region 付现流水明细
        /// <summary>
        /// 分页查询付现流水明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [HttpPost("getFinanceFeeDetailsPage"), BailunAuthentication(LoginMode.Enforce)]
        public CommonApiResponseDto<FinanceFeeDetailsPageOutputDto> GetFinanceFeeDetailsPage([FromBody] FinanceFeeDetailsPageInputDto input)
        {
            return new FinanceService().GetFinanceFeeDetailsPage(input);
        }

        /// <summary>
        /// 导出明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [HttpPost("exportFinanceFeeDetails"), BailunAuthentication(LoginMode.Enforce)]
        public ActionResult ExportFinanceFeeDetails([FromBody] FinanceFeeDetailsPageInputDto input)
        {
            input.IsPages = false;
            var dataList = new FinanceService().GetFinanceFeeDetailsPage(input).Data.Items;
            var colNames = new List<string> {"费用单号","公司名称","费用类型", "费用总金额", "人民币总金额","付款理由","大类标题","小类标题","收款/付款人",
                                            "收款单位","会计科目","财务审核时间" ,"付款时间","最后更新时间","部门名称","创建人名称","创建时间"};
            var list = new List<string>();
            foreach (var item in dataList)
            {
                list.Add(item.cost_no + "|" + item.company_name + "|" + item.type_name + "|" + item.amount +"|"+item.amount_rmb + "|" + item.cost_reason + "|" +
                    item.type_name + "|" + item.kind_name + "|" + item.bank_card_user+"|"+ item.bank_company + "|"+item.accounting_subject_name+"|"+
                    item.audit_time + "|"+(item.pay_time.HasValue?item.pay_time.Value.ToString("yyyy-MM-dd HH:mm:ss"):string.Empty) +"|"+
                    (item.last_modify_date.HasValue? item.last_modify_date.Value.ToString("yyyy-MM-dd HH:mm:ss") : string.Empty) + "|"+
                    item.department_name + "|"+item.create_username + "|"+ (item.create_time.HasValue ? item.create_time.Value.ToString("yyyy-MM-dd HH:mm:ss") : string.Empty));
            }
            var guid = Guid.NewGuid().ToString();
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);
            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }
            ms.Position = 0;
            return File(ms, "text/csv", "付现流水明细.csv");

        }
        #endregion

        /// <summary>
        /// 获取付现流水报表明细
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [HttpPost("getFinanceDetails")]
        public CommonApiResponseDto<List<FinanceDetailsDto>> GetFinanceDetails(GetCashFlowStatementInput input)
            => new FinanceService().GetFinanceDetails(input);
        /// <summary>
        /// 获取管理成本
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [HttpPost("getManagementCost")]
        public CommonApiResponseDto<FinanceDto> GetManagementCost(GetCashFlowStatementInput input)
            => new FinanceService().GetManagementCost(input);
    }
}
