﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.DC.Web.Areas.ExportFile.Controllers
{
    [Area("ExportFile")]
    public class PurchaseController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public PurchaseController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        /// <summary>
        /// 导出采购下单明细
        /// </summary>
        /// <param name="companyid">公司id</param>
        /// <param name="start">下单开始时间</param>
        /// <param name="end">下单结束时间</param>
        /// <returns></returns>
        public ActionResult ExportPurchase(int companyid, DateTime start, DateTime end,string skucategoryids)
        {
            var _service = new Services.ExportServices();

            var obj = _service.ListPurchase(start, end, companyid,skucategoryids);

            var colNames = new List<string> {"采购入库单号","Sku","仓库编码", "仓库名称", "下单数量",
                                             "下单金额","采购价","下单时间" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.purchase_id + "|" + item.bailun_sku + "|" + item.warehouse_code + "|" + item.warehouse_name + "|" + item.count + "|" +
                    item.amount + "|" + item.price + "|" + item.create_time);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = "采购下单明细" + start.ToString("yyyy-MM-dd") + "至" + end.ToString("yyyy-MM-dd");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");

        }

        /// <summary>
        /// 导出半成品采购单明细
        /// </summary>
        /// <param name="companyid">公司id</param>
        /// <param name="start">下单开始时间</param>
        /// <param name="end">下单结束时间</param>
        /// <returns></returns>
        public ActionResult ExportSemiPurchase(int companyid, DateTime start, DateTime end)
        {
            var _service = new Services.ExportServices();

            var obj = _service.ListSemiPurchase(start, end, companyid);
            var colNames = new List<string> {"采购入库单号","Sku","仓库编码", "仓库名称", "下单数量",
                                             "下单金额","采购价","下单时间" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.purchase_id + "|" + item.bailun_sku + "|" + item.warehouse_code + "|" + item.warehouse_name + "|" + item.count + "|" +
                    item.amount + "|" + item.price + "|" + item.create_time);
            }

            var guid = Guid.NewGuid().ToString();

            var filename = "半成品采购下单明细" + start.ToString("yyyy-MM-dd") + "至" + end.ToString("yyyy-MM-dd");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");

        }
    }
}