﻿using Bailun.DC.Common;
using Bailun.DC.Models.Common;
using Bailun.DC.Models.Dtos.BasicData;
using Dapper;
using System.Collections.Generic;
using System.Linq;

namespace Bailun.DC.Services.WebApiService
{
    /// <summary>
    /// 基础数据
    /// </summary>
    public class BasicDataService
    {
        /// <summary>
        /// 获取付现所有公司信息
        /// </summary>
        /// <returns></returns>
        public CommonApiResponseDto<List<CompanyListOutPutDto>> GetCompanyAllList()
        {
            var result = new CommonApiResponseDto<List<CompanyListOutPutDto>> { Data = new List<CompanyListOutPutDto>() };
            string sql = "SELECT * FROM dc_base_finance_company WHERE 1=1;";
            result.Data = SimpleCRUD.Query<CompanyListOutPutDto>(sql, null, GlobalConfig.ConnectionString).ToList();
            return result;
        }

        /// <summary>
        /// 获取费用类型
        /// </summary>
        /// <returns></returns>
        public CommonApiResponseDto<List<CostTypeListOutPutDto>> GetCostTypeAllList()
        {
            var result = new CommonApiResponseDto<List<CostTypeListOutPutDto>> { Data = new List<CostTypeListOutPutDto>() };
            string sql = "SELECT type_name AS CostTypeName FROM dc_base_finance_fee GROUP BY type_name;";
            result.Data = SimpleCRUD.Query<CostTypeListOutPutDto>(sql, null, GlobalConfig.ConnectionString).ToList();
            return result;
        }
    }
}
