﻿using System;
using System.Collections.Generic;
using System.Text;
using Newtonsoft.Json;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Microsoft.Extensions.Hosting;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.DailyItemNoAdGMV
{
    public class Services : BackgroundService
    {
        private string url = "http://10.0.6.39:6030/EbayPublish/GetEbayAdSale";//"http://pps.bailuntec.com/listingapi/EbayPublish/GetEbayAdSale";

        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;

                if ((now.Hour == 17 && now.Minute == 05))  //16:05启动
                {
                    Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    var day = DateTime.Parse(now.AddDays(-1).ToShortDateString());
                    Init(day);
                    Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
        
        public void Init(DateTime day)
        {
            var result = Bailun.DC.Common.HttpHelper.NetHelper.HttpPostJson(url, JsonConvert.SerializeObject(new { 
                startDate = day.ToString("yyyy-MM-dd"),
                endDate = day.ToString("yyyy-MM-dd")
            }));

            var json = JsonConvert.DeserializeObject<Models.mResponse>(result);

            if(json.StatusCode==200 && json.result.isSucceeded)
            {
                Save(json.result.objData,day);
            }
            else
            {
                Console.WriteLine(json.Message);
                System.Threading.Thread.Sleep(1000 * 30); //30秒重启一次
                Console.WriteLine(day.ToString("yyyy-MM-dd") + " 重跑服务" + DateTime.Now);
                Init(day);  //重跑服务
                
            }
        }

        private void Save(List<Models.mResponseData> list,DateTime day)
        {
            try
            {
                var listRate = GetExchangeRate(day);
                var total = list.Count;
                var index = 1;
                var pagesize = 1000;
                var str = "";
                var sql = "insert dc_daily_itemno_ad_gmv (day,item_id,website,sales_amount,sales_count,ad_fees,sales_currency,sales_rate,ad_currency,ad_rate,sale_date,sale_date_bj) values ";

                Console.WriteLine(day.ToString("yyyy-MM-dd") + " 总记录：" + total);
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    cn.Execute("delete from dc_daily_itemno_ad_gmv where day='" + day.ToString("yyyy-MM-dd") + "'");
                }

                foreach (var item in list)
                {
                    if (item.site.ToLower() == "gb")  //英国站点特殊处理，转换为我们的系统的短码
                    {
                        item.site = "UK";
                    }

                    var timeInterval = GetTimeToUTCInterval(item.site);

                    var listData = item.saleDatas.Where(a => a.saleAmount > 0 && a.adFees > 0).ToList();  //过滤数据为空的数据

                    foreach (var c in listData)
                    {
                        var objSaleRate = listRate.Where(a => a.init_curreny.ToLower() == c.saleCurrency.ToLower() && a.final_curreny.ToLower() == "cny").FirstOrDefault();
                        var objAdRate = objSaleRate;

                        if (c.saleCurrency.ToLower() != c.adFeeCurrency.ToLower())
                        {
                            objAdRate = listRate.Where(a => a.init_curreny.ToLower() == c.adFeeCurrency.ToLower() && a.final_curreny.ToLower() == "cny").FirstOrDefault();
                        }

                        //销售时间转北京时间
                        //var timeZoneInfo = TimeZoneInfo.FindSystemTimeZoneById("");
                        var bjdate = c.saleDate.AddHours(8-timeInterval);  //先转UTC时间再转北京时间

                        str += $"('{day.ToString("yyyy-MM-dd")}','{item.itemNo}','{item.site}',{c.saleAmount},{c.sales},{c.adFees},'{c.saleCurrency}',{(objSaleRate != null ? objSaleRate.exchange_rate : 1)},'{c.adFeeCurrency}',{(objAdRate != null ? objAdRate.exchange_rate : 1)},'{c.saleDate.ToString("yyyy-MM-dd HH:mm:ss")}','{bjdate.ToString("yyyy-MM-dd HH:mm:ss")}'),";

                    }

                    //执行插入
                    if ((index == total || index % pagesize == 0) && !string.IsNullOrEmpty(str))
                    {
                        using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
                        {
                            if (cn.State == System.Data.ConnectionState.Closed)
                            {
                                cn.Open();
                            }

                            cn.Execute(sql + str.Substring(0, str.Length - 1));

                            Console.WriteLine("保存一次数据，索引：" + index + " ；" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                        }

                        str = "";
                    }

                    index++;

                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("保存数据异常：" + ex.Message);
            }
        }

        /// <summary>
        /// 获取当天汇率
        /// </summary>
        /// <param name="day"></param>
        /// <returns></returns>
        private List<Models.dc_exchange_rate> GetExchangeRate(DateTime day)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<Models.dc_exchange_rate>("select * from dc_exchange_rate where record_time='" + day.ToString("yyyy-MM-dd")+"'").AsList();
            }

        }

        /// <summary>
        /// 站点转UTC的时间差
        /// </summary>
        /// <param name="website"></param>
        /// <returns></returns>
        private int GetTimeToUTCInterval(string website)
        {
            switch(website)
            {
                case "UK":  //英国
                    return 1;

                case "CA":  //加拿大和美国取太平洋时间
                case "US": 
                    return -7;
                case "AU":  //澳大利亚
                    return 10;
                case "DE":  //德国
                case "ES":  //西班牙
                case "FR":  //法国
                case "NL":  //荷兰
                case "SE":  //瑞典
                case "IT":  //意大利
                    return 2;
                case "JP":  //日本
                    return 9;
                case "ID":  //印度尼西亚
                case "MY":  //马来西亚
                case "PH":  //菲律宾
                case "SG":  //新加坡
                case "CN":  //中国
                    return 8;
                case "TH":  //泰国
                    return 7;
                
                default:
                    return 0;
            }

        }

    }
}
