﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Bailun.DC.Models;


namespace Bailun.DC.DailyPurchaseSellStock
{
    public class Services
    {
        public void Init(DateTime day)
        {
            var sql = $@"select t1.bailun_sku,t1.warehouse_code,t2.warehouse_name,sum(t1.usable_stock+t1.occupy_stock) count,sum((t1.usable_stock+t1.occupy_stock)*t1.unit_price) as amount from dc_daily_stock t1 
                        left join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code
                        where t1.record_time='{day.AddDays(-1).ToString("yyyy-MM-dd")}' group by t1.bailun_sku,t1.warehouse_code";

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                //昨日库存
                var objPreStock = cn.Query<mStock>(sql, null, null, true, 2 * 60);

                //在库库存
                sql = $@"select t1.bailun_sku,t1.warehouse_code,t2.warehouse_name,sum(t1.usable_stock+t1.occupy_stock) count,sum((t1.usable_stock+t1.occupy_stock)*t3.unit_price) as amount from dc_base_stock t1 
                        left join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code
                        left join dc_base_sku t3 on t1.bailun_sku=t3.bailun_sku
                        where t1.usable_stock>0 or t1.occupy_stock>0 group by t1.bailun_sku,t1.warehouse_code";
                var objStock = cn.Query<mStock>(sql, null, null, true, 2 * 60);

                //昨日在途库存
                sql = $@"select t1.bailun_sku,t1.warehouse_code,t2.warehouse_name,sum(t1.quantity_purchase+t1.quantity_transfer) count,sum((t1.quantity_purchase+t1.quantity_transfer)*t1.unit_price) as amount from dc_daily_transit t1 
                        left join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code
                        where t1.record_time='{day.AddDays(-1).ToString("yyyy-MM-dd")}' and (t1.quantity_purchase>0 or t1.quantity_transfer>0) group by t1.bailun_sku,t1.warehouse_code";
                var objPreOnWay = cn.Query<mStock>(sql, null, null, true, 2 * 60);

                //在途库存
                sql = $@"select t1.bailun_sku,t1.warehouse_code,t2.warehouse_name,sum(t1.quantity_purchase+t1.quantity_transfer) count,sum((t1.quantity_purchase+t1.quantity_transfer)*t3.unit_price) as amount from dc_mid_transit t1 
                        left join dc_base_warehouse t2 on t1.warehouse_code=t2.warehouse_code
                        left join dc_base_sku t3 on t1.bailun_sku=t3.bailun_sku
                        where (t1.quantity_purchase>0 or t1.quantity_transfer>0)
                        group by t1.bailun_sku,t1.warehouse_code
                        ";
                var objOnWay = cn.Query<mStock>(sql, null, null, true, 2 * 60);

                var temparr = new List<Tuple<string, string,string>>();
                temparr.AddRange(objPreStock.Select(p => new Tuple<string, string,string>(p.bailun_sku.ToUpper(), p.warehouse_code.ToUpper(), p.warehouse_name)));
                temparr.AddRange(objStock.Select(p => new Tuple<string, string,string>(p.bailun_sku.ToUpper(), p.warehouse_code.ToUpper(), p.warehouse_name)));
                temparr.AddRange(objPreOnWay.Select(p => new Tuple<string, string,string>(p.bailun_sku.ToUpper(), p.warehouse_code.ToUpper(), p.warehouse_name)));
                temparr.AddRange(objOnWay.Select(p => new Tuple<string, string,string>(p.bailun_sku.ToUpper(), p.warehouse_code.ToUpper(), p.warehouse_name)));

                temparr = temparr.Distinct().ToList();

                var list = new List<dc_daily_purchase_sell_stock>();
                foreach (var item in temparr)
                {
                    var m = new dc_daily_purchase_sell_stock() {
                        bailun_sku = item.Item1,
                        warehouse_code = item.Item2,
                        warehouse_name = item.Item3,
                        createtime = DateTime.Now,
                        record_time = day,

                        end_onway_amount = 0,
                        end_onway_count = 0,
                        end_stock_amount = 0,
                        end_stock_count = 0,
                        start_onway_amount = 0,
                        start_onway_count = 0,
                        start_stock_amount=0,
                        start_stock_count = 0,
                    };

                    var p = objPreStock.Where(a => a.bailun_sku.ToUpper() == item.Item1 && a.warehouse_code.ToUpper() == item.Item2).FirstOrDefault();
                    if (p != null)
                    {
                        m.start_stock_count = p.count;
                        m.start_stock_amount = p.amount;
                    }

                    p = objStock.Where(a => a.bailun_sku.ToUpper() == item.Item1 && a.warehouse_code.ToUpper() == item.Item2).FirstOrDefault();
                    if (p != null)
                    {
                        m.end_stock_count = p.count;
                        m.end_stock_amount = p.amount;
                    }

                    p = objPreOnWay.Where(a => a.bailun_sku.ToUpper() == item.Item1 && a.warehouse_code.ToUpper() == item.Item2).FirstOrDefault();
                    if (p != null)
                    {
                        m.start_onway_count = p.count;
                        m.start_onway_amount = p.amount;
                    }

                    p = objOnWay.Where(a => a.bailun_sku.ToUpper() == item.Item1 && a.warehouse_code.ToUpper() == item.Item2).FirstOrDefault();
                    if (p != null)
                    {
                        m.end_onway_count = p.count;
                        m.end_onway_amount = p.amount;
                    }

                    list.Add(m);
                }

                cn.Execute($"delete from dc_daily_purchase_sell_stock where record_time='{day.ToString("yyyy-MM-dd")}'");
                sql = "insert dc_daily_purchase_sell_stock (bailun_sku,warehouse_code,warehouse_name,createtime,record_time,end_onway_amount,end_onway_count,end_stock_amount,end_stock_count,start_onway_amount,start_onway_count,start_stock_amount,start_stock_count) values ";
                var resultcount = 0;

                while (resultcount < list.Count)
                {
                    var s = "";

                    var temp = list.Skip(resultcount).Take(5000);

                    foreach (var item in temp)
                    {
                        s += $"('{item.bailun_sku}','{item.warehouse_code}','{item.warehouse_name}','{item.createtime.ToString("yyyy-MM-dd HH:mm:ss")}','{item.record_time.ToString("yyyy-MM-dd")}',{item.end_onway_amount},{item.end_onway_count},{item.end_stock_amount},{item.end_stock_count},{item.start_onway_amount},{item.start_onway_count},{item.start_stock_amount},{item.start_stock_count}),";
                    }
                    resultcount += 5000;

                    if (s.Length>0)
                    {
                        cn.Execute(sql + s.Substring(0, s.Length - 1), null, null, 2 * 60);
                    }

                }

            }

        }

    }

    class mStock
    {
        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 金额
        /// </summary>
        public decimal amount { get; set; }
    }
}
