﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Bailun.ServiceFabric.Extension;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.DC.Web.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            //var users = new List<int> { 681,690,691,693,720,731,2346};
            //var codes = new List<Tuple<string, string>>() {
            //    new Tuple<string, string>("ExportLogicWarehouse","逻辑仓库"),
            //    new Tuple<string, string>("ExportInventoryAging","库龄"),
            //    new Tuple<string, string>("ExportListOrderDetail","订单明细导出"),
            //    new Tuple<string, string>("ExportPlatformCost","平台费导出"),
            //    new Tuple<string, string>("ExportListReturn","退款流水导出"),
            //    new Tuple<string, string>("ExportAmazonAD","亚马逊广告费"),
            //    new Tuple<string, string>("ExportEbayInnerCodeProfit","Ebay内部商品编码利润"),
            //    new Tuple<string, string>("ExportEbayAdFee","Ebay广告费"),
            //    new Tuple<string, string>("ExportIndex","资产负债表"),
            //    new Tuple<string, string>("ExportListInterestExpense","管理成本"),
            //    new Tuple<string, string>("ExportAdministrativeCost","管理成本明细"),
            //    new Tuple<string, string>("ExportUnReasonable","进销存差异明细"),
            //    new Tuple<string, string>("ExportSkuDiffWeigh","Sku发货差异")
            //};


            //var list = new List<Bailun.DC.Models.dc_base_user_authoritys>();
            //foreach (var u in users)
            //{
            //    foreach (var code in codes)
            //    {
            //        var m = new Bailun.DC.Models.dc_base_user_authoritys {
            //            code = code.Item1,
            //            notes = code.Item2,
            //            createtime = DateTime.Now,
            //            has_export = 1,
            //            userid = u
            //        };

            //        list.Add(m);
            //    }
            //}

            //new Services.UserAuthorityServices().Add(list);

            
            return View();
        }

        [HttpPost]
        public JsonResult SetCookie(string token)
        {
            if (!string.IsNullOrEmpty(token))
            {
                HttpContext.Response.Cookies.Append("BailunToken", token, new Microsoft.AspNetCore.Http.CookieOptions() { Expires = DateTime.Now.AddDays(1) });

                return Json(new {
                    success = true,
                    msg = "",
                });
            }
            

            return Json(new {
                success = false,
                msg = "请重新登录"
            });
        }

        public ActionResult Main()
        {


#if DEBUG
            var cookie = "Bearer eyJhbGciOiJSUzI1NiIsImtpZCI6IjdhZDA5MjQ5ZDk0ZDgxN2VhNmI5ZThhMTc1MzlmNmY3IiwidHlwIjoiSldUIn0.eyJuYmYiOjE2MDAwNTAwNDcsImV4cCI6MTYwMDA4NjA0NywiaXNzIjoiaHR0cDovL2xvY2FsaG9zdDo1MDAxIiwiYXVkIjpbImh0dHA6Ly9sb2NhbGhvc3Q6NTAwMS9yZXNvdXJjZXMiLCJiYWlsdW5BcGkiXSwiY2xpZW50X2lkIjoiYmFpbHVuQ2xpZW50Iiwic3ViIjoi5YWz5oyv5bGxIiwiYXV0aF90aW1lIjoxNjAwMDUwMDQ3LCJpZHAiOiJsb2NhbCIsIlVzZXJJZCI6IjIzNDYiLCJzdWNlc3NzIjoidHJ1ZSIsIkNvbXBhbnkiOiJ7XCJJZFwiOjEsXCJDb21wYW55Q29kZVwiOlwiYmFpbHVuXCIsXCJDb21wYW55TmFtZVwiOlwi5bm_5bee55m-5Lym5L6b5bqU6ZO-5pyJ6ZmQ5YWs5Y-4XCJ9IiwiQWxsQ29tcGFueSI6IkZhbHNlIiwiVXNlckNvZGVOZXciOiJCTDExNjkiLCJVc2VyQ29kZSI6IkJMMTE3MCIsIk9hVXNlcklkIjoiMjM0NiIsIkRlcGFydG1lbnQiOiJ7XCJEZXBhcnRtZW50SWRcIjoyNTgsXCJOYW1lXCI6XCLmlbDmja7kuK3lv4NcIixcIkNvZGVcIjpcIlwifSIsInNjb3BlIjpbIm9wZW5pZCIsInByb2ZpbGUiLCJiYWlsdW5BcGkiXSwiYW1yIjpbImN1c3RvbSJdfQ.M2S1aNkyns2yQPt-itQZhNYhhJI4vSfMtfmV9kH-0ufOW9xGnNvf0j949p_zi3JkCejVAKoR1yO7luHkiolfvwtwAlX0yzWeiX41myHo3f8eAH42lnmfUB7CuKkDFVn9wc0sgRbHPIYO3E1Xhd3colgblF6T-9XC9Xvau46-pZw8uvoeIo-FC79aBX8LoDgsamxN2tDKTuE0fjuFosXtPHQgm2oZUdsTpyHyLYAlGO6a6DUB3ZpjoUVu6SGi3NRxuX7jEzCoMkr4XM5soRDRgjIZq9TgGEehr4en3MRHRdQ03KaxR_sgpGip0dNvm0kWARlvh049Yn6tjCJ2jzVQTw";
#else
            //var user = Common.HttpHelper.NetHelper.Request("http://sso.bailuntec.com/GetUserResource");
            var cookie = HttpContext.Request.Cookies["BailunToken"];
#endif
            
            //var companyid = -1;
            //var departmentname = "";
            //var username = "";
            //var userid = 0;
            //var isAllCompany = 0;


            //var user = Common.HttpHelper.NetHelper.Request("http://sso.bailuntec.com/GetUserResource", new string[] { "Authorization" }, new string[] { (cookie != null ? System.Net.WebUtility.UrlDecode(cookie) : "") });

            //var json = Newtonsoft.Json.Linq.JObject.Parse(user);
            //if (json["statusCode"].ToStr() == "200" && json["result"]["success"].ToString().ToLower() == "true")
            //{
            //    username = json["result"]["Account"].ToString();
            //    //userid = json["result"]["UserId"].ToInt32();
            //    userid = json["result"]["OaUserId"].ToInt32();
            //    isAllCompany = json["result"]["AllCompany"].ToStr().ToLower() == "false" ? 0 : 1;
            //    int.TryParse(json["result"]["Company"]["Id"].ToString(), out companyid);
            //    if (json["result"]["Department"].ToString() != "null" && json["result"]["Department"].ToString() != "")
            //    {
            //        departmentname = json["result"]["Department"]["Name"].ToStr();
            //    }
            //}
            //else
            //{
            //    //HttpContext.Response.Cookies["token"].Expires.AddDays(-1);
            //}

            //ViewBag.companyid = companyid;
            //ViewBag.allcompany = isAllCompany;
            //ViewBag.username = username;
            //ViewBag.departmentname = departmentname;

            //HttpContext.Response.Cookies.Append("companyid", companyid + "", new Microsoft.AspNetCore.Http.CookieOptions
            //{
            //    Expires = DateTime.Now.AddDays(1)
            //});


            ////var listMenu = new Services.MenuServices().ListMenu(username);
            //var listMenu = new Services.MenuServices().ListMenu(userid);
            //ViewBag.menus = listMenu;

            return View();
        }

        /// <summary>
        /// 获取用户菜单
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListMenu(int userid)
        {
            var listMenu = new Services.MenuServices().ListMenu(userid);

            return Json(listMenu);
        }
        
        /// <summary>
        /// 无权访问提示页面
        /// </summary>
        /// <returns></returns>
        public ActionResult NoPermission()
        {
            return View();
        }

        [HttpPost]
        public JsonResult ListWarehouseType()
        {
            var result = new Services.WareHouseServices().ListWareHouseType().Where(a=>!string.IsNullOrEmpty(a));
            return Json(result);
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <param name="warehousetype"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWareHouse(string warehousetype,int? areaid)
        {
            var result = new Services.WareHouseServices().List(warehousetype,areaid);

            var list = result.Select(p => new {
                p.warehouse_code,
                p.warehouse_name
            });

            return Json(list);
        }

        /// <summary>
        /// 获取sku分类列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListSkuCategory()
        {
            var result = new Services.SkuInfoServices().ListSkuCategory();
            return Json(result);
        }

        /// <summary>
        /// 根据仓库自设置属性获取仓库列表
        /// </summary>
        /// <param name="type">自发货仓或第三方仓</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWarehouseByExtType(string type)
        {
            var result = new Services.WareHouseServices().ListWarehouseByExtType(type);

            var list = result.Select(p => new {
                code = p.warehouse_code,
                name =  p.warehouse_name
            });

            return Json(list);
        }

        /// <summary>
        /// 获取仓库所在国家列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWarehouseArea()
        {
            var result = new Services.WareHouseServices().ListWarehouseArea().Where(a=>a.id>0);

            return Json(result);
        }

        /// <summary>
        /// 数据仓分组列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListGroupName()
        {
            var result = new Services.WareHouseServices().ListGroupName().Where(a=>!string.IsNullOrEmpty(a));
            return Json(result);
        }

        [HttpPost]
        public JsonResult ListWarehouseFromStockAndSales(string warehousetype)
        {
            var result = new Services.WareHouseServices().ListWarehouseFromStockAndSales(warehousetype);
            return Json(result);
        }

        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult GetUserInfo()
        {
            var userid = HttpContextHelper.Current?.User?.GetUid().ToStr();
            var username = HttpContextHelper.Current.User.GetUserName();
            var jobs = ""; //HttpContextHelper.Current.User.GetRolesCode();
            var companyid = HttpContextHelper.Current.User.GetCompanyId();

            return Json(new
            {
                success = true,
                userid = userid,
                username = username,
                jobs = jobs,
                companyid = companyid
            });

        }

        /// <summary>
        /// 获取简单百伦一二级分类
        /// </summary>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult ListSimpleCategory()
        {
            var companyid = HttpContextHelper.Current.User.GetCompanyId().ToInt32();

            if (companyid != 1)
            {
                return Json("{}");
            }

            var obj = new Services.SkuInfoServices().ListSimpleCategory12(companyid);
            return Json(obj);
        }

        public ActionResult NoData()
        {
            return View();
        }

        public ActionResult DemoFile()
        {
            return View();
        }

        public ActionResult UploadDemoFile()
        {
            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            //var user = HttpContextHelper.Current?.User;

            var file = Request.Form.Files[0];
            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true,ref errmsg);

            var platform = "";
            var website = "";
            var filename = file.FileName.Split(' ')[0].Split('-');
            if (filename.Length > 1)
            {
                platform = filename[0];
                website = filename[1];
            }

            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();

                var _service = new Services.DataWareHouse.PlatformOrderFeeServices();
                var list = new List<Bailun.DC.Models.DataWareHouse.order_fee_config>();
                
                var columns = tb.Value.Columns;

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    var cols = new List<string>();
                    cols.Add(columns[2].ColumnName.Split('-')[1]);
                    cols.Add(columns[3].ColumnName.Split('-')[1]);
                    cols.Add(columns[4].ColumnName.Split('-')[1]);

                    //解析行
                    var row = tb.Value.Rows[i];

                    if (row == null || string.IsNullOrEmpty(row[0].ToString()))
                    {
                        continue;
                    }

                    var type = row[2].ToString();
                    var description = row[3].ToString();
                    var fulfillment = row[4].ToString();

                    var _platform = "";
                    var _website = "";
                    if (string.IsNullOrEmpty(platform))
                    {
                        _platform = row["平台"].ToString().Trim();
                        _website = row["站点"].ToString().Trim();

                        type = "";
                        description = "";
                        fulfillment = "";

                        if (string.IsNullOrEmpty(_platform))
                        {
                            return Content("请填写平台信息。");
                        }

                    }


                    var valcol = row["取数列"].ToString();
                    var feetype = row["费用类型"].ToString();
                    var category = row["分录归集"].ToString();
                    var subjectcode = row["科目编码"].ToString();
                    var projectcode = row["项目编码"].ToString();
                    var datacentercol = row["数据中心字段"].ToString();
                    var note = row["备注"].ToString();
                    var currency = row["币种"].ToString();

                    //格式化组合条件
                    var _condition = "{";
                    if (!string.IsNullOrEmpty(type))
                    {
                        _condition += "\""+ columns[1].ColumnName.Split('-')[1]+"\":\""+type.Trim()+"\",";
                    }
                    if (!string.IsNullOrEmpty(description))
                    {
                        _condition += "\"" + columns[2].ColumnName.Split('-')[1] + "\":\"" + description.Trim() + "\",";
                    }
                    if (!string.IsNullOrEmpty(fulfillment))
                    {
                        _condition += "\"" + columns[3].ColumnName.Split('-')[1] + "\":\"" + fulfillment.Trim() + "\",";
                    }

                    if (_condition.Length > 1)
                    {
                        _condition = _condition.Substring(0, _condition.Length - 1);
                    }

                    _condition += "}";

                    //需要解析的字段
                    
                    cols.Add(valcol);

                    //保存需要解析的字段
                    var _col_result = _service.SaveOrderFeeCol(new List<Models.DataWareHouse.order_fee_col> { new Models.DataWareHouse.order_fee_col {
                        cols = string.Join("||",cols.Distinct().Where(b=>b!="/" && !string.IsNullOrEmpty(b)).ToList()),
                        platform = (platform==""?_platform:platform),
                        website = (website==""?_website:website),
                        datatype=1,
                    }});

                    if (!string.IsNullOrEmpty(_col_result))
                    {
                        return Content("保存字段解析配置异常，请确认字段格式是否正确。");
                    }

                    var m = new Models.DataWareHouse.order_fee_config { 
                        subjectcode = subjectcode,
                        colname_fee = valcol,
                        condition_forfee = _condition,
                        datacenter_col = datacentercol,
                        feetype = feetype,
                        financecategory = category,
                        note = note,
                        projectcode = projectcode,
                        platform = (platform==""?_platform:platform),
                        website = (website==""?_website:website),
                        currency = currency,
                        delstatus = 0,
                        datatype=1,
                    };

                    list.Add(m);
                }

                

                //保存需要解析的字段
                /*var result = _service.SaveOrderFeeCol(new List<Models.DataWareHouse.order_fee_col> { new Models.DataWareHouse.order_fee_col { 
                    cols = string.Join("||",cols.Distinct().ToList()),
                    platform = platform,
                    website = website,
                    datatype=1,
                }});

                if (!string.IsNullOrEmpty(result))
                {
                    return Content("保存字段解析配置异常，请确认字段格式是否正确。");
                }*/

                //保存取数逻辑条件
                var result = _service.SaveOrderFeeConfig(list);
                if (!string.IsNullOrEmpty(result))
                {
                    return Content("保存平台费用取数逻辑配置异常："+result);
                }

            }

            return Content("OK");
        }

        /// <summary>
        /// 保存物流商费用取数配置
        /// </summary>
        /// <returns></returns>
        public ActionResult UploadLogisticFeeConfig()
        {
            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            //var user = HttpContextHelper.Current?.User;

            var file = Request.Form.Files[0];
            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true,ref errmsg);

            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();

                var list = new List<Bailun.DC.Models.DataWareHouse.order_fee_config>();
                

                var columns = tb.Value.Columns;

                var _service = new Services.DataWareHouse.PlatformOrderFeeServices();

                //cols.Add(columns[3].ColumnName.Split('-')[1]);

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    //解析行
                    var row = tb.Value.Rows[i];

                    if (row == null || string.IsNullOrEmpty(row[0].ToString()))
                    {
                        continue;
                    }

                    var cols = new List<string>();
                    cols.Add(row["判断字段1"].ToString().Trim());
                    cols.Add(row["判断字段2"].ToString().Trim());


                    var type = row["具体字段1"].ToString();
                    var description = row["具体字段2"].ToString();
                    var fulfillment = "";

                    var valcol = row["取数列"].ToString();
                    var feetype = "";
                    var category = row["科目名称"].ToString();
                    var subjectcode = row["科目编码"].ToString();
                    var projectcode = "";
                    var datacentercol = row["数据中心字段归集"].ToString();
                    var note = "";
                    var currency = row["币别"].ToString();

                    var platform = row["物流商"].ToString();
                    var website = row["分表"].ToString(); 

                    //格式化组合条件
                    var _condition = "{";
                    if (!string.IsNullOrEmpty(type) && type!="/")
                    {
                        _condition += "\"" + row["判断字段1"].ToString() + "\":\"" + type.Trim() + "\",";
                    }
                    if (!string.IsNullOrEmpty(description) && description != "/")
                    {
                        _condition += "\"" + row["判断字段2"].ToString() + "\":\"" + description.Trim() + "\",";
                    }
                    if (!string.IsNullOrEmpty(fulfillment))
                    {
                        _condition += "\"" + columns[3].ColumnName.Split('-')[1] + "\":\"" + fulfillment.Trim() + "\",";
                    }

                    if (_condition.Length > 1)
                    {
                        _condition = _condition.Substring(0, _condition.Length - 1);
                    }

                    _condition += "}";

                    //需要解析的字段

                    cols.Add(valcol);

                    //保存需要解析的字段
                    var _col_result = _service.SaveOrderFeeCol(new List<Models.DataWareHouse.order_fee_col> { new Models.DataWareHouse.order_fee_col {
                        cols = string.Join("||",cols.Distinct().Where(b=>b!="/" && !string.IsNullOrEmpty(b)).ToList()),
                        platform = platform,
                        website = website,
                        datatype=2,
                    }});

                    if (!string.IsNullOrEmpty(_col_result))
                    {
                        return Content("保存字段解析配置异常，请确认字段格式是否正确。");
                    }

                    var m = new Models.DataWareHouse.order_fee_config
                    {
                        subjectcode = subjectcode,
                        colname_fee = valcol,
                        condition_forfee = _condition,
                        datacenter_col = datacentercol,
                        feetype = feetype,
                        financecategory = category,
                        note = note,
                        projectcode = projectcode,
                        platform = platform,
                        website = website,
                        currency = currency,
                        delstatus = 0,
                        datatype=2
                    };

                    list.Add(m);
                }

                
                //保存取数逻辑条件
                var result = _service.SaveOrderFeeConfig(list);
                if (!string.IsNullOrEmpty(result))
                {
                    return Content("保存平台费用取数逻辑配置异常：" + result);
                }

            }

            return Content("OK");
        }
    }
}