﻿using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using Microsoft.AspNetCore.Hosting;
using System.Threading.Tasks;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Bailun.ServiceFabric.Core.Extension;
using Microsoft.AspNetCore.Http;

namespace Bailun.DC.Web.Areas.DataWareHouse.Controllers
{
    [Area("DataWareHouse")]
    public class PlatformOrderController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public PlatformOrderController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        #region 销售平台流水相关

        public IActionResult OrderBillings(string platform)
        {
            var listsite = new Services.DataWareHouse.PlatformOrderServices().ListPlatformSite(platform);
            ViewBag.platform = platform;

            ViewBag.sites = listsite;
            return View();
        }


        [HttpPost]
        public JsonResult OrderBillingsJson(int page,string platform,string website,string account,DateTime? start,DateTime? end,string orderno,string month, int pagesize = 25)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new { 
                    success=  false,
                    msg = "请选择平台类型"
                });
            }

            //if(string.IsNullOrEmpty(website))
            //{
            //    return Json(new { 
            //        success = false,
            //        msg = "请选择站点",
            //    });
            //}

            //if(string.IsNullOrEmpty(month))
            //{
            //    return Json(new { 
            //        success = false,
            //        msg = "请选择月份"
            //    });
            //}

            if(page<=0)
            {
                page = 1;
            }

            int total = 0;
            var obj = new Services.DataWareHouse.PlatformOrderServices().List(page, platform, website, account, start,end,orderno, month, ref total,pagesize);

            var list = obj.Select(a => new { 
                a.accountname,
                a.createtime,
                jsondata = Newtonsoft.Json.Linq.JRaw.Parse(a.jsondata),
                a.month,
                a.orderno,
                a.platform,
                a.website,
                datatime = a.datatime.HasValue?a.datatime.Value.ToString("yyyy-MM-dd HH:mm:ss"):"",
            });

            return Json(new { 
                success = true,
                msg = "",
                rows = list,
                total = total,
                page = page,
                totalpage = total/pagesize+(total%pagesize>0?1:0),
            });
        }

        public ActionResult ExportOrderBillings(string platform, string website, string account, DateTime? start,DateTime? end,string orderno,string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择平台类型"
                });
            }

            //if (string.IsNullOrEmpty(website))
            //{
            //    return Json(new
            //    {
            //        success = false,
            //        msg = "请选择站点",
            //    });
            //}

            //if (string.IsNullOrEmpty(month))
            //{
            //    return Json(new
            //    {
            //        success = false,
            //        msg = "请选择月份"
            //    });
            //}


            var total = 0;
            var obj = new Services.DataWareHouse.PlatformOrderServices().List(1, platform, website, account, start,end, orderno, month, ref total, 0);

            if(obj.Count==0)
            {
                return Json(new
                {
                    success = true,
                    msg = "没有数据"
                });
            }

            //列头

            DataTable dataTable = new DataTable(); //实例化
            var objFirst = obj.FirstOrDefault();
            var jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(objFirst.jsondata);
            var colnames = new List<string>();

            foreach (var item in jsonData)
            {
                dataTable.Columns.Add(item.Key, typeof(string));
                colnames.Add(item.Key);
            }

            foreach (var item in obj)
            { 
                jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(item.jsondata);

                DataRow dataRow = dataTable.NewRow();

                foreach (var c in jsonData)
                {

                    dataRow[c.Key] = c.Value;
                }

                dataTable.Rows.Add(dataRow);
            }

            
            //for (var i = 0; i < dataTable.Columns.Count; i++)
            //{
            //    colnames.Add(dataTable.Columns[i].ColumnName);
            //}

            var listVal = new List<string>();
            for (int j = 0; j < dataTable.Rows.Count; j++)
            {
                var s = "";
                for (int k = 0; k < dataTable.Columns.Count; k++)
                {
                    string tmpRowValue = dataTable.Rows[j][k].ToString();

                    s += tmpRowValue + "|";
                }

                //s = s.Substring(0, s.Length - 1);
                listVal.Add(s);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = platform+ " " + ((start.HasValue?start.Value.ToString("yyyy-MM-dd"):""+(end.HasValue?"至"+end.Value.ToString("yyyy-MM-dd"):""))) + "的账单流水";
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(listVal, colnames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");
        }
    
        /// <summary>
        /// 下载销售平台流水上传模版
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public ActionResult DownLoadOrderBillingTemplate(string platform,string website,DateTime? start,DateTime? end,string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Content("请选择完平台再导出");
            }

            var obj = new Services.DataWareHouse.PlatformOrderServices().Get(platform, website, start, end, month);
            if (obj == null)
            {
                return Content("系统没有该平台的模版可导出，你可自定义一个模版，后面的导入都以本次导入的格式作为新模板。");
            }

            DataTable dataTable = new DataTable(); //实例化
            var jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(obj.jsondata);
            var colnames = new List<string>();

            foreach (var item in jsonData)
            {
                dataTable.Columns.Add(item.Key, typeof(string));
                colnames.Add(item.Key);
            }

            jsonData = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, string>>(obj.jsondata);

            DataRow dataRow = dataTable.NewRow();

            foreach (var c in jsonData)
            {

                dataRow[c.Key] = c.Value;
            }

            dataTable.Rows.Add(dataRow);


            //for (var i = 0; i < dataTable.Columns.Count; i++)
            //{
            //    colnames.Add(dataTable.Columns[i].ColumnName);
            //}

            var listVal = new List<string>();
            for (int j = 0; j < dataTable.Rows.Count; j++)
            {
                var s = "";
                for (int k = 0; k < dataTable.Columns.Count; k++)
                {
                    string tmpRowValue = dataTable.Rows[j][k].ToString();

                    s += tmpRowValue + "|";
                }

                //s = s.Substring(0, s.Length - 1);
                listVal.Add(s);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = platform + " " + ((start.HasValue ? start.Value.ToString("yyyy-MM-dd") : "" + (end.HasValue ? "至" + end.Value.ToString("yyyy-MM-dd") : ""))) + "的上传模版";
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            //ToCSV(listVal, colnames, guid, filepath);

            ToExcel(dataTable, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".xls", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/xls", filename + ".xls");

        }

        /// <summary>
        /// 上传销售平台流水
        /// </summary>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <returns></returns>
        //[BailunAuthentication(LoginMode.Enforce)]
        [DisableRequestSizeLimit]
        public JsonResult UploadOrderBilling(string platform, string website,string month,string guid)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择平台"
                });
            }

            if (string.IsNullOrEmpty(month))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择月份"
                });
            }

            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            

            //var user = HttpContextHelper.Current?.User;

            var file = Request.Form.Files[0];
            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true,ref errmsg);
            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();

                var list = Dtb2Json(tb.Value);
                var listOrders = new List<Models.DataWareHouse.flowing_sales>();
                foreach (var item in list)
                {
                    //保存数据
                    var m = new Models.DataWareHouse.flowing_sales { 
                        accountname = "",
                        createtime = DateTime.Now,
                        jsondata = Newtonsoft.Json.JsonConvert.SerializeObject(item),
                        month = month,
                        platform = platform,
                        website = website??"",
                        orderno = "",
                        platformsku = "",
                        createuser = "页面上传"
                        
                    };
                    listOrders.Add(m);
                }

                var result = new Services.DataWareHouse.PlatformOrderServices().InsertOrderBilling(listOrders);
                return Json(new { 
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }

            return Json(new { 
                success = false,
                msg="无法识别表格的数据，请下载模版重新导入，或者检查下表格数据是否正确。",
            });
        }

        /// <summary>
        /// 平台站点合并单个文件上传
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <returns></returns>
        public JsonResult UploadOrderBillingMerge(string platform,string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择平台"
                });
            }

            if (string.IsNullOrEmpty(month))
            {
                return Json(new
                {
                    success = false,
                    msg = "请选择月份后再导入"
                });
            }


            if (Request.Form.Files.Count == 0)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            //var user = HttpContextHelper.Current?.User;

            var file = Request.Form.Files[0];

            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true,ref errmsg);

            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();

                var list = Dtb2Json(tb.Value);
                var listOrders = new List<Models.DataWareHouse.flowing_sales>();
                foreach (var item in list)
                {
                    //保存数据
                    var m = new Models.DataWareHouse.flowing_sales
                    {
                        accountname = "",
                        createtime = DateTime.Now,
                        jsondata = Newtonsoft.Json.JsonConvert.SerializeObject(item),
                        month = month,
                        platform = platform,
                        //website = website ?? "",
                        orderno = "",
                        platformsku = "",
                        createuser = "页面上传",

                    };
                    listOrders.Add(m);
                }

                var result = new Services.DataWareHouse.PlatformOrderServices().InsertOrderBilling(listOrders);
                return Json(new
                {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }

            return Json(new
            {
                success = false,
                msg = "无法识别表格的数据，请下载模版重新导入，或者检查下表格数据是否正确。",
            });

        }


        public ActionResult FinanceAccount_OrderBilling()
        {
            var listPlatform = new List<string>();

            var listFeeCol = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeCol();

            ViewBag.platform = listPlatform = listFeeCol.Select(a => a.platform).Distinct().ToList();
            ViewBag.website = listFeeCol.Where(a => a.platform == listPlatform.FirstOrDefault()).Select(a => a.website).Distinct().ToList();

            return View();
        }

        public string FinanceAccount_OrderBillingJson(Models.BtTableParameter request, string platform, string website, string account, DateTime? start, DateTime? end, string orderno,string month,int? datatype)
        {
            var total = 0;

            var obj = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeValue(request.pageIndex, request.limit, platform, website, start, end, orderno,month, ref total,datatype);

            var objCount = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeValueCount(platform, website, start, end, orderno, month, datatype);

            var list = obj.Select(a => new
            {
                company = "香港百伦",
                a.platform,
                website = a.website??"global",
                a.orderno,
                a.datatime,
                a.amountval,

                feetype = a.fee_config?.feetype??"",
                subjectcode = a.fee_config?.subjectcode??"",
                projectcode = a.fee_config?.projectcode??"",
                financecategory = a.fee_config?.financecategory??"",
                datacenter_col = a.fee_config?.datacenter_col??"",
                currency = (!string.IsNullOrEmpty(a.currency)?a.currency: a.fee_config.currency),

                exchange_rate = a.exchange_rate.HasValue?a.exchange_rate.Value+"":"",
                amountval_rmb = a.amountval_rmb.HasValue?a.amountval_rmb.Value+"":"",
                a.month,
            });

            var countRow = new {
                company = "香港百伦",
                platform = "",
                website = "",
                orderno = "",
                datatime = "",
                amountval = objCount.amountval.ToString("N2"),

                feetype = "",
                subjectcode = "",
                projectcode = "",
                financecategory = "",
                datacenter_col = "",
                currency = "合计",

                exchange_rate = "",
                amountval_rmb = objCount.amountval_rmb.HasValue ? objCount.amountval_rmb.Value.ToString("N2") : "",
                month="",
            };


            return Newtonsoft.Json.JsonConvert.SerializeObject(new { 
                rows = list,
                total = total,
                count_row = countRow
            });
        }

        /// <summary>
        /// 导出财务会计流水
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="account"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <returns></returns>
        public ActionResult ExportFinanceAccount_OrderBilling(string platform, string website, string account, DateTime? start, DateTime? end, string orderno,string month, int? datatype)
        {
            var total = 0;

            var obj = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeValue(0, 0, platform, website, start, end, orderno, month, ref total, datatype);

            var colnames = new List<string> {
                "主体","平台","站点","账单时间","单号","费用字段说明","财务分类归集说明","数据中心费用类型","会计科目编码","项目编码","币种","原币金额","汇率","RMB金额","月份"
            };

            var list = new List<string>();

            foreach (var item in obj)
            {
                list.Add("公司主体|"+item.platform+"|"+(item.website??"global")+"|"+(item.datatime.HasValue?item.datatime.Value.ToString("yyyy-MM-dd HH:mm:ss"):"")+"|"+item.orderno+"|"+(item.fee_config?.feetype ?? "") +"|"+(item.fee_config?.financecategory ?? "")+"|"+(item.fee_config?.datacenter_col ?? "")+"|"+(item.fee_config?.subjectcode ?? "")+"|"+(item.fee_config?.projectcode ?? "")+"|"+ (!string.IsNullOrEmpty(item.currency) ? item.currency : item.fee_config.currency) + "|"+(item.amountval)+"|"+(item.exchange_rate.HasValue ? item.exchange_rate.Value + "" : "")+"|"+(item.amountval_rmb.HasValue ? item.amountval_rmb.Value + "" : "")+"|"+item.month);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = "财务会计流水" + DateTime.Now.ToString("yyyyMMddHHmmss");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colnames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");

        }

        /// <summary>
        /// 获取平台的站点
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWebsite(string platform,int? datatype)
        {
            //if (string.IsNullOrEmpty(platform))
            //{
            //    return Json(new { 
            //        success = false,
            //        msg = "请选择平台",
            //    });
            //}

            var listFeeCol = new Services.DataWareHouse.PlatformOrderFeeServices().ListOrderFeeCol();

            if (datatype.HasValue)
            {
                listFeeCol = listFeeCol.Where(a => a.datatype == datatype.Value).ToList();
            }

            if (!string.IsNullOrEmpty(platform))
            {
                var listWebsite = listFeeCol.Where(a => a.platform == platform).Where(a => !string.IsNullOrEmpty(a.website)).ToList();

                return Json(new
                {
                    success = true,
                    data = listWebsite.Select(a => a.website).Distinct().ToList(),
                    msg = "",
                });
            }
            else
            {
                var listPlatform = listFeeCol.Where(a => !string.IsNullOrEmpty(a.platform)).ToList();

                return Json(new
                {
                    success = true,
                    data = listPlatform.Select(a => a.platform).Distinct().ToList(),
                    msg = "",
                });
            }

            

        }

        public JsonResult UploadFinanceAccount(int? datatype)
        {
            if (!datatype.HasValue || datatype.Value <= 0)
            {
                return Json(new
                {
                    success = false,
                    msg = $"请选择数据类型再上传。",
                });
            }

            var file = Request.Form.Files[0];
            var errmsg = "";
            Dictionary<string, DataTable> dic = Base.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true, ref errmsg);
            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();
                var listConfig = new Services.DataWareHouse.PlatformOrderServices().ListOrderFeeConfig(datatype.Value);
                var listorder = new List<Models.DataWareHouse.order_fee_value_amazon>();

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    var row = tb.Value.Rows[i];
                    var m = new Models.DataWareHouse.order_fee_value_amazon();


                    m.platform = row["平台"].ToString().Trim();
                    m.website = row["站点"].ToString().Trim();

                    if(string.IsNullOrEmpty(m.platform))
                    {
                        continue;
                    }

                    if (row["账单时间"] != null && row["账单时间"].ToString()!="")
                    {
                        m.datatime = DateTime.Parse(row["账单时间"].ToString());
                    }

                    if (row["月份"] == null || row["月份"].ToString() == "")
                    {
                        return Json(new { 
                            success = false,
                            msg = $"第{(i+1)}行没有填写月份",
                        });
                    }

                    m.month = row["月份"].ToString().Trim();

                    if (row["单号"] != null)
                    {
                        m.orderno = row["单号"].ToString().Trim();
                    }

                    m.orderno = m.orderno ?? "";

                    if (row["数据中心费用类型"] == null)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行没有填写数据中心费用类型字段",
                        });
                    }
                    var datacentercol = row["数据中心费用类型"].ToString().Trim();
                    
                    if(row["币种"]==null)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行没有填写币种字段",
                        });
                    }
                    var currency = row["币种"].ToString().Trim();

                    if (row["原币金额"] == null)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行没有填写原币金额",
                        });
                    }

                    var str_amount = row["原币金额"].ToString().Trim();
                    var amount = 0m;
                    decimal.TryParse(str_amount, out amount);
                    if(amount==0)
                    {
                        continue;
                    }

                    if (row["汇率"] == null)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行没有填写汇率",
                        });
                    }

                    var str_rate = row["汇率"].ToString().Trim();
                    var rate = 0m;
                    decimal.TryParse(str_rate, out rate);
                    if (rate == 0)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行 汇率为0",
                        });
                    }

                    if (row["RMB金额"] == null)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行没有填写RMB金额",
                        });
                    }

                    var str_rmb = row["RMB金额"].ToString().Trim();
                    var rmb = 0m;
                    decimal.TryParse(str_rmb, out rmb);
                    if (rmb == 0)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行 RMB金额为0",
                        });
                    }

                    var _tempConfigs = listConfig.Where(a => a.platform.ToLower() == m.platform.ToLower() && a.datacenter_col == datacentercol);
                    if (!string.IsNullOrEmpty(m.website))
                    {
                        _tempConfigs = _tempConfigs.Where(a => a.website.ToLower() == m.website.Trim().ToLower());
                    }

                    if (_tempConfigs.Count() > 1 && !string.IsNullOrEmpty(currency))
                    {
                        _tempConfigs = _tempConfigs.Where(a => a.currency == currency);
                    }

                    if (_tempConfigs.Count() == 0)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = $"第{(i + 1)}行 找不到对应的解析成财务会计流水的配置，请检查字段值是否有误。",
                        });
                    }

                    m.order_fee_config_id = _tempConfigs.FirstOrDefault().id;
                    m.amountname = "";
                    m.amountval = amount;
                    m.amountval_rmb = rmb;
                    m.currency = currency;
                    m.exchange_rate = rate;
                    m.flowing_sales_id = 0;

                    m.fulfillmentname = "";
                    m.fulfillmentvalue = "";
                    m.typename = "";
                    m.typevalue = "";
                    m.descriptname = "";
                    m.descriptvalue = "";

                    m.platform = _tempConfigs.FirstOrDefault().platform;
                    m.website = _tempConfigs.FirstOrDefault().website;
                    m.datatype = datatype.Value;

                    listorder.Add(m);
                }


                var result = new Services.DataWareHouse.PlatformOrderFeeServices().SaveOrderFee(listorder,0,"");
                return Json(new
                {
                    success = string.IsNullOrEmpty(result),
                    msg = result
                });
            }

            return Json(new
            {
                success = false,
                msg = "无法识别表格的数据,请确认字段是否有误或下载模板填写数据。",
            });
        }

        /// <summary>
        /// 批量删除财务流水数据
        /// </summary>
        /// <param name="datatype">数据类型</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="month">月份</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult BatchDeleteFinanceFlowing(int datatype, string platform, string website, string month)
        {
            if (string.IsNullOrEmpty(platform))
            {
                return Json(new { 
                    success=  false,
                    msg = "平台不能为空 platform must have value",
                });
            }

            if (string.IsNullOrEmpty(website))
            {
                return Json(new { 
                    success = false,
                    msg = "站点不能为空 website must have value",
                });
            }

            if (string.IsNullOrEmpty(month))
            {
                return Json(new { 
                    success = false,
                    msg = "请选择月份 please choose the month"
                });
            }

            var user = HttpContextHelper.Current?.User;

            var count = 0;

            var result = new Services.DataWareHouse.PlatformOrderServices().BatchDeleteFinanceAccountFlowing(datatype, platform, website, month, (user != null ? user.GetUid() : 0), (user != null ? user.GetUserName() : ""), ref count);

            return Json(new { 
                success = string.IsNullOrEmpty(result),
                msg = result,
                count = count
            });
        }


        #endregion

    }
}
