﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Bailun.DC.Models;
using Bailun.DC.Common;
using System.Threading;
using Microsoft.Extensions.Hosting;
using System.Threading.Tasks;
using System.Linq;
using Bailun.DC.Services.WebApiService;

namespace Bailun.DC.SyncMonthSalesProfitNew
{
    public class Services : BackgroundService
    {

        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromHours(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;
                if (now.Hour == 1)
                {
                    Console.WriteLine("同步月利润销售报告开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    new FinanceService().SyncMonthSalesProfit("");
                    Console.WriteLine("同步月利润销售报告任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
                else if (now.Hour == 2)
                {
                    Console.WriteLine("同步生成销售额和成本的汇总数据开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    new FinanceService().SyncMonthSalesProfiOrderDetail("");
                    Console.WriteLine("同步生成销售额和成本的汇总数据任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
                else
                {
                    Console.WriteLine($"现在是 【{now.Hour}点】，未到同步时间，本次同步结束~");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"同步月销售利润错误，堆栈信息：{ex.Message}");
            }
        }
    }
}
