﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using System.Linq;
using Bailun.DC.Models;

namespace Bailun.DC.Services.DataWareHouse
{
    public class PlatformOrderServices
    {
        /// <summary>
        /// 获取平台站点信息
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        public List<string> ListPlatformSite(string platform)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = $"select t1.website from flowing_sales t1 where t1.platform='{platform}' group by t1.website";

                return cn.Query<string>(sql).Where(a=>!string.IsNullOrEmpty(a)).ToList();
            }
        }

        /// <summary>
        /// 获取平台销售账单流水
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="account">销售帐号</param>
        /// <param name="month">月份</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public List<Models.DataWareHouse.flowing_sales> List(int page, string platform, string website, string account,DateTime? start,DateTime? end,string orderno,string month,ref int total,int pagesize)
        {
            var sql = "select * from flowing_sales t1 where 1=1";
            var sqlparam = new DynamicParameters();

            if(!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            if (!string.IsNullOrEmpty(account))
            {
                sql += " and t1.accountname=@account";
                sqlparam.Add("account", account);
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += " and t1.month=@month";
                sqlparam.Add("month", month);
            }

            if (!string.IsNullOrEmpty(orderno))
            {
                sql += " and t1.orderno=@orderno";
                sqlparam.Add("orderno", orderno);
            }

            if (start.HasValue)
            {
                sql += $" and t1.datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if (end.HasValue)
            {
                sql += $" and t1.datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                if (pagesize > 0)
                {
                    var obj = cn.Page<Models.DataWareHouse.flowing_sales>(page, pagesize, sql, ref total, sqlparam);

                    return obj.ToList();
                }
                else
                {
                    var obj = cn.Query<Models.DataWareHouse.flowing_sales>(sql, sqlparam);
                    return obj.ToList();
                }
            }

        }

        /// <summary>
        /// 获取销售平台流水的模版数据
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public Models.DataWareHouse.flowing_sales Get(string platform,string website,DateTime? start,DateTime? end,string month)
        {
            var sql = "select * from flowing_sales where 1=1";
            var sqlParam = new DynamicParameters();

            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and platform=@platform";
                sqlParam.Add("platform", platform);
            }
            if (!string.IsNullOrEmpty(website))
            {
                sql += " and website=@website";
                sqlParam.Add("website", website);
            }

            if(start.HasValue)
            {
                sql += $" and datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }
            if(end.HasValue)
            {
                sql += $" and datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += $" and month=@month";
                sqlParam.Add("month", month);
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<Models.DataWareHouse.flowing_sales>(sql,sqlParam);

                return obj;
            }
        }

        /// <summary>
        /// 保存流水信息
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public string InsertOrderBilling(List<Models.DataWareHouse.flowing_sales> list)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    foreach (var item in list)
                    {
                        cn.Insert(item);
                    }
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
            
            
        }

        #region  上传文件相关

        /// <summary>
        /// 保存文件信息到库
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        public string SaveFileData(Models.DataWareHouse.uploadfiles m)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var id = cn.Insert(m);

                m.id = id ?? 0;

                return "";
            }
        }

        /// <summary>
        /// 更新文件的七牛云标记信息
        /// </summary>
        /// <param name="id"></param>
        /// <param name="hashcode"></param>
        /// <param name="filekey"></param>
        /// <returns></returns>
        public string UpdateFileData(int id,string hashcode,string filekey)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if(cn.State== System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var m = cn.QueryFirstOrDefault<Models.DataWareHouse.uploadfiles>("select * from uploadfiles where id=" + id);
                if (m != null)
                {
                    m.hashcode = hashcode;
                    m.filekey = filekey;

                    cn.Update(m);

                    return "";
                }

                return "找不到该记录";
            }

        }

        /// <summary>
        /// 获取解析成财务会计流水的配置数据
        /// </summary>
        /// <param name="datatype">数据类型，1：销售平台，2：物流数据</param>
        /// <returns></returns>
        public List<Models.DataWareHouse.order_fee_config> ListOrderFeeConfig(int datatype)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var sql = "select * from order_fee_config where datatype="+datatype;

                return cn.Query<Models.DataWareHouse.order_fee_config>(sql).ToList();

            }
        }

        /// <summary>
        /// 批量删除财务会计流水数据
        /// </summary>
        /// <param name="datatype">数据类型，1：销售平台，2：物流商</param>
        /// <param name="platform">平台类型</param>
        /// <param name="website">站点</param>
        /// <param name="month">月份</param>
        /// <param name="uid">用户id</param>
        /// <param name="username">用户名称</param>
        /// <param name="count">受影响数据行数</param>
        /// <returns></returns>
        public string BatchDeleteFinanceAccountFlowing(int datatype,string platform,string website,string month,int uid,string username,ref int count)
        {
            try
            {
                var sql = $"select * from order_fee_value_amazon";
                var sqlwhere = $"  where datatype={datatype} and platform='{platform}' and month='{month}'";

                if (!string.IsNullOrEmpty(website))
                {
                    sqlwhere += $" and website='{website}'";
                }

                //加日志记录标记删除的值

                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    var list = cn.Query<Models.DataWareHouse.order_fee_value_amazon>(sql + sqlwhere).ToList();

                    count = cn.Execute($"update order_fee_value_amazon set isdelete=1,lastupdatetime='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}',lastupdateuserid={uid},lastupdateusername='{username}' where id in ('{string.Join("','", list.Select(a => a.id))}')");

                    return "";

                }
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
            
        }

        #endregion
    }
}
