﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{

    /// <summary>
    /// 手续费
    /// </summary>
    public class dc_base_finance_handlefee
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }


        /// <summary>
        /// 财务id
        /// </summary>
        public int cw_id { get; set; }


        /// <summary>
        /// 交易流水
        /// </summary>
        public string trad_code { get; set; }


        /// <summary>
        /// 付款主体值
        /// </summary>
        public int subject_value_from { get; set; }


        /// <summary>
        /// 付款主体名称
        /// </summary>
        public string subject_name_from { get; set; }


        /// <summary>
        /// 银行帐号ID
        /// </summary>
        public int pay_account_iDFrom { get; set; }


        /// <summary>
        /// 银行名称
        /// </summary>
        public string bank_name_from { get; set; }


        /// <summary>
        /// 银行帐号
        /// </summary>
        public string bank_card_from { get; set; }


        /// <summary>
        /// 持卡人
        /// </summary>
        public string bank_card_user_from { get; set; }


        /// <summary>
        /// 供应商ID
        /// </summary>
        public int supplier_iDFrom { get; set; }


        /// <summary>
        /// 供应商名称
        /// </summary>
        public string supplier_name_from { get; set; }


        /// <summary>
        /// 交易类型 1付款 2 收款
        /// </summary>
        public int trade_type { get; set; }


        /// <summary>
        /// 交易-付款主体值
        /// </summary>
        public string subject_value_to { get; set; }


        /// <summary>
        /// 交易-付款主体名称
        /// </summary>
        public string subject_name_to { get; set; }


        /// <summary>
        /// 交易-银行账户ID
        /// </summary>
        public int pay_account_iDTo { get; set; }


        /// <summary>
        /// 交易-银行名称
        /// </summary>
        public string bank_name_to { get; set; }


        /// <summary>
        /// 交易-银行帐号
        /// </summary>
        public string bank_card_to { get; set; }


        /// <summary>
        /// 交易-持卡人
        /// </summary>
        public string bank_card_user_to { get; set; }


        /// <summary>
        /// 交易-供应商ID
        /// </summary>
        public int supplier_iDTo { get; set; }


        /// <summary>
        /// 交易-供应商名称
        /// </summary>
        public string supplier_name_to { get; set; }


        /// <summary>
        /// 交易-币种名称
        /// </summary>
        public string unit_nameto { get; set; }


        /// <summary>
        /// 交易-币种编号
        /// </summary>
        public string unit_codeto { get; set; }


        /// <summary>
        /// 交易-币种汇率
        /// </summary>
        public decimal rate { get; set; }


        /// <summary>
        /// 交易-交易金额
        /// </summary>
        public decimal pay_moneyto { get; set; }


        /// <summary>
        /// 币种名称
        /// </summary>
        public string unit_name { get; set; }


        /// <summary>
        /// 币种编号
        /// </summary>
        public string unit_code { get; set; }


        /// <summary>
        /// 交易金额
        /// </summary>
        public decimal pay_money { get; set; }


        /// <summary>
        /// 交易金额人民币
        /// </summary>
        public decimal pay_money_rMB { get; set; }


        /// <summary>
        /// 交易前的余额
        /// </summary>
        public decimal old_money { get; set; }


        /// <summary>
        /// 交易后的余额
        /// </summary>
        public decimal new_money { get; set; }


        /// <summary>
        /// 前一天的余额
        /// </summary>
        public decimal before_day_money { get; set; }


        /// <summary>
        /// 备注/摘要
        /// </summary>
        public string remark { get; set; }


        /// <summary>
        /// 附件
        /// </summary>
        public string annex { get; set; }


        /// <summary>
        /// 删除状态 0 正常 1作废
        /// </summary>
        public int has_delete { get; set; }


        /// <summary>
        /// 作废备注
        /// </summary>
        public string delete_remark { get; set; }


        /// <summary>
        /// 创建人
        /// </summary>
        public int create_user_iD { get; set; }


        /// <summary>
        /// 创建人名称
        /// </summary>
        public string create_user_name { get; set; }


        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? create_time { get; set; }


        /// <summary>
        /// 关联转账记录ID
        /// </summary>
        public int fetter_trade_iD { get; set; }


        /// <summary>
        /// 关联转账记录流水号
        /// </summary>
        public string fetter_trade_code { get; set; }


        /// <summary>
        /// 来源 0账户互转 1财务出纳 2提现收入 3币种金额互转 4调账 5供应商退回 6手续费 7借贷
        /// </summary>
        public string source { get; set; }


        /// <summary>
        /// 交易类别 0常规转账 1银行手续费
        /// </summary>
        public string trade_category { get; set; }


        /// <summary>
        /// 出纳申请单ID
        /// </summary>
        public int payment_iD { get; set; }


        /// <summary>
        /// 采购单分类
        /// </summary>
        public int pur_category_iD { get; set; }


        /// <summary>
        /// 采购单分类名称
        /// </summary>
        public string pur_category_name { get; set; }


        /// <summary>
        /// 出纳申请单号，在采购系统确认收款时记录
        /// </summary>
        public string apply_code { get; set; }


        /// <summary>
        /// 原始汇率
        /// </summary>
        public decimal original_rate { get; set; }


        /// <summary>
        /// 来源系统
        /// </summary>
        public string cashier_source_name { get; set; }


        /// <summary>
        /// 采购单号
        /// </summary>
        public string cashier_detail_name { get; set; }


        /// <summary>
        /// 出纳单号
        /// </summary>
        public string cashier_code { get; set; }


        /// <summary>
        /// 出纳单交易类型 -1转账支出 -2替人代付 2找人代付 3提现收入 -4还款支出 4借款收入
        /// </summary>
        public string casher_transaction_type { get; set; }


        /// <summary>
        /// 出纳单ID
        /// </summary>
        public int cashier_id { get; set; }


        /// <summary>
        /// 出纳单其他订单流水号
        /// </summary>
        public string cashier_other_order_code { get; set; }


    }
}
