﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    public class dc_base_buy
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 采购计划单号
        /// </summary>
        public string no { get; set; }

        /// <summary>
        /// 采购单号
        /// </summary>
        public string buyno { get; set; }

        /// <summary>
        /// 采购单状态，-2：已拆单，-1：作废，0：采购员未确认，1：采购员确认，2：主管审核，3：发货入库中，4：采购完成，5：待出纳审核，6：出纳未付款
        /// </summary>
        public int buystatus { get; set; }

        /// <summary>
        /// 付款主体名称
        /// </summary>
        public string paycompanyname { get; set; }

        /// <summary>
        /// sku 编号
        /// </summary>
        public string skucode { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string skuname { get; set; }

        /// <summary>
        /// 预计到货日期
        /// </summary>
        public DateTime arrivaldate { get; set; }

        /// <summary>
        /// 接收货物仓库code
        /// </summary>
        public string warehouseid { get; set; }

        /// <summary>
        /// 接收货物仓库名称
        /// </summary>
        public string warehousename { get; set; }

        /// <summary>
        /// 付款主体value
        /// </summary>
        public int paycompanyid { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int supplierid { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string suppliername { get; set; }

        /// <summary>
        /// 付款类型,1先款后货，2先货后款，3无需付款
        /// </summary>
        public int paytype { get; set; }

        /// <summary>
        /// 采购总金额
        /// </summary>
        public decimal amount { get; set; }

        /// <summary>
        /// 实际支付总金额
        /// </summary>
        public decimal payamount { get; set; }

        /// <summary>
        /// 采购总数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 快递费
        /// </summary>
        public decimal expressfee { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }

        /// <summary>
        /// 最后操作人id
        /// </summary>
        public int lastupdateuserid { get; set; }

        /// <summary>
        /// 最后操作人名称
        /// </summary>
        public string lastupdateusername { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime lastupdatetime { get; set; }

        /// <summary>
        /// 采购员id
        /// </summary>
        public int buyuserid { get; set; }

        /// <summary>
        /// 付款状态，0：未付款，1：部分付款，2：已付款，3无需付款
        /// </summary>
        public int paystatus { get; set; }

        /// <summary>
        /// 发货状态，0：未发货，1：部分发货，2：全部发货
        /// </summary>
        public int sendstatus { get; set; }

        /// <summary>
        /// 创建人id
        /// </summary>
        public int createuserid { get; set; }

        /// <summary>
        /// 创建人名称
        /// </summary>
        public string createusername { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string orderno { get; set; }

        /// <summary>
        /// 采购单备注
        /// </summary>
        public string note { get; set; }

        /// <summary>
        /// 是否删除，0：未删除，1：已删除
        /// </summary>
        public int delstatus { get; set; }

        /// <summary>
        /// 是否紧急，0：常规，1：紧急
        /// </summary>
        public int isurgency { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>
        public string buyusername { get; set; }

        /// <summary>
        /// 附件id
        /// </summary>
        public int fileid { get; set; }

        /// <summary>
        /// 附件保存路径
        /// </summary>
        public string filepath { get; set; }

        /// <summary>
        /// 部门id
        /// </summary>
        public int departmentid { get; set; }

        /// <summary>
        /// 部门名称
        /// </summary>
        public string departmentname { get; set; }

        /// <summary>
        /// 审核人id
        /// </summary>
        public int audituserid { get; set; }

        /// <summary>
        /// 审核人名称
        /// </summary>
        public string auditusername { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime audittime { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string auditnote { get; set; }

        /// <summary>
        /// 采购主体
        /// </summary>
        public string company { get; set; }

        /// <summary>
        /// 供应商编号
        /// </summary>
        public string supplier_no { get; set; }

        /// <summary>
        /// 驳回理由
        /// </summary>
        public string reject_reason { get; set; }

        /// <summary>
        /// 出纳系统 detailKey
        /// </summary>
        public string detail_key { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string link_lend_cost_no { get; set; }

        /// <summary>
        /// 供应商银行
        /// </summary>
        public string supplier_bankname { get; set; }

        /// <summary>
        /// 供应商银行卡号
        /// </summary>
        public string supplier_cardno { get; set; }

        /// <summary>
        /// 供应商持卡人
        /// </summary>
        public string supplier_cardusername { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public DateTime pay_time { get; set; }

        /// <summary>
        /// SKU大类名称
        /// </summary>
        public string sku_type_name { get; set; }

        /// <summary>
        /// 采购公司主体value
        /// </summary>
        public int company_value { get; set; }

        /// <summary>
        /// 统计的数据日期
        /// </summary>
        public DateTime day { get; set; }


    }
}
