﻿using System.ComponentModel;

namespace Bailun.DC.Models.WebApiModels
{
    /// <summary>
    /// 上级名称特性
    /// </summary>
    public class ParentNameAttribute : DisplayNameAttribute
    {
        /// <summary>
        /// 
        /// </summary>
        public override string DisplayName { get; }

        /// <summary>
        /// 上级名称
        /// </summary>
        public ParentNameEnum? ParentName { get; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="displayName"></param>
        public ParentNameAttribute(string displayName)
        {
            DisplayName = displayName;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="displayName"></param>
        /// <param name="parentName"></param>
        public ParentNameAttribute(string displayName, ParentNameEnum parentName)
        {
            DisplayName = displayName;
            ParentName = parentName;
        }
    }

    /// <summary>
    /// 
    /// </summary>
    public enum ParentNameEnum
    {
        None = 0,

        /// <summary>
        /// 销售额
        /// </summary>
        [Description("销售额")]
        amount_sales = 1,

        /// <summary>
        /// 成本
        /// </summary>
        [Description("成本")]
        cost = 2,

        /// <summary>
        /// 平台费
        /// </summary>
        [Description("平台费")]
        fee_platform = 3,

        /// <summary>
        /// 仓储费
        /// </summary>
        [Description("仓储费")]
        fee_logistics_storage = 4,
        /// <summary>
        /// 
        /// </summary>
        [Description("销售费用-税金")]
        fee_sales_taxes = 5,
        /// <summary>
        /// 销售费用合计
        /// </summary>
        [Description("销售费用合计")]
        fee_sales_count = 6,

        /// <summary>
        /// 管理成本合计
        /// </summary>
        [Description("管理成本合计")]
        managercost_count = 7,

        /// <summary>
        /// 营业利润
        /// </summary>
        [Description("营业利润")]
        profit = 8,

        /// <summary>
        /// 实际利润
        /// </summary>
        [Description("实际利润")]
        actual_profit = 9,

        /// <summary>
        /// 净利率
        /// </summary>
        [Description("净利率")]
        rate_profit_actual = 10
    }
}
