﻿using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using NPOI.XSSF.UserModel;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;

namespace Bailun.DC.Common
{
    public static class ExcelHelper
    {
        public static DataTable ExcelToDataTable(string fileName, string sheetName, bool isFirstRowColumn, Dictionary<string, string[]> columnTemplate = null, string[] requireColumns = null, int? maxRows = null)
        {
            ISheet sheet = null;
            DataTable dataTable = new DataTable();
            IWorkbook workbook = null;
            int num = 0;
            try
            {
                using (FileStream fileStream = new FileStream(fileName, FileMode.Open, FileAccess.Read))
                {
                    try
                    {
                        workbook = new XSSFWorkbook((Stream)fileStream);
                    }
                    catch
                    {
                        workbook = new HSSFWorkbook(fileStream);
                    }
                }

                if (sheetName != null)
                {
                    if (workbook != null)
                    {
                        sheet = workbook.GetSheet(sheetName);
                        if (sheet == null)
                        {
                            sheet = workbook.GetSheetAt(0);
                        }
                    }
                }
                else if (workbook != null)
                {
                    sheet = workbook.GetSheetAt(0);
                }

                if (sheet != null)
                {
                    IRow row = sheet.GetRow(0);
                    int lastCellNum = row.LastCellNum;
                    if (isFirstRowColumn)
                    {
                        for (int i = row.FirstCellNum; i < lastCellNum; i++)
                        {
                            string text = row.GetCell(i)?.StringCellValue?.Trim();
                            if (!string.IsNullOrWhiteSpace(text))
                            {
                                if (columnTemplate != null && !columnTemplate.First().Value.Contains(text))
                                {
                                    throw new Exception(columnTemplate.First().Key + "不存在列名：" + text + "！正确列名为：" + string.Join(",", columnTemplate.First().Value));
                                }

                                DataColumn column = new DataColumn(text);
                                dataTable.Columns.Add(column);
                            }
                        }

                        num = sheet.FirstRowNum + 1;
                    }
                    else
                    {
                        num = sheet.FirstRowNum;
                    }

                    int lastRowNum = sheet.LastRowNum;
                    if (maxRows.HasValue && lastRowNum > maxRows)
                    {
                        throw new Exception($"请拆分文件，一次最多支持{maxRows}条数据");
                    }

                    for (int j = num; j <= lastRowNum; j++)
                    {
                        IRow row2 = sheet.GetRow(j);
                        if (row2 == null || row2.Cells.Count == 0 || row2.FirstCellNum == -1 || row2.Cells.All((ICell d) => d.CellType == CellType.Blank))
                        {
                            continue;
                        }

                        DataRow dataRow = dataTable.NewRow();
                        for (int k = row2.FirstCellNum; k < lastCellNum; k++)
                        {
                            ICell cell = row2.GetCell(k);
                            if ((cell != null && !(cell.ToString().Trim() == "0")) || (requireColumns?.Contains(dataTable.Columns[k].ColumnName) ?? false))
                            {
                            }

                            if (cell != null)
                            {
                                dataRow[k] = cell.ToString().Trim();
                            }
                            else
                            {
                                dataRow[k] = "";
                            }
                        }

                        dataTable.Rows.Add(dataRow);
                    }
                }

                workbook?.Close();
                return dataTable;
            }
            catch (Exception ex)
            {
                workbook?.Close();
                throw new Exception(ex.Message);
            }
        }


        public static int DataTableToExcel(DataTable data, string fileName, bool isColumnWritten, string sheetName = "Sheet1")
        {
            int num = 0;
            int num2 = 0;
            int num3 = 0;
            ISheet sheet = null;
            IWorkbook workbook = null;
            string directoryName = Path.GetDirectoryName(fileName);
            if (!Directory.Exists(directoryName) && directoryName != null)
            {
                Directory.CreateDirectory(directoryName);
            }

            using (FileStream stream = new FileStream(fileName, FileMode.Create, FileAccess.ReadWrite))
            {
                if (fileName.IndexOf(".xlsx", StringComparison.Ordinal) > 0)
                {
                    workbook = new XSSFWorkbook();
                }
                else if (fileName.IndexOf(".xls", StringComparison.Ordinal) > 0)
                {
                    workbook = new HSSFWorkbook();
                }

                try
                {
                    if (workbook != null)
                    {
                        sheet = workbook.CreateSheet(sheetName);
                        if (isColumnWritten)
                        {
                            IRow row = sheet.CreateRow(0);
                            for (num2 = 0; num2 < data.Columns.Count; num2++)
                            {
                                row.CreateCell(num2).SetCellValue(data.Columns[num2].ColumnName);
                            }

                            num3 = 1;
                        }
                        else
                        {
                            num3 = 0;
                        }

                        for (num = 0; num < data.Rows.Count; num++)
                        {
                            IRow row2 = sheet.CreateRow(num3);
                            for (num2 = 0; num2 < data.Columns.Count; num2++)
                            {
                                row2.CreateCell(num2).SetCellValue(data.Rows[num][num2].ToString());
                            }

                            num3++;
                        }

                        workbook.Write(stream);
                        workbook.Close();
                        return num3;
                    }

                    return -1;
                }
                catch (Exception ex)
                {
                    workbook?.Close();
                    throw new Exception(ex.Message);
                }
            }
        }

        public static DataTable ExcelToDataTable(string sheetName, bool isFirstRowColumn, string fileName, int startRow = 0, int startData = 1)
        {
            ISheet sheet = null;
            DataTable dataTable = new DataTable();
            try
            {
                IWorkbook workbook = null;
                FileStream fileStream = new FileStream(fileName, FileMode.Open, FileAccess.Read);
                if (fileName.IndexOf(".xlsx") > 0 || fileName.IndexOf(".xlsm") > 0)
                {
                    workbook = new XSSFWorkbook((Stream)fileStream);
                }
                else if (fileName.IndexOf(".xls") > 0)
                {
                    workbook = new HSSFWorkbook(fileStream);
                }

                if (sheetName != null)
                {
                    sheet = workbook.GetSheet(sheetName);
                    if (sheet == null)
                    {
                        sheet = workbook.GetSheetAt(0);
                    }
                }
                else
                {
                    sheet = workbook.GetSheetAt(0);
                }

                if (sheet != null)
                {
                    IRow row = sheet.GetRow(startRow);
                    int lastCellNum = row.LastCellNum;
                    if (isFirstRowColumn)
                    {
                        for (int i = row.FirstCellNum; i < lastCellNum; i++)
                        {
                            ICell cell = row.GetCell(i);
                            if (cell == null)
                            {
                                continue;
                            }

                            string text = cell.StringCellValue.Replace(" ", "").Replace("?", "");
                            if (text != null)
                            {
                                if (dataTable.Columns[text] != null)
                                {
                                    text += i;
                                }

                                DataColumn column = new DataColumn(text);
                                dataTable.Columns.Add(column);
                            }
                        }

                        startRow += sheet.FirstRowNum + startData;
                    }
                    else
                    {
                        startRow = sheet.FirstRowNum;
                    }

                    int lastRowNum = sheet.LastRowNum;
                    for (int j = startRow; j <= lastRowNum; j++)
                    {
                        IRow row2 = sheet.GetRow(j);
                        if (row2 == null)
                        {
                            continue;
                        }

                        DataRow dataRow = dataTable.NewRow();
                        for (int k = row2.FirstCellNum; k < lastCellNum; k++)
                        {
                            if (row2.GetCell(k) != null)
                            {
                                dataRow[k] = row2.GetCell(k).ToString();
                            }
                        }

                        dataTable.Rows.Add(dataRow);
                    }
                }

                return dataTable;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Exception: " + ex.Message);
                return null;
            }
        }
    }
}
