﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.DC.Services;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class PurchaseController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 采购单
        /// </summary>
        /// <returns></returns>
        public ActionResult ListPurchase()
        {
            return View();
        }

        /// <summary>
        /// 采购单列表
        /// </summary>
        /// <param name="parameter">分页信息</param>
        /// <param name="warehouse">仓库编码</param>
        /// <param name="sku">sku编码</param>
        /// <param name="no">采购单号</param>
        /// <param name="status">采购单状态</param>
        /// <returns></returns>
        public string ListPurchaseJson(BtTableParameter parameter, string warehouse, string sku, string no, int? status)
        {
            var total = 0;
            var service = new Services.PurchaseServices();
            var obj = service.ListPurchase(parameter, warehouse, sku, no, status, ref total);
            var countM = service.ListPurchaseCount(warehouse, sku, no, status);

            countM.bailun_sku = "总计：";

            var list = obj.Select(p => new {
                p.amount,
                p.arrivalcount,
                p.bailun_sku,
                p.breakcount,
                p.buyer_name,
                p.category_name,
                p.character,
                p.checkcount,
                p.check_fail_count,
                p.check_success_count,
                p.color,
                p.count,
                create_time = p.create_time.ToString("yyyy-MM-dd HH:mm:ss"),
                p.currency,
                p.exchangecount,
                gmt_modified = p.gmt_modified.ToString("yyyy-MM-dd HH:mm:ss"),
                has_transfer = p.has_transfer==1?"采购调拨":"采购入库",
                p.losscount,
                p.noarrivalcount,
                p.nosendcount,
                p.price,
                p.purchase_id,
                p.putincount,
                p.qccount,
                p.qccount_fail,
                p.qccount_success,
                p.returncount,
                p.sendcount,
                p.sku_image,
                p.sku_title_cn,
                p.sku_title_en,
                buy_status = Enum.GetName(typeof(Models.Purchase.EnumPurchaseStatus),p.buy_status),
                p.supplier_name,
                update_time = p.update_time.ToString("yyyy-MM-dd HH:mm:ss"),
                p.waitallotcount,
                p.warehouse_name_from,
                p.warehouse_name_to,
            });

            return JsonConvert.SerializeObject(new { total = total, rows = list,count_row = countM });
        }

    }
}