﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.DC.Web.Areas.ExportFile.Controllers
{
    [Area("ExportFile")]
    public class PutinController : Base.BaseController
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public PutinController(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }


        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 导出采购入库单
        /// </summary>
        /// <param name="start">开始日期</param>
        /// <param name="end">结束日期</param>
        /// <param name="companyid">公司id</param>
        /// <returns></returns>
        public ActionResult ExportPurchasePutin(DateTime start, DateTime end,int companyid,string skucategoryids)
        {
            if (start.AddDays(31) < end)
            {
                return View("时间跨度不能大于一个月");
            }

            var _service = new Services.ExportServices();

            var objPurchasePutin = _service.ListPurchasePutin(start, end, companyid,skucategoryids);

            var colNames = new List<string> {"采购入库单号","Sku","仓库编码", "仓库名称", "入库数量",
                                             "入库时间","采购单号","采购单价" };

            var list = new List<string>();
            foreach (var item in objPurchasePutin)
            {
                list.Add(item.no + "|" + item.bailun_sku + "|" + item.warehouse_code + "|" + item.warehouse_name + "|" + item.count + "|" +
                    item.update_time.ToString("yyyy-MM-dd HH:mm:ss")+"|"+item.purchase_id+"|"+item.price);
            }

            var guid = Guid.NewGuid().ToString();
            var filename = "采购入库明细"+start.ToString("yyyy-MM-dd")+"至"+end.ToString("yyyy-MM-dd") ;
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");
        }

        /// <summary>
        /// 导出调拨入库明细
        /// </summary>
        /// <param name="start">开始日期</param>
        /// <param name="end">结束日期</param>
        /// <param name="companyid">公司id</param>
        /// <returns></returns>
        public ActionResult ExportAllotPutin(DateTime start, DateTime end, int companyid,string skucategoryids)
        {
            if (start.AddDays(31) < end)
            {
                return View("时间跨度不能大于一个月");
            }

            var _service = new Services.ExportServices();

            var obj = _service.ListAllotPutin(start, end, companyid,skucategoryids);

            var colNames = new List<string> {"调拨单号","Sku","仓库编码", "仓库名称", "入库数量",
                                             "入库时间" };

            var list = new List<string>();
            foreach (var item in obj)
            {
                list.Add(item.transfer_order_id + "|" + item.bailun_sku + "|" + item.warehouse_code + "|" + item.warehouse_name + "|" + item.count + "|" +
                    item.create_time.ToString("yyyy-MM-dd HH:mm:ss"));
            }

            var guid = Guid.NewGuid().ToString();
            var filename = "调拨入库明细" + start.ToString("yyyy-MM-dd") + "至" + end.ToString("yyyy-MM-dd");
            var filepath = _hostingEnvironment.WebRootPath + "\\Files\\Report\\" + DateTime.Now.ToString("yyyy-MM-dd") + "\\";
            ToCSV(list, colNames, guid, filepath);

            var ms = new System.IO.MemoryStream();
            using (var f = new System.IO.FileStream(filepath + guid + ".csv", System.IO.FileMode.Open))
            {
                f.CopyTo(ms);
            }

            ms.Position = 0;
            return File(ms, "text/csv", filename + ".csv");
        }

    }
}