﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 数据仓表
    /// </summary>
    public class dc_datawarehouse
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 仓库类型
        /// </summary>
        public string warehousetype { get; set; }

        /// <summary>
        /// 仓库所在国家id
        /// </summary>
        public int? area_id { get; set; }

        /// <summary>
        /// 仓库所在国家
        /// </summary>
        public string area_name { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehousename { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string sku { get; set; }

        /// <summary>
        /// 分类id
        /// </summary>
        public int? category_id { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string categoryname { get; set; }

        /// <summary>
        /// SKU中文名称
        /// </summary>
        public string skuname { get; set; }

        /// <summary>
        /// 监控状态，1：正在监控，0：停止监控
        /// </summary>
        public int? monitorstatus { get; set; }

        /// <summary>
        /// 清货状态，1：正在清货，0：未清货
        /// </summary>
        public int? clearancestatus { get; set; }

        /// <summary>
        /// 侵权状态：1：已侵权，0：未侵权
        /// </summary>
        public int? tortstatus { get; set; }

        /// <summary>
        /// Sku标签
        /// </summary>
        public string str_skutag { get; set; }

        /// <summary>
        /// 采购价
        /// </summary>
        public decimal? buyprice { get; set; }

        /// <summary>
        /// 库存数量
        /// </summary>
        public int? usable_stock { get; set; }

        /// <summary>
        /// 库存金额
        /// </summary>
        public decimal? amount_stock { get; set; }

        /// <summary>
        /// 采购在途数量
        /// </summary>
        public int? quantity_purchase { get; set; }

        /// <summary>
        /// 采购在途金额
        /// </summary>
        public decimal? purchase_amount { get; set; }

        /// <summary>
        /// 调拨在途数量
        /// </summary>
        public int? quantity_transfer { get; set; }

        /// <summary>
        /// 调拨在途金额
        /// </summary>
        public decimal? amount_transit { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public int? quantity_out_stock { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public int? oneday_total_sales { get; set; }

        /// <summary>
        /// 昨日销量金额
        /// </summary>
        public decimal? amount_onedaysale { get; set; }

        /// <summary>
        /// 7日总销量
        /// </summary>
        public int? sevenday_total_sales { get; set; }

        /// <summary>
        /// 7日总销售额
        /// </summary>
        public decimal? amount_sevendaysale { get; set; }

        /// <summary>
        /// 14日总销量
        /// </summary>
        public int? fourteenday_total_sales { get; set; }

        /// <summary>
        /// 30日总销量
        /// </summary>
        public int? thirtyday_total_sales { get; set; }

        /// <summary>
        /// 近7日日均
        /// </summary>
        public decimal? sevenday_average_sales { get; set; }

        /// <summary>
        /// 近14日日均
        /// </summary>
        public decimal? fourteenday_average_sales { get; set; }

        /// <summary>
        /// 近30日日均
        /// </summary>
        public decimal? thirtyday_average_sales { get; set; }

        /// <summary>
        /// sku开发时间
        /// </summary>
        public DateTime? skucreatetime { get; set; }

        /// <summary>
        /// 数据更新时间
        /// </summary>
        public DateTime lastupdatetime { get; set; }

        /// <summary>
        /// 分组名称
        /// </summary>
        public string groupname { get; set; }

        /// <summary>
        /// 未发货数
        /// </summary>
        public int? quantity_unshipped { get; set; }
    }
}
