﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Orders
{
    /// <summary>
    /// 内部编码sku的利润
    /// </summary>
    public class mInnerCodeProfit
    {
        /// <summary>
        /// sku内部编码
        /// </summary>
        public string product_inner_code { get; set; }

        /// <summary>
        /// 平台订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 销售帐号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 百伦订单状态
        /// </summary>
        public string bailun_order_status { get; set; }

        /// <summary>
        /// 付款状态
        /// </summary>
        public string pay_status { get; set; }

        /// <summary>
        /// 发货状态
        /// </summary>
        public string shipping_status { get; set; }

        /// <summary>
        /// 销售额
        /// </summary>
        public decimal amount_sales { get; set; }

        /// <summary>
        /// 平台费
        /// </summary>
        public decimal cost_platform_fee { get; set; }

        /// <summary>
        /// 产品成本
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 头程费
        /// </summary>
        public decimal cost_first { get; set; }
        
        /// <summary>
        /// 尾程费
        /// </summary>
        public decimal cost_logistics { get; set; }

        /// <summary>
        /// 百伦处理费
        /// </summary>
        public decimal cost_handle_bailun { get; set; }

        /// <summary>
        /// 平台操作费
        /// </summary>
        public decimal cost_handle_platform { get; set; }

        /// <summary>
        /// paypal费
        /// </summary>
        public decimal cost_paypal_fee { get; set; }

        /// <summary>
        /// 总支出
        /// </summary>
        public decimal cost_total { get; set; }

        /// <summary>
        /// 销售数量
        /// </summary>
        public decimal bailun_sku_quantity_ordered { get; set; }

        /// <summary>
        /// 利润
        /// </summary>
        public decimal profit_total { get; set; }

        /// <summary>
        /// 利润率
        /// </summary>
        public decimal profit_rate { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime order_update_time { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string transaction_id { get; set; }

    }
}
