﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Orders
{

    /// <summary>
    /// 平台sku订单明细
    /// </summary>
    public class dc_base_oms_platform_sku
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 平台订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 交易号
        /// </summary>
        public string transaction_id { get; set; }

        /// <summary>
        /// 支付时间-平台站点时间
        /// </summary>
        public DateTime? pay_time_site { get; set; }

        /// <summary>
        /// 支付时间-北京时间
        /// </summary>
        public DateTime? pay_time { get; set; }

        /// <summary>
        /// 支付方法
        /// </summary>
        public string pay_method { get; set; }

        /// <summary>
        /// 支付账号
        /// </summary>
        public string pay_account { get; set; }

        /// <summary>
        /// 支付状态
        /// </summary>
        public string pay_status { get; set; }

        /// <summary>
        /// 收款账号
        /// </summary>
        public string collection_account { get; set; }

        /// <summary>
        /// 平台订单类型
        /// </summary>
        public string platform_order_type { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 订单创建时间-北京时间
        /// </summary>
        public DateTime? create_time { get; set; }

        /// <summary>
        /// 订单创建时间-平台站点时间
        /// </summary>
        public DateTime? create_time_site { get; set; }

        /// <summary>
        /// 订单付款时间-平台站点时间
        /// </summary>
        public DateTime? paid_time_site { get; set; }

        /// <summary>
        /// 订单付款时间-北京时间
        /// </summary>
        public DateTime? paid_time { get; set; }

        /// <summary>
        /// 销售账号Id
        /// </summary>
        public string seller_id { get; set; }

        /// <summary>
        /// 账号id
        /// </summary>
        public int bailun_account_id { get; set; }

        /// <summary>
        /// 销售账号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// （亚马逊特有字段）
        /// </summary>
        public string seller_order_id { get; set; }

        /// <summary>
        /// 销售账号邮箱
        /// </summary>
        public string seller_email { get; set; }

        /// <summary>
        /// 订单更新时间-北京时间
        /// </summary>
        public DateTime? order_update_time { get; set; }

        /// <summary>
        /// 销售订单汇率-转人民币
        /// </summary>
        public decimal seller_order_exchange_rate { get; set; }

        /// <summary>
        /// 财务订单汇率-转人民币
        /// </summary>
        public decimal finance_order_exchange_rate { get; set; }

        /// <summary>
        /// 人民币转美元汇率
        /// </summary>
        public decimal cny_to_usd_exchange_rate { get; set; }

        /// <summary>
        /// Order币种转美元汇率
        /// </summary>
        public decimal order_to_usd_exchange_rate { get; set; }

        /// <summary>
        /// 订单币种
        /// </summary>
        public string order_currency { get; set; }

        /// <summary>
        /// 销售员
        /// </summary>
        public string seller_name { get; set; }

        /// <summary>
        /// 百伦订单号
        /// </summary>
        public string bailun_order_id { get; set; }

        /// <summary>
        /// 平台订单状态
        /// </summary>
        public string platform_order_status { get; set; }

        /// <summary>
        /// 百伦订单状态
        /// </summary>
        public string bailun_order_status { get; set; }

        /// <summary>
        /// 百伦付款状态
        /// </summary>
        public string bailun_payment_status { get; set; }

        /// <summary>
        /// 百伦拦截状态
        /// </summary>
        public string bailun_interception_status { get; set; }

        /// <summary>
        /// 百伦发货状态
        /// </summary>
        public string shipping_status { get; set; }

        /// <summary>
        /// 平台SKU
        /// </summary>
        public string platform_sku { get; set; }

        /// <summary>
        /// itemId
        /// </summary>
        public string item_id { get; set; }

        /// <summary>
        /// 平台SKU英文标题
        /// </summary>
        public string platform_sku_title_en { get; set; }

        /// <summary>
        /// 平台SKU中文标题
        /// </summary>
        public string platform_sku_title_cn { get; set; }

        /// <summary>
        /// 平台SKU订单数量
        /// </summary>
        public int platform_sku_quantity_ordered { get; set; }

        /// <summary>
        /// 平台SKU发货数量
        /// </summary>
        public int platform_sku_quantity_shipped { get; set; }

        /// <summary>
        /// 平台SKU单价
        /// </summary>
        public decimal platform_sku_unit_price { get; set; }

        /// <summary>
        /// 收货国家
        /// </summary>
        public string receipt_country { get; set; }

        /// <summary>
        /// 收货城市
        /// </summary>
        public string receipt_city { get; set; }

        /// <summary>
        /// 收货州或区域
        /// </summary>
        public string receipt_area { get; set; }

        /// <summary>
        /// 收货街道
        /// </summary>
        public string receipt_address { get; set; }

        /// <summary>
        /// 收货门牌
        /// </summary>
        public string receipt_address_2 { get; set; }

        /// <summary>
        /// 收货邮编
        /// </summary>
        public string receipt_postal_code { get; set; }

        /// <summary>
        /// 收货人
        /// </summary>
        public string receiver { get; set; }

        /// <summary>
        /// 收货电话
        /// </summary>
        public string receiver_phone { get; set; }

        /// <summary>
        /// 买家账号Id
        /// </summary>
        public string buyer_id { get; set; }

        /// <summary>
        /// 买家账号
        /// </summary>
        public string buyer_name { get; set; }

        /// <summary>
        /// 买家邮箱
        /// </summary>
        public string buyer_email { get; set; }

        /// <summary>
        /// 是否被平台取消-来自OMS
        /// </summary>
        public bool has_cancle { get; set; }

        /// <summary>
        /// 区域Id
        /// </summary>
        public int area_id { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 是否删除-数据中心判断
        /// </summary>
        public bool has_delete { get; set; }

        /// <summary>
        /// 是否刷单订单
        /// </summary>
        public bool has_scalp { get; set; }

    }
}
