﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Stock
{
    public class mSkuWarehouse
    {
        /// <summary>
        /// 仓库类型
        /// </summary>
        public string hq_type { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 主图
        /// </summary>
        public string sku_image { get; set; }

        /// <summary>
        /// 是否已推送产品库
        /// </summary>
        public int push_status { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string category_name { get; set; }

        /// <summary>
        /// 英文标题
        /// </summary>
        public string sku_title_en { get; set; }

        /// <summary>
        /// 中文标题
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 库存数量
        /// </summary>
        public int? usable_stock { get; set; }

        /// <summary>
        /// 库存金额
        /// </summary>
        public decimal? amount_stock { get; set; }

        /// <summary>
        /// 采购在途数量
        /// </summary>
        public int? quantity_purchase { get; set; }

        /// <summary>
        /// 采购在途金额
        /// </summary>
        public decimal? purchase_amount { get; set; }

        /// <summary>
        /// 调拨在途数量
        /// </summary>
        public int? quantity_transfer { get; set; }

        /// <summary>
        /// 调拨在途金额
        /// </summary>
        public decimal? amount_transit { get; set; }

        /// <summary>
        /// 待发货数
        /// </summary>
        public int? noshippingcount { get; set; }

        /// <summary>
        /// 缺货数
        /// </summary>
        public int? nostockcount { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public int? oneday_total_sales { get; set; }

        /// <summary>
        /// 昨日销售额
        /// </summary>
        public decimal? amount_onedaysale { get; set; }

        /// <summary>
        /// 七天销量
        /// </summary>
        public int? sevenday_total_sales { get; set; }

        /// <summary>
        /// 十四天销量
        /// </summary>
        public int? fourteenday_total_sales { get; set; }

        /// <summary>
        /// 三十天销量
        /// </summary>
        public int? thirtyday_total_sales { get; set; }

        /// <summary>
        /// 调出在途数
        /// </summary>
        public int? quantity_tuneout_onway { get; set; }

        /// <summary>
        /// 30天内调出数量
        /// </summary>
        public int? quantity_tuneout_30days { get; set; }

        /// <summary>
        /// 30天内调入数量
        /// </summary>
        public int? quantity_tunein_30days { get; set; }

        /// <summary>
        /// 30天现金流收入
        /// </summary>
        public decimal? cash_in_30days { get; set; }

        /// <summary>
        /// 30天现金流支出
        /// </summary>
        public decimal? cash_out_30days { get; set; }

        /// <summary>
        /// 30天现金流净值，收入-支出
        /// </summary>
        public decimal? cash_net { get; set; }

        /// <summary>
        /// 动销率，动销率=过去一个月卖出的SKU/SKU的库存金额
        /// </summary>
        public decimal? pin_rate_stock { get; set; }

        /// <summary>
        /// 可销售天数
        /// </summary>
        public int? available_days { get; set; }


        public decimal sevenday_total_sales_amount { get; set; }

        public decimal? fourteenday_total_sales_amount { get; set; }
        

        public decimal? thirtyday_total_sales_amount { get; set; }
        

        /// <summary>
        /// 30天内调出金额
        /// </summary>
        public decimal? amount_tuneout_30days { get; set; }

        /// <summary>
        /// 30天内调入金额
        /// </summary>
        public decimal? amount_tunein_30days { get; set; }


        /// <summary>
        /// 超过6个月库龄的库存数
        /// </summary>
        public int? stock_age_6months { get; set; }

        /// <summary>
        /// 超过6个月库龄的库存金额
        /// </summary>
        public decimal? stock_age_6months_amount { get; set; }

        /// <summary>
        /// sku产品分类
        /// </summary>
        public string skucategory { get; set; }
    }
}
