﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.DC.Models;
using Bailun.ServiceFabric.Authorize;
using Newtonsoft.Json;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Bailun.ServiceFabric.Core.Extension;

namespace Bailun.DC.Web.Areas.Reports.Controllers
{
    [Area("Reports")]
    public class LogisticsController : Base.BaseController
    {
        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 物流供应商往来统计报表
        /// </summary>
        /// <returns></returns>
        public ActionResult SupplierTrancationReport()
        {
            //未对账往来数据总额
            var amount = new Services.LogisticsServices().NoStatisticAmount();
            ViewBag.amount = amount.ToString("N2");

            return View();
        }

        /// <summary>
        /// 物流供应商往来统计报表
        /// </summary>
        /// <param name="request">分页信息</param>
        /// <param name="start">开始时间</param>
        /// <param name="end">结束时间</param>
        /// <param name="suppliername">供应商名称</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]

        [BrowseLog("Bailun_data", "访问【百伦数据中心】->【财务报表】->【物流供应商往来】->【搜索】页面", 0)]
        public string SupplierTrancationReportJson(BtTableParameter request,DateTime start,DateTime end,string suppliername)
        {
            var total = 0;
            var obj = new Services.LogisticsServices().ListSupplierTransaction(start, end, suppliername);
            total = obj.Count;
            //var objCount = new Services.LogisticsServices().ListSupplierTransactionCount(start, end, suppliername);

            var list = obj.Select(a => new {
                str_day = (start==end?start.ToString("yyyy-MM-dd"):start.ToString("yyyy-MM-dd")+"至"+end.ToString("yyyy-MM-dd")),
                amount_start = a.amount_start.ToString("N2"),
                amount_happen = a.amount_happen.ToString("N2"),
                amount_pay = a.amount_pay.ToString("N2"),
                amount_receipt = a.amount_receipt.ToString("N2"),
                amount_other = a.amount_other,
                amount_end = a.amount_end.ToString("N2"),
                a.suppliername,
            });
            

            return JsonConvert.SerializeObject(new
            {
                total = total,
                rows = list,
                count_row = new
                {
                    str_day = "合计",
                    amount_start = obj.Count>0?obj.Sum(a=>a.amount_start).ToString("N2"):"0",
                    amount_happen = obj.Count > 0 ? obj.Sum(a=>a.amount_happen).ToString("N2"):"0",
                    amount_pay = obj.Count > 0 ? obj.Sum(a=>a.amount_pay).ToString("N2"):"0",
                    amount_receipt = obj.Count > 0 ? obj.Sum(a=>a.amount_receipt).ToString("N2"):"0",
                    amount_other = obj.Count > 0 ? obj.Sum(a=>a.amount_other).ToString("N2"):"0",
                    amount_end = obj.Count > 0 ? obj.Sum(a=>a.amount_end).ToString("N2"):"0",
                }
            });
        }

        /// <summary>
        /// 更新物流供应商往来报表的调整金额
        /// </summary>
        /// <param name="name">供应商名称</param>
        /// <param name="day">日期</param>
        /// <param name="amount">调整金额</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult UpdateSupplierTrancation(string name, DateTime day, decimal amount)
        {
            var user = HttpContextHelper.Current?.User;
            
            var obj = new Services.LogisticsServices().UpdateSupplierTrancation(day, name, amount, (user != null ? user.GetUid() : 0), (user != null ? user.GetUserName() : ""));

            return Json(new {
                success = string.IsNullOrEmpty(obj),
                msg = obj
            });
        }

        /// <summary>
        /// 物流供应商
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListLogisticsSupplier()
        {
            var list = new Services.LogisticsServices().ListSupplier();

            return Json(list);
        }

    }
}