﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Warehouse
{
    /// <summary>
    /// 仓库冗余报告
    /// </summary>
    public class dc_mid_skuwarehouse_redundancy
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// sku标题
        /// </summary>
        public string bailun_sku_name { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 产品个数
        /// </summary>
        public int productcount { get; set; }

        /// <summary>
        /// 库存总金额
        /// </summary>
        public decimal amount_total { get; set; }

        /// <summary>
        /// 日销产品个数（7日）
        /// </summary>
        public decimal daily_productsale_count { get; set; }

        /// <summary>
        /// 动销产品比例
        /// </summary>
        public decimal productsale_rate { get; set; }

        /// <summary>
        /// 日销金额
        /// </summary>
        public decimal dailysale_amount { get; set; }

        /// <summary>
        /// 动销金额比例
        /// </summary>
        public decimal saleamount_rate { get; set; }

        /// <summary>
        /// 冗余产品个数
        /// </summary>
        public int redundancy_product_count { get; set; }

        /// <summary>
        /// 冗余个数比例
        /// </summary>
        public decimal redundancy_product_rate { get; set; }

        /// <summary>
        /// 冗余产品金额
        /// </summary>
        public decimal redundancy_amount { get; set; }

        /// <summary>
        /// 冗余产品金额比例
        /// </summary>
        public decimal redundancy_amount_rate { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public int yesterdaysale_count { get; set; }

        /// <summary>
        /// 昨日销售金额
        /// </summary>
        public decimal yesterdaysale_amount { get; set; }

        /// <summary>
        /// 过去3天日均
        /// </summary>
        public decimal sale_3d_avg { get; set; }

        /// <summary>
        /// 过去7天日均
        /// </summary>
        public decimal sale_7d_avg { get; set; }

        /// <summary>
        /// 过去14天日均
        /// </summary>
        public decimal sale_14d_avg { get; set; }

        /// <summary>
        /// 过去30天日均
        /// </summary>
        public decimal sale_30d_avg { get; set; }

        /// <summary>
        /// 日周转率
        /// </summary>
        public decimal day_turnover_rate { get; set; }

        /// <summary>
        /// 周周转率
        /// </summary>
        public decimal week_turnover_rate { get; set; }

        /// <summary>
        /// 月周转率
        /// </summary>
        public decimal month_turnover_rate { get; set; }

        /// <summary>
        /// 缺货数
        /// </summary>
        public int stockout { get; set; }

        /// <summary>
        /// 统计日期
        /// </summary>
        public DateTime day { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }

        /// <summary>
        /// sku个数
        /// </summary>
        public int skucount { get; set; }

        /// <summary>
        /// 日销sku个数
        /// </summary>
        public int skusales_count { get; set; }

        /// <summary>
        /// 动销sku比例
        /// </summary>
        public decimal skusales_rate { get; set; }

        /// <summary>
        /// 冗余sku个数
        /// </summary>
        public int redundancy_sku_count { get; set; }

        /// <summary>
        /// 冗余sku个数比例
        /// </summary>
        public decimal redundancy_sku_rate { get; set; }

        /// <summary>
        /// 在途数
        /// </summary>
        public int onway_count { get; set; }

        /// <summary>
        /// sku产品编码
        /// </summary>
        public string sku_product_code { get; set; }

        /// <summary>
        /// sku分类id
        /// </summary>
        public int bailun_category_id { get; set; }

        /// <summary>
        /// sku分类
        /// </summary>
        public string bailun_category_name { get; set; }


        /// <summary>
        /// 监控状态，0:正在监控，1：停止监控
        /// </summary>
        public int monitorstatus { get; set; }

        /// <summary>
        /// 是否侵权，1：已侵权，0：未侵权
        /// </summary>
        public int tortstatus { get; set; }
    }
}
