﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Orders
{
    /// <summary>
    /// 亚马逊销售统计Model
    /// </summary>
    public class mAmazonStatistics
    {
        /// <summary>
        /// 平台
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 销售帐号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 商品收入
        /// </summary>
        public decimal amount_product { get; set; }

        /// <summary>
        /// 产品成本
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 亚马逊fba费
        /// </summary>
        public decimal fba_fee { get; set; }

        /// <summary>
        /// 平台佣金
        /// </summary>
        public decimal platform_fee { get; set; }

        /// <summary>
        /// 头程费
        /// </summary>
        public decimal head_fee { get; set; }

        /// <summary>
        /// 销售数量
        /// </summary>
        public int order_count { get; set; }

        /// <summary>
        /// fba销售数量
        /// </summary>
        public int fba_salecount { get; set; }

        /// <summary>
        /// 非fba销售数量
        /// </summary>
        public int nofba_salecount { get; set; }

        /// <summary>
        /// 提现损耗
        /// </summary>
        public decimal loss_withdrawal { get; set; }

        /// <summary>
        /// 总支出
        /// </summary>
        public decimal cost_count { get; set; }

        /// <summary>
        /// 非fba预测物流费用
        /// </summary>
        public decimal nofba_forecast_logisticsfee { get; set; }

        /// <summary>
        /// 非fba实际物流费
        /// </summary>
        public decimal nofba_logisticsfee { get; set; }

        /// <summary>
        /// fba利润
        /// </summary>
        public decimal fba_profit { get; set; }

        /// <summary>
        /// 非FBA预测利润
        /// </summary>
        public decimal nofba_forecast_profit { get; set; }

        /// <summary>
        /// 非FBA实际利润
        /// </summary>
        public decimal nofba_profit { get; set; }

        /// <summary>
        /// 总预测利润
        /// </summary>
        public decimal forecast_profit_count { get; set; }

        /// <summary>
        /// 总预测利润率%
        /// </summary>
        public decimal forecast_profit_rate { get; set; }

        /// <summary>
        /// 总实际利润
        /// </summary>
        public decimal profit_count { get; set; }

        /// <summary>
        /// 总实际利润率
        /// </summary>
        public decimal profit_rate { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string order_currency { get; set; }

        /// <summary>
        /// 预收款（已经收款未发货的这部分订单）
        /// </summary>
        public decimal amount_prepaid { get; set; }

        /// <summary>
        /// 退款金额
        /// </summary>
        public decimal amount_refund { get; set; }

        /// <summary>
        /// fba费用
        /// </summary>
        public decimal cost_fba_fee { get; set; }

        /// <summary>
        /// paypal费用
        /// </summary>
        public decimal cost_paypal_fee { get; set; }

        /// <summary>
        /// 包装费用
        /// </summary>
        public decimal cost_package { get; set; }

        /// <summary>
        /// 未发货订单数
        /// </summary>
        public int noshippingcount { get; set; }

    }



}
