﻿using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using MySql.Data.MySqlClient;
using Bailun.DC.Models.Menu;
using System.Linq;

namespace Bailun.DC.Services
{
    /// <summary>
    /// 采购管理服务
    /// </summary>
    public class MenuServices
    {
        public List<Models.Menu.dc_menu> ListMenu(string username)
        {
            var list = new List<dc_menu>();
            var obj = new List<dc_menu>();

            var sql = $@"select * from (select t1.id,t1.parentid,t1.icon,t1.`name`,t1.path,t1.sort from dc_menu t1 
                        join dc_menu_permission t2 on t1.id=t2.menuid and t2.delstatus=0 and t2.username='{username}'
                        where t1.delstatus=0
                        union all
                        select t1.id,t1.parentid,t1.icon,t1.`name`,t1.path,t1.sort from dc_menu t1 where t1.delstatus=0 and 1 = (select isall from dc_menu_permission where username='{username}' and isall=1 and delstatus=0)) tb order by parentid,sort";
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                obj = cn.Query<dc_menu>(sql, null, null, true, 2 * 60).ToList();
            }

            foreach (var item in obj.Where(a=>a.parentid==0))
            {
                GetChildrens(item, obj);
                list.Add(item);
            }

            return list;
        }

        /// <summary>
        /// 检测用户是否有权限访问菜单
        /// </summary>
        /// <param name="menuname">菜单名称</param>
        /// <param name="username">用户名</param>
        /// <returns></returns>
        public bool CheckPermission(string menuname, string username)
        {
            var sql = $@"select count(id) from (select t1.* from dc_menu t1 
                        join dc_menu_permission t2 on t1.id=t2.menuid and t2.delstatus=0 and t2.username='{username}'
                        where t1.delstatus=0 and t1.name='{menuname}'
                        union all
                        select * from dc_menu where 1 = (select isall from dc_menu_permission where username='{username}' and isall=1 and delstatus=0)) tb";

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var result = cn.QueryFirstOrDefault<int>(sql, null, null, 2 * 60);

                return result > 0;

            }
        }

        #region Private

        private void GetChildrens(dc_menu m, List<dc_menu> list)
        {
            m.childrens = new List<dc_menu>();
            var childrens = list.Where(a => a.parentid == m.id);
            if (childrens.Count() > 0)
            {
                foreach(var item in childrens)
                {
                    GetChildrens(item, list);
                    m.childrens.Add(item);
                }
            }
        }

        #endregion
    }
}
