﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{

    /// <summary>
    /// 月销售利润报表参数
    /// </summary>
    public class mMonthSaleProfit_Input
    {
        /// <summary>
        /// 月份
        /// </summary>
        public string month { get; set; }

        /// <summary>
        /// 成本
        /// </summary>
        public decimal? cost_sale_ { get; set; }

        /// <summary>
        /// 平台的物流费
        /// </summary>
        public decimal? pt_platform_logistics_fee_ { get; set; }

        /// <summary>
        /// 广告及宣传费-订阅费
        /// </summary>
        public decimal? pt_platform_ad_subscribe_fee_ { get; set; }


        /// <summary>
        /// 平台的仓储费
        /// </summary>
        public decimal? pt_platform_storage_fee { get; set; }

        /// <summary>
        /// 头程费
        /// </summary>
        public decimal? ls_head_cost_ { get; set; }

        /// <summary>
        /// 尾程费
        /// </summary>
        public decimal? ls_tail_cost_ { get; set; }

        /// <summary>
        /// 海外仓的仓储费
        /// </summary>
        public decimal? ls_oversea_storage { get; set; }

        /// <summary>
        /// 处理费
        /// </summary>
        public decimal? handlingcharges { get; set; }

        /// <summary>
        /// 直接支付的与销售平台相关费用
        /// </summary>
        public decimal? payfor_platform_related_fee { get; set; }

        /// <summary>
        /// 管理成本-香港百伦（不含直接支付的与销售平台相关的费用）
        /// </summary>
        public decimal? manager_cost_hkbailun { get; set; }

        /// <summary>
        /// 管理成本-广州百伦
        /// </summary>
        public decimal? manager_cost_gzbailun { get; set; }

        /// <summary>
        /// 管理成本-成品仓（不含直接支付的与销售平台相关的费用）
        /// </summary>
        public decimal? manager_cost_finish_wh { get; set; }

        /// <summary>
        /// 财务费用
        /// </summary>
        public decimal? finance_fee { get; set; }

        /// <summary>
        /// 加：其他收入
        /// </summary>
        public decimal? other_incoming { get; set; }

        /// <summary>
        /// 加：营业外收入
        /// </summary>
        public decimal? nonbusiness_income { get; set; }

        /// <summary>
        /// 减：营业外支出
        /// </summary>
        public decimal? nonbusiness_pay { get; set; }

        /// <summary>
        /// 减：分红
        /// </summary>
        public decimal? participation_in_profit { get; set; }
    }
}
